/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dme.application;

import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.DmeCacheProvider;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.ParamClient;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.ParamError;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.task.TaskError;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.task.TaskInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.infrastructure.provider.ManageFusionComputeProvider;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.infrastructure.provider.ServiceProvider;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.infrastructure.provider.ServiceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.ExecutorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.exception.DmeException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.FcRequestUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.kms.AkSk;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcClientService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ResponseUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DmeInstallServiceFitImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DmeInstallServiceFitImpl.class);
    private static final String DME_KMS_NAME = "AutoCreatedDmeKmsKeys";
    private Map<String, String> config;
    private final ServiceProvider serviceProvider;
    private final DmeCacheProvider cacheProvider;
    private final ParamClient paramClient;

    public synchronized void start(Map<String, String> config) {
        if (this.cacheProvider.isTaskRunning()) {
            throw new DmeException(TaskError.STATE_RUNNING);
        }
        this.cacheProvider.resetCache();
        this.cacheProvider.setInitTaskInfoCache();
        this.config = config;
        ExecutorUtils.execute(() -> {
            if (this.isInitSuccess()) {
                this.serviceProvider.start();
            }
        });
    }

    public void stop() {
        if (!this.cacheProvider.isTaskRunning()) {
            return;
        }
        this.serviceProvider.stop();
    }

    public Response<Boolean> isEnable() {
        try {
            ServiceUtils.getDeployToolPath();
            return ResponseUtils.success((Object)true);
        }
        catch (DmeException dmeException) {
            return ResponseUtils.failed((String)dmeException.getErrorMessage(), (String)dmeException.getSuggestMessage());
        }
    }

    private boolean isInitSuccess() {
        TaskInfo initTaskInfo = this.cacheProvider.getInitTaskInfo();
        try {
            initTaskInfo.start();
            this.cacheProvider.refreshTaskInfo();
            this.serviceProvider.uninstall();
            this.serviceProvider.init();
            this.tryToUpdateAkSkInConfig();
            ManageFusionComputeProvider.getInstance().doMangeFusionCompute(this.config);
            this.cleanEnvironmentByConfig();
            initTaskInfo.end();
        }
        catch (DmeException dmeException) {
            initTaskInfo.error(dmeException);
        }
        return !initTaskInfo.isError();
    }

    private void cleanEnvironmentByConfig() {
        this.paramClient.setConfigParam(this.config);
        this.serviceProvider.cleanEnvironment();
    }

    private void tryToUpdateAkSkInConfig() {
        if (!this.isAkSkConfigNeeded()) {
            return;
        }
        try {
            log.info("Start to update Ak/SK in config.");
            FcLoginInfo fcLoginInfo = this.getFcLoginInfo();
            ApiClient apiService = FcClientService.createApiService((FcLoginInfo)fcLoginInfo);
            String ak = apiService.queryAkByName(DME_KMS_NAME).orElse("");
            AkSk akSk = StringUtils.isNotEmpty((CharSequence)ak) ? apiService.resetAkSk(ak) : apiService.createAkSk(DME_KMS_NAME);
            this.config.put("DMEData_kms_server_ip", this.config.get("vm_fc_url"));
            this.config.put("DMEData_FC_Gandalf_password", this.config.get("vm_gandalf_password"));
            this.config.put("DMEData_FC_root_password", this.config.get("vm_root_password"));
            this.config.put("DMEData_kms_ak_password", akSk.getAk());
            this.config.put("DMEData_kms_sk_password", akSk.getSk());
        }
        catch (FcTaskException e) {
            log.error("Update AK/SK in config failed", (Throwable)e);
            throw new DmeException(ParamError.KMS_INVALID);
        }
    }

    private FcLoginInfo getFcLoginInfo() {
        return FcLoginInfo.builder().url(FcRequestUtils.toFcUrl((String)this.config.get("vm_fc_url"))).user(this.config.get("vm_fc_user")).password(this.config.get("vm_fc_password")).build();
    }

    private boolean isAkSkConfigNeeded() {
        if (!Objects.equals(this.config.get("DMEData_sm_option"), "YES") || !Objects.equals(this.config.get("DMEData_kms_option"), "YES")) {
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.config.get("DMEData_kms_ak_password")) && StringUtils.isNotEmpty((CharSequence)this.config.get("DMEData_kms_sk_password"))) {
            log.warn("Already have AK/SK in config. Skip updating AK/SK.");
            return false;
        }
        if (!Objects.equals(this.config.get("vm_auto_create"), "true")) {
            log.warn("Haven't create FusionCompute automatically. Updating AK/SK in config failed.");
            return false;
        }
        return true;
    }

    @Generated
    public DmeInstallServiceFitImpl(ServiceProvider serviceProvider, DmeCacheProvider cacheProvider, ParamClient paramClient) {
        this.serviceProvider = serviceProvider;
        this.cacheProvider = cacheProvider;
        this.paramClient = paramClient;
    }
}

