/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dme.application;

import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.deploy.virtualization.deploydme.entity.ResultInfoBo;
import com.huawei.yinglong.river.deploy.virtualization.deploydme.entity.TaskInfoBo;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.application.DmeAssembler;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.DmeCacheProvider;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.task.GeneralTask;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.task.TaskClient;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.task.TaskError;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.task.TaskInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.exception.DmeException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ResponseUtils;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.mapstruct.factory.Mappers;
import org.springframework.stereotype.Component;

@Component
public class DmeInstallTaskFitImpl {
    private final DmeAssembler assembler = (DmeAssembler)Mappers.getMapper(DmeAssembler.class);
    private final TaskClient taskClient;
    private final DmeCacheProvider cacheProvider;

    public void skipTask(String taskKey) {
        this.dealFailedTask(taskKey, this.taskClient::skipTask);
    }

    public void retryTask(String taskKey) {
        this.dealFailedTask(taskKey, this.taskClient::retryTask);
    }

    public List<TaskInfoBo> getTaskProgress() {
        return this.cacheProvider.getTaskInfos().stream().map(this.assembler::toBo).collect(Collectors.toList());
    }

    public Response<DeployTaskInfoVo> queryDeployDetails(String taskId) {
        DeployTaskInfoVo deployTaskInfo = this.assembler.toVo(this.cacheProvider.getTaskResult());
        this.fillTaskChildren(deployTaskInfo);
        return ResponseUtils.success((Object)deployTaskInfo);
    }

    private void fillTaskChildren(DeployTaskInfoVo deployTaskInfo) {
        List<TaskInfo> taskInfos = this.cacheProvider.getTaskInfos();
        List parentTasks = taskInfos.stream().filter(task -> !task.isSubTask()).collect(Collectors.toList());
        deployTaskInfo.setChildren(parentTasks.stream().map(parentTask -> this.assembler.toDetailVo((TaskInfo)parentTask, taskInfos.stream().filter(taskInfo -> Objects.equals(parentTask.getId(), taskInfo.getParentTaskId())).collect(Collectors.toList()))).collect(Collectors.toList()));
    }

    public ResultInfoBo getInstallResult() {
        return this.assembler.toBo(this.cacheProvider.getTaskResult());
    }

    private void dealFailedTask(String taskKey, Consumer<TaskInfo> action) {
        TaskInfo failedTask = this.getFailedTask(taskKey);
        action.accept(failedTask);
        this.cacheProvider.resetCache();
        this.cacheProvider.refreshTaskInfo();
    }

    private TaskInfo getFailedTask(String taskKey) {
        return this.cacheProvider.getTaskInfos().stream().filter(taskInfo -> Objects.equals(taskKey, taskInfo.getKey())).filter(GeneralTask::isError).findFirst().orElseThrow(DmeException.thr(TaskError.GET_TASK_FAIL));
    }

    @Generated
    public DmeInstallTaskFitImpl(TaskClient taskClient, DmeCacheProvider cacheProvider) {
        this.taskClient = taskClient;
        this.cacheProvider = cacheProvider;
    }
}

