/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dme.domain;

import com.alibaba.fastjson.JSON;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.ParamClient;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.ParamTemplate;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.task.GeneralTask;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.task.TaskClient;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.task.TaskError;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.task.TaskInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.ExecutorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.cache.CacheUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.exception.DmeException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DmeCacheProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DmeCacheProvider.class);
    private static final String PARAM_CACHE_KEY = "dme#param";
    private static final String INIT_TASK_CACHE_KEY = "dme#initTask";
    private static final String TASK_CACHE_KEY = "dme#task";
    private static final String RESULT_CACHE_KEY = "dme#result";
    private final ParamClient paramClient;
    private final TaskClient taskClient;

    public List<ParamTemplate> getParamTemplates() {
        List templates = (List)CacheUtils.getCache(PARAM_CACHE_KEY);
        return Optional.ofNullable(templates).orElse(Collections.emptyList());
    }

    public GeneralTask getTaskResult() {
        GeneralTask task = (GeneralTask)CacheUtils.getCache(RESULT_CACHE_KEY);
        return Optional.ofNullable(task).orElse(GeneralTask.EMPTY_TASK);
    }

    public TaskInfo getInitTaskInfo() {
        TaskInfo initTask = (TaskInfo)CacheUtils.getCache(INIT_TASK_CACHE_KEY);
        return Optional.ofNullable(initTask).orElseThrow(DmeException.thr(TaskError.GET_TASK_FAIL));
    }

    public List<TaskInfo> getTaskInfos() {
        List taskInfos = (List)CacheUtils.getCache(TASK_CACHE_KEY);
        return Optional.ofNullable(taskInfos).orElse(Collections.emptyList());
    }

    public void refreshTaskInfo() {
        ExecutorUtils.scheduleWithFixedDelay(() -> {
            try {
                this.updateTaskAndResult();
                this.shutDownScheduleIfTaskEnd();
            }
            catch (DmeException e) {
                log.error("query dme task info and result failed.", (Throwable)e);
                ThreadUtils.threadSafeSleep((int)30, (TimeUnit)TimeUnit.SECONDS);
            }
        });
    }

    public boolean isTaskRunning() {
        return this.getTaskResult().isRunning();
    }

    public void initCache() {
        try {
            CacheUtils.putCache(PARAM_CACHE_KEY, this.paramClient.getAllParamTemplate());
            this.setInitTaskInfoCache();
        }
        catch (DmeException exception) {
            log.error("init cache failed.", (Throwable)exception);
        }
    }

    public void resetCache() {
        CacheUtils.removeCache(TASK_CACHE_KEY);
        GeneralTask taskResult = this.getTaskResult();
        taskResult.start();
        CacheUtils.putCache(RESULT_CACHE_KEY, taskResult);
    }

    private void shutDownScheduleIfTaskEnd() {
        if (!this.isTaskRunning()) {
            ExecutorUtils.shutDownScheduleService();
        }
    }

    private void updateTaskAndResult() {
        CacheUtils.putCache(TASK_CACHE_KEY, this.getTaskInfoWithInit());
        if (this.isTaskFinish()) {
            TaskInfo taskInfo = this.getCurrentTaskInfo();
            GeneralTask taskResult = this.getTaskResult();
            taskResult.finish(taskInfo.getState(), taskInfo.getEndTime());
            CacheUtils.putCache(RESULT_CACHE_KEY, taskResult);
        }
    }

    private boolean isTaskFinish() {
        List<TaskInfo> taskInfos = this.getTaskInfos();
        return taskInfos.stream().anyMatch(GeneralTask::isError) || taskInfos.stream().allMatch(GeneralTask::isEnd);
    }

    private TaskInfo getCurrentTaskInfo() {
        return this.getTaskInfos().stream().filter(taskInfo -> Objects.nonNull(taskInfo.getStartTime())).max(Comparator.comparing(GeneralTask::getStartTime)).orElseThrow(DmeException.thr(TaskError.GET_TASK_FAIL));
    }

    private List<TaskInfo> getTaskInfoWithInit() {
        List<TaskInfo> taskInfoList = this.taskClient.getTaskProgress();
        if (CollectionUtils.isEmpty(taskInfoList)) {
            return Collections.singletonList(this.getInitTaskInfo());
        }
        taskInfoList.add(0, this.getInitTaskInfo());
        return taskInfoList;
    }

    public void setInitTaskInfoCache() {
        try {
            String taskStr = IOUtils.resourceToString((String)"/initTaskInfo.json", (Charset)StandardCharsets.UTF_8);
            TaskInfo taskInfo = (TaskInfo)JSON.parseObject((String)taskStr, TaskInfo.class);
            CacheUtils.putCache(INIT_TASK_CACHE_KEY, taskInfo);
        }
        catch (IOException exception) {
            log.error("init task cache failed.", (Throwable)exception);
        }
    }

    @Generated
    public DmeCacheProvider(ParamClient paramClient, TaskClient taskClient) {
        this.paramClient = paramClient;
        this.taskClient = taskClient;
    }
}

