/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dme.domain;

import com.google.common.collect.ArrayListMultimap;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.LanguageCombination;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.ParamError;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.ParamTemplate;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.file.FileInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.exception.DmeExceptionResourceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.valid.DmeValidUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.valid.ValidResourceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.valid.UsernameCommonValidUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public final class DmeParamValidProvider {
    public static final Map<String, Function<String, ErrorKey>> PARAM_EXTEND_VALID = new HashMap<String, Function<String, ErrorKey>>();
    private static final List<String> VM_PARAM_BASE_KEY = Arrays.asList("DMEData_deploy_scale", "DMEData_CPU_architecture", "DMEData_package_path", "DMEData_system_language", "DMEData_deploy_system", "DMEData_deploy_node_number", "DMEData_open_sftpd", "DMEData_nic", "DMEData_sm_option", "DMEData_kms_option", "DMEData_deploy_edi_plat", "DMEData_deploy_tenant", "DMEData_FC_basic_manage");
    private static final List<String> GENERAL_PASSWORD_KEY = Arrays.asList("DMEData_deploy_password", "DMEData_om_password", "DMEData_sopuser_password", "DMEData_ossadm_password", "DMEData_ossuser_password", "DMEData_zenith_sys_password", "DMEData_redis_dbuser_password", "DMEData_rabbitmq_password", "DMEData_protect_pvalue_password", "DMEData_er_cert_password", "DMEData_es_password", "DMEData_ETCD_password", "DMEData_ETCD_root_password", "DMEData_sftpuser_password");
    private static final List<String> HOST_KEY = Arrays.asList("DMEData_hostname1", "DMEData_hostname2", "DMEData_hostname3", "DMEData_tenant_hostname1", "DMEData_tenant_hostname2", "DMEData_ccs_hostname1", "DMEData_ccs_hostname2", "DMEData_dcsas_hostname1", "DMEData_dcsas_hostname2");
    private static final String PARAM_IP_KEY = "ip";
    private static final List<String> BASE_PARAM_KEYS = Arrays.asList("DMEData_hostname1", "DMEData_ip1", "DMEData_root_password1", "vm_cna_name1", "vm_size_gb1", "DMEData_hostname2", "DMEData_ip2", "DMEData_root_password2", "vm_cna_name2", "vm_size_gb2", "DMEData_hostname3", "DMEData_ip3", "DMEData_root_password3", "vm_cna_name3", "vm_size_gb3", "DMEData_float_ip", "DMEData_lvs_ip");
    private static final List<String> TENANT_PARAM_KEYS = Arrays.asList("DMEData_tenant_float_ip", "DMEData_tenant_glb_dip", "DMEData_tenant_ip1", "DMEData_tenant_ip2", "DMEData_tenant_hostname1", "DMEData_tenant_hostname2", "tenant_cna_name1", "tenant_cna_name2", "DMEData_tenant_password1", "DMEData_tenant_password2", "tenant_size_gb1", "tenant_size_gb2", "DMEData_sdn_scene", "DMEData_auth_type", "DMEData_deploy_backup");
    private static final List<String> CONTAINER_CLUSTER_SERVICE_NODE = Arrays.asList("DMEData_ccs_hostname1", "DMEData_ccs_hostname2", "DMEData_ccs_ip1", "DMEData_ccs_internal_ip1", "DMEData_ccs_ip2", "DMEData_ccs_internal_ip2", "DMEData_ccs_password1", "DMEData_ccs_password2", "DMEData_ccs_float_ip", "DMEData_ccs_internal_float_ip", "DMEData_ccs_glb_dip");
    private static final List<String> DCSAS_SERVICE_NODE = Arrays.asList("DMEData_deploy_dcsas", "DMEData_dcsas_hostname1", "DMEData_dcsas_hostname2", "DMEData_dcsas_ip1", "DMEData_dcsas_ip2", "DMEData_dcsas_password1", "DMEData_dcsas_password2", "dcs_cna_name1", "dcs_cna_name2", "dcs_size_gb1", "dcs_size_gb2");

    public static List<String> validConfig(Map<String, String> config, List<ParamTemplate> paramTemplates) {
        List<String> message = DmeParamValidProvider.validBase(config, paramTemplates);
        message.addAll(DmeParamValidProvider.validBasePassword(config, paramTemplates));
        message.addAll(DmeParamValidProvider.validParamEmpty(config));
        DmeParamValidProvider.validRepeatIp(config, paramTemplates).ifPresent(message::add);
        DmeParamValidProvider.validHostName(config, paramTemplates).ifPresent(message::add);
        DmeParamValidProvider.validKmsFcIpRepeated(config).ifPresent(message::add);
        message.addAll(DmeParamValidProvider.validBaseNodeInfo(config, paramTemplates));
        message.addAll(DmeParamValidProvider.validTenantNode(config, paramTemplates));
        DmeParamValidProvider.validCcsScene(config).ifPresent(message::add);
        message.addAll(DmeParamValidProvider.validCcsNode(config, paramTemplates));
        DmeParamValidProvider.validDcsasScene(config).ifPresent(message::add);
        message.addAll(DmeParamValidProvider.validDcsasNodeInfo(config, paramTemplates));
        message.addAll(DmeParamValidProvider.validDisk(config));
        message.addAll(DmeParamValidProvider.validManageFcParams(config));
        message.addAll(DmeParamValidProvider.validFileInfo(config));
        DmeParamValidProvider.validImsPackage(config).ifPresent(message::add);
        return message;
    }

    private static Optional<String> validImsPackage(Map<String, String> config) {
        Optional<File> dmeDataPackagePath = Arrays.stream(DmeParamValidProvider.createDmeFiles(config.get("DMEData_package_path"))).filter(path -> ConsistencyPattern.isMatchDmeDataX86SoftwarePackage((String)path.getName()) || ConsistencyPattern.isMatchDmeDataArmSoftwarePackage((String)path.getName())).findFirst();
        if (dmeDataPackagePath.isPresent() && DmeParamValidProvider.isTenantDeploy(config) && DmeParamValidProvider.geteDmeVersion(dmeDataPackagePath.get().getName()) > 23 && Arrays.stream(DmeParamValidProvider.createDmeFiles(config.get("DMEData_package_path"))).noneMatch(path -> ConsistencyPattern.isMatchDmeImsSoftwarePackage((String)path.getName()))) {
            return Optional.of(ValidResourceUtils.getMessage("dme.ims.software.exist"));
        }
        return Optional.empty();
    }

    private static int geteDmeVersion(String eDmePackageName) {
        return Integer.parseInt(eDmePackageName.substring(5, 7));
    }

    private static List<String> validDcsasNodeInfo(Map<String, String> config, List<ParamTemplate> paramTemplates) {
        if (!DmeParamValidProvider.isDcsasDeploy(config)) {
            return Collections.emptyList();
        }
        List<String> messages = DmeParamValidProvider.validBaseDmeInfo(config, paramTemplates, DCSAS_SERVICE_NODE);
        DmeParamValidProvider.validDcsasFile(config).ifPresent(messages::add);
        List<String> ips = Arrays.asList("DMEData_dcsas_ip1", "DMEData_dcsas_ip2");
        if (DmeParamValidProvider.isAutoCreateVm(config)) {
            DmeParamValidProvider.validNetworkSegment(config, DCSAS_SERVICE_NODE, "dme.dcsas.param").ifPresent(messages::add);
            DmeParamValidProvider.validNodeCnaName(config, Arrays.asList("dcs_cna_name1", "dcs_cna_name2"), messages, "dme.dcsas.cna");
            messages.addAll(DmeParamValidProvider.shouldIpUnreachable(ips, paramTemplates, config));
        } else {
            messages.addAll(DmeParamValidProvider.shouldIpReachable(ips, paramTemplates, config));
        }
        return messages;
    }

    private static List<String> validBaseNodeInfo(Map<String, String> config, List<ParamTemplate> paramTemplates) {
        List<String> messages = DmeParamValidProvider.validBaseDmeInfo(config, paramTemplates, BASE_PARAM_KEYS);
        messages.addAll(DmeParamValidProvider.shouldIpUnreachable(Arrays.asList("DMEData_float_ip", "DMEData_lvs_ip"), paramTemplates, config));
        List<String> ips = Arrays.asList("DMEData_ip1", "DMEData_ip2", "DMEData_ip3");
        if (DmeParamValidProvider.isAutoCreateVm(config)) {
            DmeParamValidProvider.validNetworkSegment(config, BASE_PARAM_KEYS, "dme.base.param").ifPresent(messages::add);
            DmeParamValidProvider.validNodeCnaName(config, Arrays.asList("vm_cna_name1", "vm_cna_name2"), messages, "dme.cna");
            messages.addAll(DmeParamValidProvider.shouldIpUnreachable(ips, paramTemplates, config));
        } else {
            messages.addAll(DmeParamValidProvider.shouldIpReachable(ips, paramTemplates, config));
        }
        return messages;
    }

    private static Optional<String> validCcsScene(Map<String, String> config) {
        if (!(!Objects.equals("YES", config.getOrDefault("DMEData_deploy_ccs", "NO")) || DmeParamValidProvider.isTenantDeploy(config) && Objects.equals("type2", config.getOrDefault("DMEData_sdn_scene", "type3")))) {
            return Optional.of(ValidResourceUtils.getMessage("dme.ccs.scene"));
        }
        return Optional.empty();
    }

    private static Optional<String> validDcsasScene(Map<String, String> config) {
        if (Objects.equals("YES", config.getOrDefault("DMEData_deploy_dcsas", "NO")) && !DmeParamValidProvider.isTenantDeploy(config)) {
            return Optional.of(ValidResourceUtils.getMessage("dme.dcsas.scene"));
        }
        return Optional.empty();
    }

    private static List<String> validCcsNode(Map<String, String> config, List<ParamTemplate> paramTemplates) {
        if (!DmeParamValidProvider.isCcsDeploy(config)) {
            return Collections.emptyList();
        }
        List<String> messages = DmeParamValidProvider.validBaseDmeInfo(config, paramTemplates, CONTAINER_CLUSTER_SERVICE_NODE);
        DmeParamValidProvider.validCcsFile(config).ifPresent(messages::add);
        messages.addAll(DmeParamValidProvider.shouldIpUnreachable(Arrays.asList("DMEData_ccs_float_ip", "DMEData_ccs_glb_dip"), paramTemplates, config));
        messages.addAll(DmeParamValidProvider.validCcsDomainInfo(config));
        messages.addAll(DmeParamValidProvider.validPublicDomainIpInSameSegment(config));
        List<String> ips = Arrays.asList("DMEData_ccs_ip1", "DMEData_ccs_ip2");
        if (DmeParamValidProvider.isAutoCreateVm(config)) {
            DmeParamValidProvider.validNetworkSegment(config, Arrays.asList("DMEData_ccs_float_ip", "DMEData_ccs_glb_dip", "DMEData_ccs_ip1", "DMEData_ccs_ip2"), "dme.container.cluster.param").ifPresent(messages::add);
            DmeParamValidProvider.validNodeCnaName(config, Arrays.asList("ccs_cna_name1", "ccs_cna_name2"), messages, "dme.ccs.cna");
            if (StringUtils.isEmpty((CharSequence)config.getOrDefault("ccs_domain_port_group", ""))) {
                messages.add(ValidResourceUtils.getMessage("dme.param.empty", Collections.singletonList(ValidResourceUtils.getMessage("dme.ccs.port.group"))));
            }
            if (!IpUtils.isValidNetmask((String)config.getOrDefault("ccs_domain_mask", ""))) {
                messages.add(ValidResourceUtils.getMessage("dme.valid.error", Collections.singletonList(ValidResourceUtils.getMessage("dme.ccs.netmask"))));
            }
            messages.addAll(DmeParamValidProvider.shouldIpUnreachable(ips, paramTemplates, config));
        } else {
            messages.addAll(DmeParamValidProvider.shouldIpReachable(ips, paramTemplates, config));
        }
        return messages;
    }

    private static List<String> validPublicDomainIpInSameSegment(Map<String, String> config) {
        ArrayList<String> messages = new ArrayList<String>();
        String dmeDataCcsInternalIp1 = config.getOrDefault("DMEData_ccs_internal_ip1", "");
        String dmeDataCcsInternalIp2 = config.getOrDefault("DMEData_ccs_internal_ip2", "");
        String dmeDataCcsInternalFloatIp = config.getOrDefault("DMEData_ccs_internal_float_ip", "");
        List<String> ips = Arrays.asList(dmeDataCcsInternalIp1, dmeDataCcsInternalIp2, dmeDataCcsInternalFloatIp);
        String ccsDomainGateway = config.getOrDefault("ccs_domain_gateway", "");
        String ccsDomainMask = config.getOrDefault("ccs_domain_mask", "");
        if (ips.stream().anyMatch(ip -> !IpUtils.checkNetworkRangeValid((String)ip, (String)ccsDomainMask, (String)ccsDomainGateway))) {
            messages.add(ValidResourceUtils.getMessage("dme.ccs.public.domain.ips.check"));
        }
        return messages;
    }

    private static List<String> validCcsDomainInfo(Map<String, String> config) {
        String validMessage;
        ArrayList<String> message = new ArrayList<String>();
        String ccsDomainGateway = config.getOrDefault("ccs_domain_gateway", "");
        String ccsDomainBmsVipSegment = config.getOrDefault("ccs_domain_bms_vip_segment", "");
        String ccsDomainClientSegment = config.getOrDefault("ccs_domain_client_segment", "");
        if (!IpUtils.isValidIpV4((String)ccsDomainGateway)) {
            validMessage = StringUtils.isEmpty((CharSequence)ccsDomainGateway) ? "dme.param.empty" : "dme.valid.error";
            message.add(ValidResourceUtils.getMessage(validMessage, Collections.singletonList(ValidResourceUtils.getMessage("dme.ccs.gateway"))));
        }
        if (!DmeParamValidProvider.isSegment(ccsDomainBmsVipSegment)) {
            validMessage = StringUtils.isEmpty((CharSequence)ccsDomainBmsVipSegment) ? "dme.param.empty" : "dme.valid.error";
            message.add(ValidResourceUtils.getMessage(validMessage, Collections.singletonList(ValidResourceUtils.getMessage("dme.ccs.bms.vip.segemnt"))));
        }
        if (!DmeParamValidProvider.isSegment(ccsDomainClientSegment)) {
            validMessage = StringUtils.isEmpty((CharSequence)ccsDomainClientSegment) ? "dme.param.empty" : "dme.valid.error";
            message.add(ValidResourceUtils.getMessage(validMessage, Collections.singletonList(ValidResourceUtils.getMessage("dme.ccs.client.segemnt"))));
        }
        if (ccsDomainBmsVipSegment.equals(ccsDomainClientSegment)) {
            message.add(ValidResourceUtils.getMessage("dme.ccs.segment.same"));
        }
        return message;
    }

    private static boolean isSegment(String ccsDomainBmsVipSegment) {
        if (StringUtils.isEmpty((CharSequence)ccsDomainBmsVipSegment)) {
            return false;
        }
        String[] split = ccsDomainBmsVipSegment.split("/");
        if (split.length != 2) {
            return false;
        }
        if (!IpUtils.isValidIpV4((String)split[0])) {
            return false;
        }
        if (!StringUtils.isNumeric((String)split[1])) {
            return false;
        }
        return Integer.parseInt(split[1]) >= 0 && Integer.parseInt(split[1]) <= 32;
    }

    private static List<String> validTenantNode(Map<String, String> config, List<ParamTemplate> paramTemplates) {
        if (!DmeParamValidProvider.isTenantDeploy(config)) {
            return Collections.emptyList();
        }
        List<String> messages = DmeParamValidProvider.validBaseDmeInfo(config, paramTemplates, TENANT_PARAM_KEYS);
        messages.addAll(DmeParamValidProvider.shouldIpUnreachable(Arrays.asList("DMEData_tenant_float_ip", "DMEData_tenant_glb_dip"), paramTemplates, config));
        List<String> ips = Arrays.asList("DMEData_tenant_ip1", "DMEData_tenant_ip2");
        if (DmeParamValidProvider.isAutoCreateVm(config)) {
            DmeParamValidProvider.validNetworkSegment(config, TENANT_PARAM_KEYS, "dme.tenant.param").ifPresent(messages::add);
            DmeParamValidProvider.validNodeCnaName(config, Arrays.asList("tenant_cna_name1", "tenant_cna_name2"), messages, "dme.tenant.cna");
            messages.addAll(DmeParamValidProvider.shouldIpUnreachable(ips, paramTemplates, config));
        } else {
            messages.addAll(DmeParamValidProvider.shouldIpReachable(ips, paramTemplates, config));
        }
        return messages;
    }

    private static List<String> validBaseDmeInfo(Map<String, String> config, List<ParamTemplate> paramTemplates, List<String> keys) {
        return paramTemplates.stream().map(paramTemplate -> paramTemplate.validate(config.getOrDefault(paramTemplate.getId(), ""), keys)).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }

    private static List<String> shouldIpReachable(List<String> params, List<ParamTemplate> paramTemplates, Map<String, String> config) {
        return paramTemplates.stream().filter(paramTemplate -> params.contains(paramTemplate.getId())).map(paramTemplate -> DmeParamValidProvider.getIpReachableMessage(paramTemplate, config)).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }

    private static String getIpReachableMessage(ParamTemplate paramTemplate, Map<String, String> config) {
        String ip = config.getOrDefault(paramTemplate.getId(), "");
        if (!IpUtils.isReachable((String)ip)) {
            return ValidResourceUtils.getMessage("dme.ip.reachable", Collections.singletonList(paramTemplate.getName().getDescription() + ip));
        }
        return "";
    }

    private static List<String> shouldIpUnreachable(List<String> params, List<ParamTemplate> paramTemplates, Map<String, String> config) {
        return paramTemplates.stream().filter(paramTemplate -> params.contains(paramTemplate.getId())).map(paramTemplate -> DmeParamValidProvider.getIpUnreachableMessage(paramTemplate, config)).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }

    private static String getIpUnreachableMessage(ParamTemplate paramTemplate, Map<String, String> config) {
        String ip = config.getOrDefault(paramTemplate.getId(), "");
        if (IpUtils.isReachable((String)ip)) {
            return ValidResourceUtils.getMessage("dme.ip.unreachable", Collections.singletonList(paramTemplate.getName().getDescription() + ip));
        }
        return "";
    }

    private static void validNodeCnaName(Map<String, String> config, List<String> cnaNames, List<String> messages, String key) {
        if (cnaNames.stream().anyMatch(cnaName -> StringUtils.isEmpty((CharSequence)config.getOrDefault(cnaName, "")))) {
            messages.add(ValidResourceUtils.getMessage("dme.param.empty", Collections.singletonList(ValidResourceUtils.getMessage(key))));
        }
    }

    private static List<String> validBasePassword(Map<String, String> config, List<ParamTemplate> paramTemplates) {
        return paramTemplates.stream().map(paramTemplate -> paramTemplate.validPassword(config.getOrDefault(paramTemplate.getId(), ""), GENERAL_PASSWORD_KEY)).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }

    private static List<String> validParamEmpty(Map<String, String> config) {
        List<String> fcInfos;
        ArrayList<String> message = new ArrayList<String>();
        if (DmeParamValidProvider.isAutoCreateVm(config) && (fcInfos = Arrays.asList("vm_fc_url", "vm_fc_user", "vm_fc_password")).stream().anyMatch(info -> StringUtils.isEmpty((CharSequence)config.getOrDefault(info, "")))) {
            message.add(ValidResourceUtils.getMessage("dme.fc.info"));
        }
        if (StringUtils.isEmpty((CharSequence)config.getOrDefault("vm_auto_create", ""))) {
            message.add(ValidResourceUtils.getMessage("dme.param.empty", Collections.singletonList(ValidResourceUtils.getMessage("dme.create.vm"))));
        }
        if (DmeParamValidProvider.isAutoCreateVm(config)) {
            if (StringUtils.isEmpty((CharSequence)config.getOrDefault("vm_netMask", ""))) {
                message.add(ValidResourceUtils.getMessage("dme.param.empty", Collections.singletonList(ValidResourceUtils.getMessage("dme.fc.netmask"))));
            }
            if (StringUtils.isEmpty((CharSequence)config.getOrDefault("vm_gateway", ""))) {
                message.add(ValidResourceUtils.getMessage("dme.param.empty", Collections.singletonList(ValidResourceUtils.getMessage("dme.fc.gateway"))));
            }
        }
        return message;
    }

    private static Collection<String> validDisk(Map<String, String> config) {
        if (!DmeParamValidProvider.isAutoCreateVm(config)) {
            return Collections.emptyList();
        }
        ArrayList<String> messages = new ArrayList<String>();
        if (IntStream.range(1, 4).mapToObj(i -> config.getOrDefault("vm_size_gb" + i, "0")).anyMatch(size -> Integer.parseInt(size) < 655)) {
            messages.add(ValidResourceUtils.getMessage("dme.param.vm.size"));
        }
        if (DmeParamValidProvider.isTenantDeploy(config) && IntStream.range(1, 3).mapToObj(i -> config.getOrDefault("tenant_size_gb" + i, "0")).anyMatch(size -> Integer.parseInt(size) < 875)) {
            messages.add(ValidResourceUtils.getMessage("dme.param.tenant.vm.size"));
        }
        if (DmeParamValidProvider.isCcsDeploy(config) && IntStream.range(1, 3).mapToObj(i -> config.getOrDefault("ccs_size_gb" + i, "0")).anyMatch(size -> Integer.parseInt(size) < 2955)) {
            messages.add(ValidResourceUtils.getMessage("dme.param.container.vm.size"));
        }
        if (DmeParamValidProvider.isDcsasDeploy(config) && IntStream.range(1, 3).mapToObj(i -> config.getOrDefault("dcs_size_gb" + i, "0")).anyMatch(size -> Integer.parseInt(size) < 555)) {
            messages.add(ValidResourceUtils.getMessage("dme.param.dcsas.vm.size"));
        }
        return messages;
    }

    private static Optional<String> validDcsasFile(Map<String, String> config) {
        if (DmeParamValidProvider.isDcsasDeploy(config)) {
            String dmeDataPackagePath = config.getOrDefault("DMEData_package_path", "");
            if (StringUtils.isEmpty((CharSequence)dmeDataPackagePath)) {
                return Optional.of(ValidResourceUtils.getMessage("dme.param.dcsas.product.package"));
            }
            File file = new File(dmeDataPackagePath);
            File[] files = file.listFiles();
            if (Objects.isNull(files)) {
                return Optional.of(ValidResourceUtils.getMessage("dme.param.dcsas.product.package"));
            }
            if (Arrays.stream(files).map(File::getName).noneMatch(ConsistencyPattern::isMatchDmeAsSoftwarePackage)) {
                return Optional.of(ValidResourceUtils.getMessage("dme.param.dcsas.product.package"));
            }
        }
        return Optional.empty();
    }

    private static Optional<String> validCcsFile(Map<String, String> config) {
        if (DmeParamValidProvider.isCcsDeploy(config)) {
            String dmeDataPackagePath = config.getOrDefault("DMEData_package_path", "");
            if (StringUtils.isEmpty((CharSequence)dmeDataPackagePath)) {
                return Optional.of(ValidResourceUtils.getMessage("dme.param.container.cluster.service.product.package"));
            }
            File file = new File(dmeDataPackagePath);
            File[] files = file.listFiles();
            if (Objects.isNull(files)) {
                return Optional.of(ValidResourceUtils.getMessage("dme.param.container.cluster.service.product.package"));
            }
            if (Arrays.stream(files).map(File::getName).noneMatch(ConsistencyPattern::isMatchDmeCssSoftwarePackage)) {
                return Optional.of(ValidResourceUtils.getMessage("dme.param.container.cluster.service.product.package"));
            }
        }
        return Optional.empty();
    }

    private static Optional<String> validNetworkSegment(Map<String, String> config, List<String> keys, String message) {
        String gateway;
        String netmask = config.get("vm_netMask");
        if (!DmeParamValidProvider.checkIpsInSameNetworkSegment(config, netmask, gateway = config.get("vm_gateway"), keys)) {
            return Optional.of(ValidResourceUtils.getMessage(message));
        }
        return Optional.empty();
    }

    private static boolean checkIpsInSameNetworkSegment(Map<String, String> config, String netmask, String gateway, List<String> keys) {
        return keys.stream().filter(key -> key.contains(PARAM_IP_KEY)).map(config::get).filter(StringUtils::isNotEmpty).allMatch(ip -> IpUtils.checkNetworkRangeValid((String)ip, (String)netmask, (String)gateway));
    }

    private static Optional<String> validRepeatIp(Map<String, String> config, List<ParamTemplate> paramTemplates) {
        Set<String> repeatIps = DmeParamValidProvider.getInvalidParamKeys(config, key -> key.contains(PARAM_IP_KEY) && StringUtils.isNotEmpty((CharSequence)((CharSequence)config.get(key))), String::equals);
        if (CollectionUtils.isNotEmpty(repeatIps)) {
            return Optional.of(DmeParamValidProvider.buildErrorMessage(ParamError.IP_REPEAT, repeatIps, paramTemplates));
        }
        return Optional.empty();
    }

    private static Optional<String> validHostName(Map<String, String> config, List<ParamTemplate> paramTemplates) {
        Set<String> repeatHosts = DmeParamValidProvider.getInvalidParamKeys(config, HOST_KEY::contains, String::equals);
        if (CollectionUtils.isNotEmpty(repeatHosts)) {
            return Optional.of(DmeParamValidProvider.buildErrorMessage(ParamError.HOST_REPEAT, repeatHosts, paramTemplates));
        }
        Set<String> containHosts = DmeParamValidProvider.getInvalidParamKeys(config, HOST_KEY::contains, (other, value) -> other.contains((CharSequence)value) || value.contains((CharSequence)other));
        if (CollectionUtils.isNotEmpty(containHosts)) {
            return Optional.of(DmeParamValidProvider.buildErrorMessage(ParamError.HOST_CONTAIN, containHosts, paramTemplates));
        }
        return Optional.empty();
    }

    private static String buildErrorMessage(ErrorKey errorKey, Set<String> paramKeys, List<ParamTemplate> paramTemplates) {
        String paramNames = paramKeys.stream().map(key -> DmeParamValidProvider.buildRepeatMessage(paramTemplates, key)).collect(Collectors.joining(","));
        return DmeExceptionResourceUtils.getErrorMessage(errorKey.getKey(), Collections.singletonList(paramNames));
    }

    private static String buildRepeatMessage(List<ParamTemplate> paramTemplates, String key) {
        List collect = Arrays.stream(key.split(",")).collect(Collectors.toList());
        List params = collect.stream().map(param -> DmeParamValidProvider.getParamName(paramTemplates, param)).collect(Collectors.toList());
        return params.toString();
    }

    private static Set<String> getInvalidParamKeys(Map<String, String> config, Predicate<String> keyFilter, BiPredicate<String, String> valueValidator) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        for (Map.Entry<String, String> entry2 : config.entrySet()) {
            if (!DmeParamValidProvider.isTenantDeploy(config) && TENANT_PARAM_KEYS.contains(entry2.getKey()) || !DmeParamValidProvider.isCcsDeploy(config) && CONTAINER_CLUSTER_SERVICE_NODE.contains(entry2.getKey()) || !DmeParamValidProvider.isDcsasDeploy(config) && DCSAS_SERVICE_NODE.contains(entry2.getKey()) || !keyFilter.test(entry2.getKey())) continue;
            String paramValue = multimap.keySet().stream().filter(key -> valueValidator.test((String)key, (String)entry2.getValue())).findFirst().orElse(entry2.getValue());
            multimap.put((Object)paramValue, (Object)entry2.getKey());
        }
        return multimap.asMap().entrySet().stream().filter(entry -> ((Collection)entry.getValue()).size() > 1).collect(Collectors.toList()).stream().map(stringCollectionEntry -> String.join((CharSequence)",", (Iterable)stringCollectionEntry.getValue())).collect(Collectors.toSet());
    }

    private static Optional<String> validKmsFcIpRepeated(Map<String, String> config) {
        if (!Objects.equals(config.get("DMEData_sm_option"), "YES") || !Objects.equals(config.get("DMEData_kms_option"), "YES")) {
            return Optional.empty();
        }
        if (!DmeParamValidProvider.isAutoCreateVm(config)) {
            return Optional.empty();
        }
        if (!Objects.equals(config.getOrDefault("vm_fc_url", ""), config.get("DMEData_kms_server_ip"))) {
            return Optional.of(DmeExceptionResourceUtils.getErrorMessage("dme.param.kms.ip.not.same.fc"));
        }
        return Optional.empty();
    }

    private static List<String> validBase(Map<String, String> config, List<ParamTemplate> paramTemplates) {
        return paramTemplates.stream().map(paramTemplate -> paramTemplate.validate((String)config.get(paramTemplate.getId()), VM_PARAM_BASE_KEY)).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }

    private static List<String> validManageFcParams(Map<String, String> config) {
        if (Objects.equals(config.getOrDefault("DMEData_FC_basic_manage", "NO"), "NO")) {
            return Collections.emptyList();
        }
        ArrayList<String> validMessages = new ArrayList<String>();
        validMessages.addAll(DmeParamValidProvider.validUsername(config));
        validMessages.addAll(DmeParamValidProvider.validManagePwd(config));
        return validMessages;
    }

    private static List<String> validUsername(Map<String, String> config) {
        String basicUser = config.getOrDefault("DMEData_FC_basic_user", "");
        String snmpUser = config.getOrDefault("DMEData_FC_snmp_security_user", "");
        ArrayList<String> validResult = new ArrayList<String>();
        if (!UsernameCommonValidUtils.validCommonUsername((String)basicUser, (int)1, (int)20)) {
            validResult.add(DmeExceptionResourceUtils.getErrorMessage("dme.param.manage.length.fc.user"));
        }
        if (!UsernameCommonValidUtils.validCommonUsername((String)snmpUser, (int)5, (int)32)) {
            validResult.add(DmeExceptionResourceUtils.getErrorMessage("dme.param.manage.length.snmp.user"));
        }
        return validResult;
    }

    private static List<String> validManagePwd(Map<String, String> config) {
        ArrayList<String> messages = new ArrayList<String>();
        String dmeDataFcSnmpDataPassword = config.getOrDefault("DMEData_FC_snmp_data_password", "");
        String dmeDataFcSnmpAuthPassword = config.getOrDefault("DMEData_FC_snmp_auth_password", "");
        if (!DmeValidUtils.checkEDmePassword(config.getOrDefault("DMEData_FC_basic_password", ""))) {
            messages.add(ValidResourceUtils.getMessage("dme.param.manage.password2") + ":" + DmeExceptionResourceUtils.getErrorMessage(ParamError.PASSWORD_CHECK.getKey()));
        }
        if (!DmeValidUtils.checkEDmePassword(dmeDataFcSnmpDataPassword)) {
            messages.add(ValidResourceUtils.getMessage("dme.param.manage.password1") + ":" + DmeExceptionResourceUtils.getErrorMessage(ParamError.PASSWORD_CHECK.getKey()));
        }
        if (!DmeValidUtils.checkEDmePassword(dmeDataFcSnmpAuthPassword)) {
            messages.add(ValidResourceUtils.getMessage("dme.param.manage.password0") + ":" + DmeExceptionResourceUtils.getErrorMessage(ParamError.PASSWORD_CHECK.getKey()));
        }
        if (dmeDataFcSnmpAuthPassword.equals(dmeDataFcSnmpDataPassword)) {
            messages.add(ValidResourceUtils.getMessage("dme.param.manage.password.repeat"));
        }
        return messages;
    }

    private static List<String> validFileInfo(Map<String, String> config) {
        FileInfo fileInfo = FileInfo.builder().isX86("X86".equalsIgnoreCase(config.get("DMEData_CPU_architecture"))).filePath(config.get("DMEData_package_path")).files(DmeParamValidProvider.createDmeFiles(config.get("DMEData_package_path"))).isEDiOm("YES".equalsIgnoreCase(config.get("DMEData_deploy_edi_plat"))).build();
        return fileInfo.validate(new Class[0]);
    }

    private static File[] createDmeFiles(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return new File[0];
        }
        File file = new File(path);
        if (!file.exists()) {
            return new File[0];
        }
        return file.listFiles();
    }

    private static String getParamName(List<ParamTemplate> paramTemplates, String key) {
        return paramTemplates.stream().filter(paramTemplate -> paramTemplate.getId().equals(key)).findFirst().map(ParamTemplate::getName).map(LanguageCombination::getDescription).orElse("");
    }

    private static Function<String, ErrorKey> checkHostName() {
        return value -> {
            if (DmeValidUtils.checkHostNameContainLocalhost(value)) {
                return ParamError.HOST_CONTAIN_LOCAL_HOST;
            }
            return null;
        };
    }

    private static boolean isTenantDeploy(Map<String, String> config) {
        return Objects.equals("YES", config.getOrDefault("DMEData_deploy_tenant", "NO"));
    }

    private static boolean isCcsDeploy(Map<String, String> config) {
        return DmeParamValidProvider.isTenantDeploy(config) && Objects.equals("type2", config.getOrDefault("DMEData_sdn_scene", "type3")) && Objects.equals("YES", config.getOrDefault("DMEData_deploy_ccs", "NO"));
    }

    private static boolean isAutoCreateVm(Map<String, String> config) {
        return Objects.equals("true", config.getOrDefault("vm_auto_create", "false"));
    }

    private static boolean isDcsasDeploy(Map<String, String> config) {
        return DmeParamValidProvider.isTenantDeploy(config) && Objects.equals("YES", config.getOrDefault("DMEData_deploy_dcsas", "NO"));
    }

    @Generated
    private DmeParamValidProvider() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        HOST_KEY.forEach(key -> PARAM_EXTEND_VALID.put((String)key, DmeParamValidProvider.checkHostName()));
    }
}

