/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param;

import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.InputType;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.LanguageCombination;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.OptionItem;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.ParamError;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.Validator;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.exception.DmeExceptionResourceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.valid.DmeValidUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public final class ParamTemplate {
    private final String id;
    private final String index;
    private final LanguageCombination name;
    private final LanguageCombination description;
    private final InputType inputType;
    private final boolean isRequired;
    private final Object defaultValue;
    private final Validator validator;
    private final List<OptionItem> itemList;
    private final String condition;
    private final Function<String, ErrorKey> extendValid;

    public String validate(String value, List<String> params) {
        if (!params.contains(this.id)) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)value)) {
            return this.getErrorMessage(ParamError.REQUIRED_PARAM);
        }
        if (this.inputType == InputType.PASSWORD && !DmeValidUtils.checkEDmePassword(value)) {
            return this.name.getDescription() + ":" + DmeExceptionResourceUtils.getErrorMessage(ParamError.PASSWORD_CHECK.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)value)) {
            return this.isRequired && StringUtils.isEmpty((CharSequence)this.condition) ? this.getErrorMessage(ParamError.REQUIRED_PARAM) : "";
        }
        if (!CollectionUtils.isEmpty(this.itemList) && this.itemList.stream().noneMatch(item -> value.equals(item.getValue()))) {
            return this.getErrorMessage(ParamError.OPTION_NOT_SUPPORT);
        }
        if (!Optional.ofNullable(this.validator).map(valid -> valid.validate(value)).orElse(true).booleanValue()) {
            return this.getErrorMessage(ParamError.PARAM_VERIFY_FAIL);
        }
        return Optional.ofNullable(this.extendValid).map(valid -> (ErrorKey)valid.apply(value)).map(this::getErrorMessage).orElse("");
    }

    private String getErrorMessage(ErrorKey errorKey) {
        return DmeExceptionResourceUtils.getErrorMessage(errorKey.getKey(), Collections.singletonList(this.name.getDescription()));
    }

    public String validPassword(String value, List<String> params) {
        if (params.contains(this.id) && StringUtils.isEmpty((CharSequence)value)) {
            return this.getErrorMessage(ParamError.REQUIRED_PARAM);
        }
        if (params.contains(this.id) && !DmeValidUtils.checkEDmePassword(value)) {
            return this.name.getDescription() + ":" + DmeExceptionResourceUtils.getErrorMessage(ParamError.PASSWORD_CHECK.getKey());
        }
        return "";
    }

    @Generated
    public ParamTemplate(String id, String index, LanguageCombination name, LanguageCombination description, InputType inputType, boolean isRequired, Object defaultValue, Validator validator, List<OptionItem> itemList, String condition, Function<String, ErrorKey> extendValid) {
        this.id = id;
        this.index = index;
        this.name = name;
        this.description = description;
        this.inputType = inputType;
        this.isRequired = isRequired;
        this.defaultValue = defaultValue;
        this.validator = validator;
        this.itemList = itemList;
        this.condition = condition;
        this.extendValid = extendValid;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getIndex() {
        return this.index;
    }

    @Generated
    public LanguageCombination getName() {
        return this.name;
    }

    @Generated
    public LanguageCombination getDescription() {
        return this.description;
    }

    @Generated
    public InputType getInputType() {
        return this.inputType;
    }

    @Generated
    public boolean isRequired() {
        return this.isRequired;
    }

    @Generated
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public Validator getValidator() {
        return this.validator;
    }

    @Generated
    public List<OptionItem> getItemList() {
        return this.itemList;
    }

    @Generated
    public String getCondition() {
        return this.condition;
    }

    @Generated
    public Function<String, ErrorKey> getExtendValid() {
        return this.extendValid;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParamTemplate)) {
            return false;
        }
        ParamTemplate other = (ParamTemplate)o;
        if (this.isRequired() != other.isRequired()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$index = this.getIndex();
        String other$index = other.getIndex();
        if (this$index == null ? other$index != null : !this$index.equals(other$index)) {
            return false;
        }
        LanguageCombination this$name = this.getName();
        LanguageCombination other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        LanguageCombination this$description = this.getDescription();
        LanguageCombination other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        InputType this$inputType = this.getInputType();
        InputType other$inputType = other.getInputType();
        if (this$inputType == null ? other$inputType != null : !((Object)((Object)this$inputType)).equals((Object)other$inputType)) {
            return false;
        }
        Object this$defaultValue = this.getDefaultValue();
        Object other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        Validator this$validator = this.getValidator();
        Validator other$validator = other.getValidator();
        if (this$validator == null ? other$validator != null : !((Object)this$validator).equals(other$validator)) {
            return false;
        }
        List<OptionItem> this$itemList = this.getItemList();
        List<OptionItem> other$itemList = other.getItemList();
        if (this$itemList == null ? other$itemList != null : !((Object)this$itemList).equals(other$itemList)) {
            return false;
        }
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        Function<String, ErrorKey> this$extendValid = this.getExtendValid();
        Function<String, ErrorKey> other$extendValid = other.getExtendValid();
        return !(this$extendValid == null ? other$extendValid != null : !this$extendValid.equals(other$extendValid));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRequired() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        LanguageCombination $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        LanguageCombination $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        InputType $inputType = this.getInputType();
        result = result * 59 + ($inputType == null ? 43 : ((Object)((Object)$inputType)).hashCode());
        Object $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        Validator $validator = this.getValidator();
        result = result * 59 + ($validator == null ? 43 : ((Object)$validator).hashCode());
        List<OptionItem> $itemList = this.getItemList();
        result = result * 59 + ($itemList == null ? 43 : ((Object)$itemList).hashCode());
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        Function<String, ErrorKey> $extendValid = this.getExtendValid();
        result = result * 59 + ($extendValid == null ? 43 : $extendValid.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ParamTemplate(id=" + this.getId() + ", index=" + this.getIndex() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", inputType=" + (Object)((Object)this.getInputType()) + ", isRequired=" + this.isRequired() + ", defaultValue=" + this.getDefaultValue() + ", validator=" + this.getValidator() + ", itemList=" + this.getItemList() + ", condition=" + this.getCondition() + ", extendValid=" + this.getExtendValid() + ")";
    }
}

