/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.file;

import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.valid.ValidResourceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.valid.Validatable;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;

public class FileInfo
implements Validatable {
    private static final String DME_SOFTWARE_NOT_EXIST = "dme.software.not.exist";
    private static final String DME_SOFTWARE_CMS_NOT_EXIST = "dme.software.cms.not.exist";
    private static final String DME_SOFTWARE_CRL_NOT_EXIST = "dme.software.crl.not.exist";
    private static final String DME_SOFTWARE_ARCHITECTURE_NOT_MATCH = "dme.software.architecture.not.match";
    private static final String DME_EULEROS_ISO_NOT_EXIST = "dme.euleros.iso.not.exist";
    private final boolean isX86;
    private final boolean isEDiOm;
    private final String filePath;
    private final File[] files;

    @Override
    public List<String> validate(Class<?> ... groups) {
        LinkedList<String> validateMsgs = new LinkedList<String>();
        this.checkDmeSoftwareFiles(validateMsgs);
        this.checkDmeIsoFiles(validateMsgs);
        this.checkDmeEDiOmFile(validateMsgs);
        return validateMsgs;
    }

    private void checkDmeEDiOmFile(List<String> validateMsgs) {
        if (!this.isEDiOm) {
            return;
        }
        if (ArrayUtils.isEmpty((Object[])this.files) || Arrays.stream(this.files).noneMatch(childFile -> ConsistencyPattern.isMatchDmeEDiOmSoftwarePackage((String)childFile.getName()))) {
            validateMsgs.add(ValidResourceUtils.getMessage("dme.edi.om.software.not.exist"));
            return;
        }
        Optional<File> opFile = Arrays.stream(this.files).filter(childFile -> this.isX86 ? ConsistencyPattern.isMatchDmeEDiOmX86SoftwarePackage((String)childFile.getName()) : ConsistencyPattern.isMatchDmeEDiOmArmSoftwarePackage((String)childFile.getName())).findFirst();
        if (!opFile.isPresent()) {
            validateMsgs.add(ValidResourceUtils.getMessage("dme.edi.om.software.architecture.not.match"));
            return;
        }
        if (!ConsistencyPattern.hasDmeDatSoftwareCmsFile((String)this.filePath, (String)opFile.get().getName())) {
            validateMsgs.add(ValidResourceUtils.getMessage("dme.edi.om.software.cms.not.exist"));
        }
        if (!ConsistencyPattern.hasDmeDatSoftwareCrlFile((String)this.filePath, (String)opFile.get().getName())) {
            validateMsgs.add(ValidResourceUtils.getMessage("dme.edi.om.software.crl.not.exist"));
        }
    }

    private void checkDmeSoftwareFiles(List<String> validateMsgs) {
        if (ArrayUtils.isEmpty((Object[])this.files) || Arrays.stream(this.files).noneMatch(childFile -> ConsistencyPattern.isMatchDmeDataSoftwarePackage((String)childFile.getName()))) {
            validateMsgs.add(ValidResourceUtils.getMessage(DME_SOFTWARE_NOT_EXIST));
            return;
        }
        Optional<File> opFile = Arrays.stream(this.files).filter(childFile -> this.isX86 ? ConsistencyPattern.isMatchDmeDataX86SoftwarePackage((String)childFile.getName()) : ConsistencyPattern.isMatchDmeDataArmSoftwarePackage((String)childFile.getName())).findFirst();
        if (!opFile.isPresent()) {
            validateMsgs.add(ValidResourceUtils.getMessage(DME_SOFTWARE_ARCHITECTURE_NOT_MATCH));
            return;
        }
        if (!ConsistencyPattern.hasDmeDatSoftwareCmsFile((String)this.filePath, (String)opFile.get().getName())) {
            validateMsgs.add(ValidResourceUtils.getMessage(DME_SOFTWARE_CMS_NOT_EXIST));
        }
        if (!ConsistencyPattern.hasDmeDatSoftwareCrlFile((String)this.filePath, (String)opFile.get().getName())) {
            validateMsgs.add(ValidResourceUtils.getMessage(DME_SOFTWARE_CRL_NOT_EXIST));
        }
    }

    private void checkDmeIsoFiles(List<String> validateMsgs) {
        if (ArrayUtils.isEmpty((Object[])this.files) || Arrays.stream(this.files).noneMatch(childFile -> this.isX86 ? ConsistencyPattern.isMatchDmeDataX86EulerIsoPackage((String)childFile.getName()) : ConsistencyPattern.isMatchDmeDataArmEulerIsoPackage((String)childFile.getName()))) {
            validateMsgs.add(ValidResourceUtils.getMessage(DME_EULEROS_ISO_NOT_EXIST));
        }
    }

    @Generated
    FileInfo(boolean isX86, boolean isEDiOm, String filePath, File[] files) {
        this.isX86 = isX86;
        this.isEDiOm = isEDiOm;
        this.filePath = filePath;
        this.files = files;
    }

    @Generated
    public static FileInfoBuilder builder() {
        return new FileInfoBuilder();
    }

    @Generated
    public boolean isX86() {
        return this.isX86;
    }

    @Generated
    public boolean isEDiOm() {
        return this.isEDiOm;
    }

    @Generated
    public String getFilePath() {
        return this.filePath;
    }

    @Generated
    public File[] getFiles() {
        return this.files;
    }

    @Generated
    public static class FileInfoBuilder {
        @Generated
        private boolean isX86;
        @Generated
        private boolean isEDiOm;
        @Generated
        private String filePath;
        @Generated
        private File[] files;

        @Generated
        FileInfoBuilder() {
        }

        @Generated
        public FileInfoBuilder isX86(boolean isX86) {
            this.isX86 = isX86;
            return this;
        }

        @Generated
        public FileInfoBuilder isEDiOm(boolean isEDiOm) {
            this.isEDiOm = isEDiOm;
            return this;
        }

        @Generated
        public FileInfoBuilder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        @Generated
        public FileInfoBuilder files(File[] files) {
            this.files = files;
            return this;
        }

        @Generated
        public FileInfo build() {
            return new FileInfo(this.isX86, this.isEDiOm, this.filePath, this.files);
        }

        @Generated
        public String toString() {
            return "FileInfo.FileInfoBuilder(isX86=" + this.isX86 + ", isEDiOm=" + this.isEDiOm + ", filePath=" + this.filePath + ", files=" + Arrays.deepToString(this.files) + ")";
        }
    }
}

