/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.node;

import com.huawei.yinglong.river.sitedeployment.dcs.annotation.NetworkSegment;
import com.huawei.yinglong.river.sitedeployment.dcs.annotation.validation.NetworkSegmentCheckable;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.node.Node;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.sensitive.SensitiveClearable;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.valid.ValidResourceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.valid.Validatable;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

@NetworkSegment(required=false)
public class NodeInfo
implements NetworkSegmentCheckable,
Validatable,
SensitiveClearable {
    private static final String ADDRESS_EXIST = "ip.address.exist";
    private static final String ADDRESS_NOT_REACHABLE = "ip.address.not.reachable";
    private static final String PARAM_KEY = "dme.node.param";
    private final String floatIp;
    private final String floatName;
    private final String lvsIp;
    private final String lvsName;
    private final String netmask;
    private final String gateway;
    private final String tenantFloatName;
    private final String tenantFloatIp;
    private final String tenantGlbName;
    private final String tenantGlbIp;
    private final boolean isTenantDeploy;
    private final boolean isNodeIpShouldExist;
    @Valid
    private final List<Node> nodes;

    public String getKey() {
        return PARAM_KEY;
    }

    public String[] getIpAddress() {
        ArrayList<String> ips = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(this.nodes)) {
            ips.addAll(this.nodes.stream().map(Node::getIp).collect(Collectors.toList()));
        }
        ips.add(this.floatIp);
        ips.add(this.lvsIp);
        return ips.toArray(new String[0]);
    }

    @Override
    public List<String> validate(Class<?> ... groups) {
        List<String> validateMessage = Validatable.super.validate(groups);
        if (!CollectionUtils.isEmpty(this.nodes)) {
            this.nodes.forEach(node -> this.validNodeIp(validateMessage, (Node)node));
        }
        if (IpUtils.isReachable((String)this.floatIp)) {
            validateMessage.add(ValidResourceUtils.getMessage(ADDRESS_EXIST, Arrays.asList(this.floatName, this.floatIp)));
        }
        if (IpUtils.isReachable((String)this.lvsIp)) {
            validateMessage.add(ValidResourceUtils.getMessage(ADDRESS_EXIST, Arrays.asList(this.lvsName, this.lvsIp)));
        }
        if (this.isTenantDeploy) {
            if (IpUtils.isReachable((String)this.tenantFloatIp)) {
                validateMessage.add(ValidResourceUtils.getMessage(ADDRESS_EXIST, Arrays.asList(this.tenantFloatName, this.tenantFloatIp)));
            }
            if (IpUtils.isReachable((String)this.tenantGlbIp)) {
                validateMessage.add(ValidResourceUtils.getMessage(ADDRESS_EXIST, Arrays.asList(this.tenantGlbName, this.tenantGlbIp)));
            }
        }
        return validateMessage;
    }

    private void validNodeIp(List<String> validateMessage, Node node) {
        boolean isReachable = IpUtils.isReachable((String)node.getIp());
        if (this.isNodeIpShouldExist && !isReachable) {
            validateMessage.add(ValidResourceUtils.getMessage(ADDRESS_NOT_REACHABLE, Arrays.asList(node.getNodeName(), node.getIp())));
        }
        if (!this.isNodeIpShouldExist && isReachable) {
            validateMessage.add(ValidResourceUtils.getMessage(ADDRESS_EXIST, Arrays.asList(node.getNodeName(), node.getIp())));
        }
    }

    @Override
    public void clear() {
        Optional.ofNullable(this.nodes).ifPresent(nodeList -> nodeList.forEach(SensitiveClearable::clear));
    }

    @Generated
    NodeInfo(String floatIp, String floatName, String lvsIp, String lvsName, String netmask, String gateway, String tenantFloatName, String tenantFloatIp, String tenantGlbName, String tenantGlbIp, boolean isTenantDeploy, boolean isNodeIpShouldExist, List<Node> nodes) {
        this.floatIp = floatIp;
        this.floatName = floatName;
        this.lvsIp = lvsIp;
        this.lvsName = lvsName;
        this.netmask = netmask;
        this.gateway = gateway;
        this.tenantFloatName = tenantFloatName;
        this.tenantFloatIp = tenantFloatIp;
        this.tenantGlbName = tenantGlbName;
        this.tenantGlbIp = tenantGlbIp;
        this.isTenantDeploy = isTenantDeploy;
        this.isNodeIpShouldExist = isNodeIpShouldExist;
        this.nodes = nodes;
    }

    @Generated
    public static NodeInfoBuilder builder() {
        return new NodeInfoBuilder();
    }

    @Generated
    public String getFloatIp() {
        return this.floatIp;
    }

    @Generated
    public String getFloatName() {
        return this.floatName;
    }

    @Generated
    public String getLvsIp() {
        return this.lvsIp;
    }

    @Generated
    public String getLvsName() {
        return this.lvsName;
    }

    @Generated
    public String getNetmask() {
        return this.netmask;
    }

    @Generated
    public String getGateway() {
        return this.gateway;
    }

    @Generated
    public String getTenantFloatName() {
        return this.tenantFloatName;
    }

    @Generated
    public String getTenantFloatIp() {
        return this.tenantFloatIp;
    }

    @Generated
    public String getTenantGlbName() {
        return this.tenantGlbName;
    }

    @Generated
    public String getTenantGlbIp() {
        return this.tenantGlbIp;
    }

    @Generated
    public boolean isTenantDeploy() {
        return this.isTenantDeploy;
    }

    @Generated
    public boolean isNodeIpShouldExist() {
        return this.isNodeIpShouldExist;
    }

    @Generated
    public List<Node> getNodes() {
        return this.nodes;
    }

    @Generated
    public static class NodeInfoBuilder {
        @Generated
        private String floatIp;
        @Generated
        private String floatName;
        @Generated
        private String lvsIp;
        @Generated
        private String lvsName;
        @Generated
        private String netmask;
        @Generated
        private String gateway;
        @Generated
        private String tenantFloatName;
        @Generated
        private String tenantFloatIp;
        @Generated
        private String tenantGlbName;
        @Generated
        private String tenantGlbIp;
        @Generated
        private boolean isTenantDeploy;
        @Generated
        private boolean isNodeIpShouldExist;
        @Generated
        private List<Node> nodes;

        @Generated
        NodeInfoBuilder() {
        }

        @Generated
        public NodeInfoBuilder floatIp(String floatIp) {
            this.floatIp = floatIp;
            return this;
        }

        @Generated
        public NodeInfoBuilder floatName(String floatName) {
            this.floatName = floatName;
            return this;
        }

        @Generated
        public NodeInfoBuilder lvsIp(String lvsIp) {
            this.lvsIp = lvsIp;
            return this;
        }

        @Generated
        public NodeInfoBuilder lvsName(String lvsName) {
            this.lvsName = lvsName;
            return this;
        }

        @Generated
        public NodeInfoBuilder netmask(String netmask) {
            this.netmask = netmask;
            return this;
        }

        @Generated
        public NodeInfoBuilder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        @Generated
        public NodeInfoBuilder tenantFloatName(String tenantFloatName) {
            this.tenantFloatName = tenantFloatName;
            return this;
        }

        @Generated
        public NodeInfoBuilder tenantFloatIp(String tenantFloatIp) {
            this.tenantFloatIp = tenantFloatIp;
            return this;
        }

        @Generated
        public NodeInfoBuilder tenantGlbName(String tenantGlbName) {
            this.tenantGlbName = tenantGlbName;
            return this;
        }

        @Generated
        public NodeInfoBuilder tenantGlbIp(String tenantGlbIp) {
            this.tenantGlbIp = tenantGlbIp;
            return this;
        }

        @Generated
        public NodeInfoBuilder isTenantDeploy(boolean isTenantDeploy) {
            this.isTenantDeploy = isTenantDeploy;
            return this;
        }

        @Generated
        public NodeInfoBuilder isNodeIpShouldExist(boolean isNodeIpShouldExist) {
            this.isNodeIpShouldExist = isNodeIpShouldExist;
            return this;
        }

        @Generated
        public NodeInfoBuilder nodes(List<Node> nodes) {
            this.nodes = nodes;
            return this;
        }

        @Generated
        public NodeInfo build() {
            return new NodeInfo(this.floatIp, this.floatName, this.lvsIp, this.lvsName, this.netmask, this.gateway, this.tenantFloatName, this.tenantFloatIp, this.tenantGlbName, this.tenantGlbIp, this.isTenantDeploy, this.isNodeIpShouldExist, this.nodes);
        }

        @Generated
        public String toString() {
            return "NodeInfo.NodeInfoBuilder(floatIp=" + this.floatIp + ", floatName=" + this.floatName + ", lvsIp=" + this.lvsIp + ", lvsName=" + this.lvsName + ", netmask=" + this.netmask + ", gateway=" + this.gateway + ", tenantFloatName=" + this.tenantFloatName + ", tenantFloatIp=" + this.tenantFloatIp + ", tenantGlbName=" + this.tenantGlbName + ", tenantGlbIp=" + this.tenantGlbIp + ", isTenantDeploy=" + this.isTenantDeploy + ", isNodeIpShouldExist=" + this.isNodeIpShouldExist + ", nodes=" + this.nodes + ")";
        }
    }
}

