/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dme.infrastructure.clientimpl;

import com.huawei.dmedata.deploytoolprovider.model.DmeLanguageCombination;
import com.huawei.dmedata.deploytoolprovider.model.DmeOptionItem;
import com.huawei.dmedata.deploytoolprovider.model.DmeParamTemplate;
import com.huawei.dmedata.deploytoolprovider.model.DmeProgress;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.DmeParamValidProvider;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.LanguageCombination;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.OptionItem;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.ParamTemplate;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.Validator;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.task.TaskInfo;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.ReportingPolicy;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE, imports={DmeParamValidProvider.class})
public interface DmeConverter {
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final LocalDateTime DEFAULT_DATE_TIME = LocalDateTime.ofInstant(Instant.EPOCH, ZoneId.systemDefault());

    @Mappings(value={@Mapping(target="isRequired", source="required"), @Mapping(target="index", ignore=true), @Mapping(target="validator", expression="java(toDo(param.getValidateRegex(), param.getValidateMessage()))"), @Mapping(target="extendValid", expression="java(DmeParamValidProvider.PARAM_EXTEND_VALID.get(param.getId()))")})
    public ParamTemplate toDo(DmeParamTemplate var1);

    public List<ParamTemplate> toParamTemplates(List<DmeParamTemplate> var1);

    public OptionItem toDo(DmeOptionItem var1);

    default public Validator toDo(String regex, DmeLanguageCombination languageCombination) {
        Pattern regexValidator = null;
        if (!StringUtils.isEmpty((CharSequence)regex)) {
            regexValidator = Pattern.compile(regex);
        }
        return new Validator(regex, regexValidator, this.toDo(languageCombination));
    }

    public LanguageCombination toDo(DmeLanguageCombination var1);

    @Mapping(target="durationTime", source="estimateTime")
    public TaskInfo toDo(DmeProgress var1);

    public List<TaskInfo> toDo(List<DmeProgress> var1);

    default public LocalDateTime toLocalDateTime(String time) {
        return StringUtils.isEmpty((CharSequence)time) ? DEFAULT_DATE_TIME : LocalDateTime.parse(time, FORMATTER);
    }
}

