/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dme.infrastructure.clientimpl;

import com.huawei.dmedata.deploytoolprovider.DeployProvider;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.task.TaskClient;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.task.TaskError;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.task.TaskInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.infrastructure.clientimpl.DmeClient;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.exception.DmeException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskClientImpl
extends DmeClient
implements TaskClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskClientImpl.class);

    @Override
    public List<TaskInfo> getTaskProgress() {
        try {
            return this.queryWithHandler(DeployProvider::getTaskProgress, this.converter::toDo, TaskError.GET_TASK_FAIL);
        }
        catch (DmeException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public Optional<TaskInfo> findTaskByKey(String taskKey) {
        return this.getTaskProgress().stream().filter(taskInfo -> Objects.equals(taskKey, taskInfo.getKey())).findFirst();
    }

    @Override
    public List<String> getCanSkipTaskKeys() {
        return this.queryWithHandler(DeployProvider::getCanSkipSubTaskKeys, value -> value, TaskError.GET_SKIP_KEY_FAIL);
    }

    @Override
    public void skipTask(TaskInfo task) {
        this.executeWithHandler(StringUtils.formatTxt((String)"dme skipTask: %s", (Object[])new Object[]{task.getName()}), () -> DeployProvider.skipTask((String)task.getParentTaskId(), (String)task.getId()), TaskError.SKIP_FAIL);
    }

    @Override
    public void retryTask(TaskInfo task) {
        this.executeWithHandler(StringUtils.formatTxt((String)"dme retryTask: %s", (Object[])new Object[]{task.getName()}), () -> DeployProvider.retry((String)task.getParentTaskId(), (String)task.getId()), TaskError.RETRY_FAIL);
    }
}

