/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dme.infrastructure.provider;

import com.huawei.yinglong.river.sitedeployment.dcs.dme.infrastructure.provider.ServiceError;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.exception.DmeException;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.FcRequestUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.user.UserCreateInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.user.cmd.ActivateUser;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.user.cmd.InterconnectionUser;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcClientService;
import com.huawei.yinglong.river.sitedeployment.dcs.http.fc.FcRequestClient;
import com.huawei.yinglong.river.sitedeployment.dcs.http.fc.entry.VerifySwitch;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshManager;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.sshd.client.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageFusionComputeProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ManageFusionComputeProvider.class);
    private static final ManageFusionComputeProvider INSTANCE = new ManageFusionComputeProvider();
    private static final String CERT_READ_CMD = "cat /etc/galax/certs/vrm/server.crt";
    private static final String CERT_START_FLAG = "-----BEGIN CERTIFICATE-----";
    private static final String CERT_END_FLAG = "-----END CERTIFICATE-----";
    private ApiClient fcApiService;

    public static ManageFusionComputeProvider getInstance() {
        return INSTANCE;
    }

    public void doMangeFusionCompute(Map<String, String> config) {
        if (Objects.equals(config.getOrDefault("DMEData_FC_basic_manage", "NO"), "NO")) {
            log.info("not need eDME manage FusionCompute");
            return;
        }
        try {
            this.initManageConfig(config);
            this.fcApiService = this.initFcApiService(config, false);
            this.initInterconnectUser(config);
        }
        catch (SshException | FcTaskException exception) {
            log.error("manage fusion compute error", exception);
            throw new DmeException(ServiceError.MANAGE_FC_FAILED);
        }
    }

    private ApiClient initFcApiService(Map<String, String> config, boolean isThreeRole) {
        return FcClientService.createApiService((FcLoginInfo)FcLoginInfo.builder().url(FcRequestUtils.toFcUrl((String)config.get("vm_fc_url"))).user(isThreeRole ? "secadmin" : config.get("vm_fc_user")).password(isThreeRole ? this.getStringClone(config.get("vm_secadmin_password")) : this.getStringClone(config.get("vm_fc_password"))).build());
    }

    private void initInterconnectUser(Map<String, String> config) {
        String userId;
        String fcBasicUser = config.get("DMEData_FC_basic_user");
        Optional<InterconnectionUser> interUser = this.fcApiService.queryAllUsers().stream().filter(user -> Objects.equals(user.getUserType(), "2")).filter(user -> Objects.equals(user.getUserName(), fcBasicUser)).findFirst();
        String string = userId = interUser.isPresent() ? interUser.get().getUserId() : "";
        if (interUser.isPresent() && interUser.get().getManageStatus() == 0) {
            log.info("exists [{}] user, id:[{}],no need create a new one", (Object)fcBasicUser, (Object)userId);
            return;
        }
        if (Objects.equals(config.getOrDefault("vm_fc_user", "admin"), "admin")) {
            this.createInterconnectUserInNormalRole(config);
            return;
        }
        if (StringUtils.isEmpty((CharSequence)userId)) {
            userId = this.createInterconnectUserInThreeRole(config).getUserId();
        }
        this.activateInterconnectUserInThreeRole(config, userId);
    }

    private void createInterconnectUserInNormalRole(Map<String, String> config) {
        this.fcApiService.createInterconnectionUser(InterconnectionUser.builder().userName(config.get("DMEData_FC_basic_user")).password(this.getStringClone(config.get("DMEData_FC_basic_password"))).confirmPassword(this.getStringClone(config.get("DMEData_FC_basic_password"))).roles(Collections.singletonList("administrator")).build());
    }

    private UserCreateInfo createInterconnectUserInThreeRole(Map<String, String> config) {
        return this.fcApiService.createInterconnectionUser(InterconnectionUser.builder().userName(config.get("DMEData_FC_basic_user")).password(this.getStringClone(config.get("DMEData_FC_basic_password"))).confirmPassword(this.getStringClone(config.get("DMEData_FC_basic_password"))).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateInterconnectUserInThreeRole(Map<String, String> config, String userId) {
        FcRequestClient requestClient = this.createFcRequestClient(config);
        Optional optionalVerifySwitch = requestClient.queryAccountIsolationSwitch();
        try {
            if (optionalVerifySwitch.isPresent() && ((VerifySwitch)optionalVerifySwitch.get()).isVerifySwitch()) {
                log.info("set verify switch false.");
                requestClient.setAccountIsolationSwitch(false);
            }
            ApiClient secApiService = this.initFcApiService(config, true);
            secApiService.activateUser(userId, ActivateUser.builder().build());
        }
        finally {
            if (optionalVerifySwitch.isPresent() && ((VerifySwitch)optionalVerifySwitch.get()).isVerifySwitch()) {
                log.info("set verify switch true.");
                requestClient.setAccountIsolationSwitch(true);
            }
        }
    }

    private FcRequestClient createFcRequestClient(Map<String, String> config) {
        return new FcRequestClient(config.get("vm_fc_url"), "secadmin", this.getStringClone(config.get("vm_secadmin_password")));
    }

    private SshConnInfo initSshConnInfo(Map<String, String> config) {
        return SshConnInfo.builder().userName("gandalf").hostName(config.get("vm_fc_url")).userPwd(config.get("vm_gandalf_password")).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readCertFromFcFloatIp(Map<String, String> config) throws SshException {
        String string;
        ClientSession session = null;
        SshShellService sshShellService = null;
        try {
            session = SshManager.getSession((SshConnInfo)this.initSshConnInfo(config));
            sshShellService = SshManager.createSshShellService((ClientSession)session);
            sshShellService.connect();
            string = this.doReadCertContent(config, sshShellService);
        }
        catch (Throwable throwable) {
            SshManager.releaseConnService(sshShellService);
            SshManager.releaseSession((ClientSession)session);
            throw throwable;
        }
        SshManager.releaseConnService((SshConnService)sshShellService);
        SshManager.releaseSession((ClientSession)session);
        return string;
    }

    private String doReadCertContent(Map<String, String> config, SshShellService sshShellService) throws SshException {
        String result = sshShellService.execCommand("su");
        log.info("switch user to root result = {}.", (Object)result);
        if (result.contains("Password:")) {
            result = sshShellService.execCommand(config.get("vm_root_password"));
        }
        if (!result.trim().endsWith("#")) {
            log.error("execute switch root error");
            throw new SshException((ErrorKey)SshErrorCode.SSH_PASSWORD_NOT_CORRECT);
        }
        String certContent = sshShellService.execCommand(CERT_READ_CMD);
        int startPos = certContent.indexOf(CERT_START_FLAG);
        int endPos = certContent.lastIndexOf(CERT_END_FLAG);
        if (startPos == -1 || endPos == -1) {
            log.error("can not find cert start or end");
            throw new SshException((ErrorKey)SshErrorCode.SHELL_COMMAND_FAILED, Collections.singletonList(CERT_READ_CMD));
        }
        return certContent.substring(startPos, endPos + CERT_END_FLAG.length());
    }

    private void initManageConfig(Map<String, String> config) throws SshException {
        config.put("DMEData_FC_basic_name", "auto_VRM");
        config.put("DMEData_FC_basic_ip", config.get("vm_fc_url"));
        config.put("DMEData_FC_basic_port", "7443");
        config.put("DMEData_FC_basic_vnc", "true");
        config.put("DMEData_FC_basic_cert", this.readCertFromFcFloatIp(config));
        config.put("DMEData_FC_snmp_protocol_version", "SNMPv3");
        config.put("DMEData_FC_snmp_auth_protocol", "SHA2-256");
        config.put("DMEData_FC_snmp_data_protocol", "AES-256");
    }

    private String getStringClone(String olStr) {
        return new String(olStr.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
    }

    @Generated
    private ManageFusionComputeProvider() {
    }
}

