/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dme.infrastructure.provider;

import com.huawei.yinglong.river.sitedeployment.dcs.dme.infrastructure.provider.ServiceError;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.exception.DmeException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceUtils.class);

    public static String getDeployToolPath() {
        String userDir = ServiceUtils.getUserDir();
        File dirFile = ServiceUtils.getDeployToolFile(userDir);
        try {
            return dirFile.getCanonicalPath();
        }
        catch (IOException e) {
            log.error("getDeployToolPath fail.", (Throwable)e);
            throw new DmeException(ServiceError.TOOL_PATH_INVALID);
        }
    }

    private static File getDeployToolFile(String userDir) {
        File dirFile = new File(userDir);
        String parentPath = dirFile.getParent();
        if (StringUtils.isNotEmpty((CharSequence)parentPath) && !(dirFile = Paths.get(parentPath, "DmeDeployment", "DeployTool").toFile()).exists()) {
            dirFile = Paths.get(parentPath, "DmeDeployment", "default", "DeployTool").toFile();
        }
        if (!dirFile.exists()) {
            throw new DmeException(ServiceError.TOOL_PATH_INVALID);
        }
        return dirFile;
    }

    private static String getUserDir() {
        String userDir = System.getProperty("user.dir");
        if (!FilePathValidatorUtils.isValidExistPaths((String[])new String[]{userDir})) {
            throw new DmeException(ServiceError.TOOL_PATH_INVALID);
        }
        return userDir;
    }

    @Generated
    private ServiceUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

