/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dme.utils;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutorUtils.class);
    private static final long DEFAULT_INITIAL_DELAY = 5L;
    private static final long DEFAULT_DELAY = 5L;
    private static final TimeUnit DEFAULT_UNIT = TimeUnit.SECONDS;
    private static final Thread.UncaughtExceptionHandler EXCEPTION_HANDLER = (thread, throwable) -> log.error("uncaught executor exception.", throwable);
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(10, 20, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setUncaughtExceptionHandler(EXCEPTION_HANDLER).setDaemon(true).setNameFormat("dme-executor-%d").build());
    private static ScheduledExecutorService scheduledExecutorService = ExecutorUtils.createScheduleExecutorService();

    public static void execute(Runnable runnable) {
        log.info("execute start");
        EXECUTOR_SERVICE.execute(runnable);
    }

    public static void scheduleWithFixedDelay(@NonNull Runnable command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        ExecutorUtils.scheduleWithFixedDelay(command, 5L, 5L, DEFAULT_UNIT);
    }

    public static void scheduleWithFixedDelay(@NonNull Runnable command, long initialDelay, long delay, @NonNull TimeUnit unit) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        ExecutorUtils.initScheduleIfShutDown();
        log.info("ExecutorUtils-scheduleWithFixedDelay");
        scheduledExecutorService.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public static void shutDownScheduleService() {
        if (scheduledExecutorService.isShutdown()) {
            return;
        }
        log.info("ExecutorUtils-shutDown");
        scheduledExecutorService.shutdown();
    }

    private static void initScheduleIfShutDown() {
        if (!scheduledExecutorService.isShutdown()) {
            return;
        }
        log.info("The executor is closed and a new one is initialized.");
        scheduledExecutorService = ExecutorUtils.createScheduleExecutorService();
    }

    private static ScheduledThreadPoolExecutor createScheduleExecutorService() {
        return new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setUncaughtExceptionHandler(EXCEPTION_HANDLER).setNameFormat("dme-scheduled-%d").build());
    }

    @Generated
    private ExecutorUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

