/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.sensitive;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SensitiveUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SensitiveUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void cleanStr(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return;
        }
        try {
            Field stringValue = String.class.getDeclaredField("value");
            if (!stringValue.isAccessible()) {
                stringValue.setAccessible(true);
            }
            char[] pwdChar = (char[])stringValue.get(str);
            Arrays.fill(pwdChar, '\u0000');
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            log.error("Clean str Exception", (Throwable)e);
        }
    }

    public static void cleanObjectStringField(Object object, Field field) {
        if (field.getType() != String.class) {
            return;
        }
        try {
            field.setAccessible(true);
            Object fieldValue = field.get(object);
            if (fieldValue instanceof String) {
                SensitiveUtils.cleanStr((String)fieldValue);
            }
        }
        catch (IllegalAccessException | SecurityException e) {
            log.error("Clean field Exception", (Throwable)e);
        }
    }

    public static void cleanMapString(Map<?, String> map) {
        map.values().forEach(SensitiveUtils::cleanStr);
        map.clear();
    }

    public static String serialize(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.error("serialize fail", (Throwable)e);
            return object.toString();
        }
    }

    @Generated
    private SensitiveUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

