/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.valid;

import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.ConditionExpression;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.ExpressionOperator;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.NumberUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.WeakPasswordValidUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public final class DmeValidUtils {
    private static final List<String> LOCALHOST_NAMES = Collections.unmodifiableList(Arrays.asList("localhost", "localhost.localdomain"));
    private static final Pattern PATTERN_PHONE = Pattern.compile("((13[0-9])|(14[5,7])|(15[0-3,5-9])|(17[0,3,5-8])|(18[0-9])|166|198|199|147)\\d{8}");
    private static final Pattern PATTERN_EMAIL = Pattern.compile("@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)");
    private static final Pattern PATTERN_REPEATED_TWO_TIMES = Pattern.compile("^.*(.)\\1\\1.*$");
    private static final Pattern GENERAL_CHECK = Pattern.compile("^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[~@#^*()\\-_\\[{}\\]+:./?])[A-Za-z0-9~@#^*()\\-_=\\[{}\\]+:./?]{10,32}$");

    public static boolean checkPasswordBaseRule(String password) {
        if (StringUtils.isEmpty((CharSequence)password)) {
            return false;
        }
        return !GENERAL_CHECK.matcher(password).find();
    }

    public static boolean checkHostNameContainLocalhost(String hostName) {
        if (StringUtils.isEmpty((CharSequence)hostName)) {
            return false;
        }
        return LOCALHOST_NAMES.contains(hostName.toLowerCase(Locale.ROOT));
    }

    public static boolean checkHostNameRepeated(List<String> hostNames) {
        if (CollectionUtils.isEmpty(hostNames)) {
            return false;
        }
        return hostNames.stream().distinct().count() < (long)hostNames.size();
    }

    public static boolean checkHostNameContains(List<String> hostNames) {
        HashSet<String> tmpHostNames = new HashSet<String>(hostNames);
        for (String hostName : hostNames) {
            if (!tmpHostNames.stream().filter(name -> !Objects.equals(hostName, name)).anyMatch(hostName::contains)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkPwdRepeated2Times(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        return PATTERN_REPEATED_TWO_TIMES.matcher(value).find();
    }

    public static boolean checkPwdDuplicate3Times(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        int duplicateMaxTimes = 3;
        HashMap<Character, Integer> charCntMap = new HashMap<Character, Integer>();
        for (char ch : value.toCharArray()) {
            int duplicateCnt = charCntMap.getOrDefault(Character.valueOf(ch), 0) + 1;
            if (duplicateCnt > 3) {
                return true;
            }
            charCntMap.put(Character.valueOf(ch), duplicateCnt);
        }
        return false;
    }

    public static boolean checkPwdContainAdmin(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        return value.contains("admin") || value.contains("nimda");
    }

    public static boolean checkPwdContainSys(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        return value.toLowerCase(Locale.ROOT).contains("sys");
    }

    public static boolean checkPwdContainPhoneOrEmail(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        return PATTERN_PHONE.matcher(value).find() || PATTERN_EMAIL.matcher(value).find();
    }

    public static boolean checkPwdWeakPassword(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        return !WeakPasswordValidUtils.validWeakPassword((String)value);
    }

    public static boolean checkPwdPalindrome(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        String lowerValues = value.toLowerCase(Locale.ROOT);
        return Objects.equals(lowerValues, new StringBuilder(lowerValues).reverse().toString());
    }

    public static boolean checkPwdQuotation(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        return value.contains("'") && value.contains("\"");
    }

    public static Optional<ConditionExpression> parseAndBuildConditionExpression(String condition, Map<String, String> config) {
        String[] conditions = condition.split(" ");
        if (conditions.length != 3) {
            return Optional.empty();
        }
        if (!config.containsKey(conditions[0])) {
            return Optional.empty();
        }
        return Optional.of(ConditionExpression.builder().currentValue(config.get(conditions[0])).expressionOperator(ExpressionOperator.transferExpressOperator(conditions[1])).target(conditions[2]).build());
    }

    public static boolean isMetExpression(ConditionExpression conditionExpression) {
        String currentValue = conditionExpression.getCurrentValue();
        String target = conditionExpression.getTarget();
        switch (conditionExpression.getExpressionOperator()) {
            case EQUAL: {
                return Objects.equals(currentValue, target);
            }
            case BIGGER: {
                return NumberUtils.parseInt((String)currentValue, (int)0) > NumberUtils.parseInt((String)target, (int)0);
            }
            case LESS: {
                return NumberUtils.parseInt((String)currentValue, (int)0) < NumberUtils.parseInt((String)target, (int)0);
            }
        }
        return false;
    }

    public static boolean checkEDmePassword(String value) {
        if (DmeValidUtils.checkPwdContainPhoneOrEmail(value)) {
            return false;
        }
        if (DmeValidUtils.checkPwdPalindrome(value)) {
            return false;
        }
        if (DmeValidUtils.checkPwdRepeated2Times(value)) {
            return false;
        }
        if (DmeValidUtils.checkPwdDuplicate3Times(value)) {
            return false;
        }
        if (DmeValidUtils.checkPwdContainAdmin(value)) {
            return false;
        }
        if (DmeValidUtils.checkPwdWeakPassword(value)) {
            return false;
        }
        if (DmeValidUtils.checkPasswordBaseRule(value)) {
            return false;
        }
        return !DmeValidUtils.checkPwdContainSys(value);
    }

    @Generated
    private DmeValidUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

