/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.smartkit.frame.config;

import com.huawei.yinglong.smartkit.base.util.SystemEnvUtil;
import com.huawei.yinglong.smartkit.frame.util.CertsUtil;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class SslSupportConfig
implements EnvironmentPostProcessor {
    private final Log log;

    public SslSupportConfig(DeferredLogFactory deferredLogFactory) {
        this.log = deferredLogFactory.getLog(SslSupportConfig.class);
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String name = "Config resource 'class path resource [application.yaml]' via location 'optional:classpath:/'";
        this.log.info((Object)"init ssl config");
        Security.addProvider((Provider)new BouncyCastleProvider());
        MutablePropertySources propertySources = environment.getPropertySources();
        Map sourceMap = Optional.ofNullable(propertySources.get(name)).filter(OriginTrackedMapPropertySource.class::isInstance).map(OriginTrackedMapPropertySource.class::cast).map(PropertySource::getSource).orElseGet(() -> {
            this.log.error((Object)String.format("get %s property source incorrect, can not replace ssl config.", name));
            return Collections.emptyMap();
        });
        HashMap<String, Object> map = new HashMap<String, Object>(sourceMap);
        map.replace("server.port", environment.getProperty("server.port"));
        map.replace("server.ssl.key-store", CertsUtil.getCertStoreFile());
        map.replace("server.ssl.key-alias", "SmartKitTools");
        map.replace("server.ssl.key-store-password", CertsUtil.getCertStorePass());
        map.replace("server.ssl.enabled", true);
        map.replace("work.dir", SystemEnvUtil.getDefaultUserDir());
        propertySources.replace(name, (PropertySource)new OriginTrackedMapPropertySource(name, map));
    }
}

