/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.smartkit.frame.controller;

import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.smartkit.base.util.ResourceUtils;
import com.huawei.yinglong.smartkit.base.util.ResponseUtil;
import com.huawei.yinglong.smartkit.base.util.SystemEnvUtil;
import com.huawei.yinglong.smartkit.frame.ApplicationReadyEventListener;
import com.huawei.yinglong.smartkit.frame.ToolManageService;
import com.huawei.yinglong.smartkit.frame.util.OperaLogUtil;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system"})
public class SystemController {
    private static final Logger log = LoggerFactory.getLogger(SystemController.class);
    private final ToolManageService toolManageService;
    private final ApplicationReadyEventListener readyEventListener;

    @DeleteMapping
    public Response<?> shutdown() {
        if (this.toolManageService.hasRunningTask()) {
            log.info("Has running task , can not exist.");
            return ResponseUtil.failed((String)ResourceUtils.getStringFromErrorMsg((String)"close.tool.failed.for.has.running.task"), (String)"");
        }
        OperaLogUtil.closeTools();
        this.toolManageService.shutdown();
        CompletableFuture.runAsync(this::stopServer);
        return ResponseUtil.success();
    }

    @DeleteMapping(value={"force"})
    public Response<?> forceShutdown() {
        OperaLogUtil.closeTools();
        this.toolManageService.shutdown();
        CompletableFuture.runAsync(this::stopServer);
        return ResponseUtil.success();
    }

    @GetMapping(value={"/ready"})
    public Response<?> checkApplicationReady() {
        if (this.readyEventListener.isApplicationReady()) {
            return ResponseUtil.success((Object)true);
        }
        return ResponseUtil.success((Object)false);
    }

    @GetMapping(value={"/info"})
    public Response<?> querySystemInfo() {
        return ResponseUtil.success((Object)true);
    }

    @GetMapping(value={"/closeable"})
    public Response<?> tryClosable() {
        if (this.toolManageService.hasRunningTask()) {
            return ResponseUtil.failed((String)ResourceUtils.getStringFromErrorMsg((String)"close.tool.failed.for.has.running.task"), (String)"");
        }
        return ResponseUtil.success();
    }

    private void stopServer() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            log.warn("Abandon sleep.");
        }
        log.info("try to stop server");
        try {
            Runtime.getRuntime().exit(0);
        }
        catch (Throwable e) {
            log.error("system exit fail,try force exit", e);
            Runtime.getRuntime().halt(1);
        }
    }

    @GetMapping(value={"/guidance"})
    public Response<?> guidance() {
        return ResponseUtil.success((Object)this.toolManageService.getHelpPath());
    }

    @GetMapping(value={"/language"})
    public Response<String> getCurrentLanguage() {
        String language = Objects.equals(SystemEnvUtil.getLanguage(), Locale.ENGLISH) ? "en" : "zh";
        return ResponseUtil.success((Object)language);
    }

    public SystemController(ToolManageService toolManageService, ApplicationReadyEventListener readyEventListener) {
        this.toolManageService = toolManageService;
        this.readyEventListener = readyEventListener;
    }
}

