/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.smartkit.frame.interceptor;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.huawei.yinglong.smartkit.base.util.SystemEnvUtil;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class SmartkitTokenInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SmartkitTokenInterceptor.class);
    private String smartkitToken;
    private boolean isSupportSmartkitToken;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!this.isSupportSmartkitToken) {
            return true;
        }
        String headerToken = request.getHeader("authorization");
        if (StringUtils.isNotEmpty((CharSequence)headerToken)) {
            if (StringUtils.isEmpty((CharSequence)this.smartkitToken) && Objects.equals(headerToken, SystemEnvUtil.getSmartkitToken())) {
                this.smartkitToken = SystemEnvUtil.createSmartKitToken();
                response.addHeader("authorization", this.smartkitToken);
                response.addHeader("scene", SmartkitTokenInterceptor.getSceneEnv());
                log.info("update header token, url : {}.", (Object)request.getRequestURI());
                return true;
            }
            if (Objects.equals(headerToken, this.smartkitToken)) {
                return true;
            }
        }
        log.error("invalid request : {} {}.", (Object)request.getMethod(), (Object)request.getRequestURI());
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        return false;
    }

    private static String getSceneEnv() {
        JSONObject jsonScene = JSON.parseObject((String)System.getenv("jsonScene"));
        if (Objects.isNull(jsonScene)) {
            return "";
        }
        Object scene = jsonScene.get("subScene");
        return Objects.isNull(scene) ? "" : scene.toString();
    }

    @Value(value="${smartkit.token.enable:false}")
    public void setSupportSmartkitToken(boolean supportSmartkitToken) {
        this.isSupportSmartkitToken = supportSmartkitToken;
    }
}

