/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.smartkit.frame.util;

import com.huawei.yinglong.smartkit.base.util.SecurityUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.InvalidParameterException;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertsUtil {
    private static final Logger log = LoggerFactory.getLogger(CertsUtil.class);
    public static final String DEFAULT_CERT_ALIAS = "SmartKitTools";
    public static final boolean DEFAULT_SSL_ENABLE = true;
    private static final String DEFAULT_CERT_DIR_PATH = System.getProperty("user.dir") + File.separator + "certs";
    private static final String DEFAULT_CERT_KEYSTORE_FILE = DEFAULT_CERT_DIR_PATH + File.separator + "buildInCert.keystore";
    private static final String DEFAULT_CERT_PUBLIC_CERTIFICATE_FILE = DEFAULT_CERT_DIR_PATH + File.separator + "buildInCert.cer";
    private static final String DEFAULT_CERT_TRUST_STORE_FILE = DEFAULT_CERT_DIR_PATH + File.separator + "buildInCert.jks";
    private static final int DEFAULT_CERT_STOREPASS_SIZE = 32;
    private static final char[] DEFAULT_CERT_STOREPASS = new char[32];
    private static final int CERT_VALIDITY_YEARS = 50;
    private static final String CMD_GENERATE_KEYSTORE_FILE = "\"%s\" -genkeypair -keyalg RSA -keysize 4096 -validity %d -sigalg SHA256withRSA -deststoretype pkcs12 -alias \"%s\" -keystore \"%s\" -storepass \"%s\" -J-Duser.language=en -dname \"cn=127.0.0.1,ou=Huawei SmartKit,o=HUAWEI,c=CN\"";
    private static final String CMD_EXPORT_PUBLIC_CERTIFICATE_CER = "\"%s\" -export -alias \"%s\" -keystore \"%s\" -rfc -file \"%s\" -storepass \"%s\"";
    private static final String CMD_IMPORT_CER_TRUST_STORE_JKS = "\"%s\" -import -alias \"%s\" -file \"%s\" -keystore \"%s\" -storepass \"%s\" -keypass \"%s\" -noprompt";
    private static final char BLANK = ' ';

    public static boolean generateDefaultSelfSignedCerts() {
        try {
            String certPassword = SecurityUtils.generatePassword((int)32);
            return CertsUtil.generateCerts(certPassword) && CertsUtil.configSslTrustStore(certPassword);
        }
        catch (InvalidParameterException e) {
            log.error("generate password failed.", (Throwable)e);
            return false;
        }
    }

    public static void clearDefaultSelfSignedCerts() {
        FileUtils.deleteQuietly((File)new File(DEFAULT_CERT_DIR_PATH));
    }

    public static boolean configSslTrustStore(String password) {
        if (!Files.exists(Paths.get(DEFAULT_CERT_TRUST_STORE_FILE, new String[0]), new LinkOption[0])) {
            log.error("trust store file not found.");
            return false;
        }
        System.setProperty("javax.net.ssl.trustStore", DEFAULT_CERT_TRUST_STORE_FILE);
        System.setProperty("javax.net.ssl.trustStorePassword", password);
        log.info("config ssl trust store successfully.");
        return true;
    }

    public static boolean generateCerts(String password) {
        CertsUtil.clearDefaultSelfSignedCerts();
        if (!new File(DEFAULT_CERT_DIR_PATH).mkdirs()) {
            log.error("mkdirs default cert dir failed.");
            return false;
        }
        CertsUtil.fillCertStorePass(password.toCharArray());
        return CertsUtil.generateKeyStoreFile(password) && CertsUtil.generatePublicCertFile(password) && CertsUtil.generateTrustStoreFile(password);
    }

    public static void fillCertStorePass(char[] storepass) {
        for (int i = 0; i < DEFAULT_CERT_STOREPASS.length; ++i) {
            CertsUtil.DEFAULT_CERT_STOREPASS[i] = storepass[i];
            storepass[i] = 32;
        }
    }

    public static String getCertStorePass() {
        String storepass = new String(DEFAULT_CERT_STOREPASS);
        Arrays.fill(DEFAULT_CERT_STOREPASS, ' ');
        return storepass;
    }

    public static String getCertStoreFile() {
        return DEFAULT_CERT_KEYSTORE_FILE;
    }

    static int calculateDaysInYears(int years) {
        LocalDate today = LocalDate.now();
        LocalDate futureDate = today.plusYears(years);
        return (int)ChronoUnit.DAYS.between(today, futureDate);
    }

    private static String getKeyToolPath() {
        return System.getProperty("java.home") + File.separator + "bin" + File.separator + "keytool";
    }

    private static boolean generateKeyStoreFile(String password) {
        String cmd = String.format(Locale.ROOT, CMD_GENERATE_KEYSTORE_FILE, CertsUtil.getKeyToolPath(), CertsUtil.calculateDaysInYears(50), DEFAULT_CERT_ALIAS, DEFAULT_CERT_KEYSTORE_FILE, password);
        return CertsUtil.executeCommand(cmd) && Files.exists(Paths.get(DEFAULT_CERT_KEYSTORE_FILE, new String[0]), new LinkOption[0]);
    }

    private static boolean generatePublicCertFile(String password) {
        String cmd = String.format(Locale.ROOT, CMD_EXPORT_PUBLIC_CERTIFICATE_CER, CertsUtil.getKeyToolPath(), DEFAULT_CERT_ALIAS, DEFAULT_CERT_KEYSTORE_FILE, DEFAULT_CERT_PUBLIC_CERTIFICATE_FILE, password);
        return CertsUtil.executeCommand(cmd) && Files.exists(Paths.get(DEFAULT_CERT_PUBLIC_CERTIFICATE_FILE, new String[0]), new LinkOption[0]);
    }

    private static boolean generateTrustStoreFile(String password) {
        String cmd = String.format(Locale.ROOT, CMD_IMPORT_CER_TRUST_STORE_JKS, CertsUtil.getKeyToolPath(), DEFAULT_CERT_ALIAS, DEFAULT_CERT_PUBLIC_CERTIFICATE_FILE, DEFAULT_CERT_TRUST_STORE_FILE, password, password);
        return CertsUtil.executeCommand(cmd) && Files.exists(Paths.get(DEFAULT_CERT_TRUST_STORE_FILE, new String[0]), new LinkOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean executeCommand(String cmd) {
        Process execProcess = null;
        try {
            execProcess = Runtime.getRuntime().exec(cmd);
            boolean bl = execProcess.waitFor(60L, TimeUnit.SECONDS);
            return bl;
        }
        catch (IOException | InterruptedException e) {
            log.error("execute cmd failed.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            Optional.ofNullable(execProcess).ifPresent(Process::destroyForcibly);
        }
    }

    private CertsUtil() {
    }
}

