/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.smartkit.frame.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class OperaLogUtil {
    private static final Logger log = LoggerFactory.getLogger(OperaLogUtil.class);
    private static final String DIAGNOSE_NAME_KEY = "diagnoseName";
    private static final String DIAGNOSE_NAME_EN_KEY = "diagnoseNameEn";
    private static final String DIAGNOSE_OPERA_TYPE_KEY = "diagnoseOperaType";

    public static void closeTools() {
        Map<String, String> diagnoseMap = OperaLogUtil.getDiagnoseInfo();
        if (CollectionUtils.isEmpty(diagnoseMap)) {
            log.warn("close tools, not find diagnose map.");
            return;
        }
        com.huawei.ism.tool.operalogmanager.util.OperaLogUtil.addOperaLog((String)"operalog.name.tool.close", (String)diagnoseMap.get(DIAGNOSE_OPERA_TYPE_KEY), (String)diagnoseMap.get(DIAGNOSE_NAME_KEY), (String)diagnoseMap.get(DIAGNOSE_NAME_EN_KEY), (String)"");
        com.huawei.ism.tool.operalogmanager.util.OperaLogUtil.clearTask();
    }

    public static Map<String, String> getDiagnoseInfo() {
        String jsonScene = System.getenv("jsonScene");
        if (StringUtils.isEmpty((CharSequence)jsonScene)) {
            log.warn("not find jsonScene from env.");
            return Collections.emptyMap();
        }
        Map<String, String> diagnoseMap = jsonScene.contains("Fusionstorage Expansion Evaluation") ? new HashMap<String, String>(){
            {
                this.put(OperaLogUtil.DIAGNOSE_NAME_KEY, "\u5206\u5e03\u5f0f\u6269\u5bb9");
                this.put(OperaLogUtil.DIAGNOSE_NAME_EN_KEY, "Fusionstorage Expansion");
                this.put(OperaLogUtil.DIAGNOSE_OPERA_TYPE_KEY, "operalog.type.fusionstorageexpansion");
            }
        } : (jsonScene.contains("Distributed Deploy") ? new HashMap<String, String>(){
            {
                this.put(OperaLogUtil.DIAGNOSE_NAME_KEY, "\u5206\u5e03\u5f0f\u6269\u5bb9");
                this.put(OperaLogUtil.DIAGNOSE_NAME_EN_KEY, "Distributed Deploy");
                this.put(OperaLogUtil.DIAGNOSE_OPERA_TYPE_KEY, "operalog.type.distributeddeploy");
            }
        } : (jsonScene.contains("DCSDeploy") ? new HashMap<String, String>(){
            {
                this.put(OperaLogUtil.DIAGNOSE_NAME_KEY, "\u6570\u636e\u4e2d\u5fc3\u865a\u62df\u5316\u89e3\u51b3\u65b9\u6848\u90e8\u7f72");
                this.put(OperaLogUtil.DIAGNOSE_NAME_EN_KEY, "Datacenter Virtualization Solution Deployment");
                this.put(OperaLogUtil.DIAGNOSE_OPERA_TYPE_KEY, "operalog.type.virtualizationdeployment");
            }
        } : (jsonScene.contains("Datacenter Virtualization Solution Inspection") ? new HashMap<String, String>(){
            {
                this.put(OperaLogUtil.DIAGNOSE_NAME_KEY, "\u865a\u62df\u5316\u5de1\u68c0");
                this.put(OperaLogUtil.DIAGNOSE_NAME_EN_KEY, "Datacenter Virtualization Solution Inspection");
                this.put(OperaLogUtil.DIAGNOSE_OPERA_TYPE_KEY, "operalog.type.virtualizationinspection");
            }
        } : Collections.emptyMap())));
        return diagnoseMap;
    }

    public class Constants {
        public static final String CLOSE_OPERA_NAME = "operalog.name.tool.close";
        public static final String FUSIONSTORAGE_EXPANSION_SCENE_NAME = "Fusionstorage Expansion Evaluation";
        public static final String DISTRIBUTED_DEPLOY_SCENE_NAME = "Distributed Deploy";
        public static final String VIRTUALIZATION_DEPLOYMENT_SCENE_NAME = "DCSDeploy";
        public static final String VIRTUALIZATION_INSPECTION_SCENE_NAME = "Datacenter Virtualization Solution Inspection";
        public static final String FUSIONSTORAGE_EXPANSION_NAME = "\u5206\u5e03\u5f0f\u6269\u5bb9";
        public static final String FUSIONSTORAGE_EXPANSION_NAME_EN = "Fusionstorage Expansion";
        public static final String FUSIONSTORAGE_EXPANSION_OPERA_TYPE = "operalog.type.fusionstorageexpansion";
        public static final String DISTRIBUTED_DEPLOY_NAME = "\u5206\u5e03\u5f0f\u6269\u5bb9";
        public static final String DISTRIBUTED_DEPLOY_NAME_EN = "Distributed Deploy";
        public static final String DISTRIBUTED_DEPLOY_OPERA_TYPE = "operalog.type.distributeddeploy";
        public static final String VIRTUALIZATION_DEPLOYMENT_NAME = "\u6570\u636e\u4e2d\u5fc3\u865a\u62df\u5316\u89e3\u51b3\u65b9\u6848\u90e8\u7f72";
        public static final String VIRTUALIZATION_DEPLOYMENT_NAME_EN = "Datacenter Virtualization Solution Deployment";
        public static final String VIRTUALIZATION_DEPLOYMENT_OPERA_TYPE = "operalog.type.virtualizationdeployment";
        public static final String VIRTUALIZATION_INSPECTION_NAME = "\u865a\u62df\u5316\u5de1\u68c0";
        public static final String VIRTUALIZATION_INSPECTION_NAME_EN = "Datacenter Virtualization Solution Inspection";
        public static final String VIRTUALIZATION_INSPECTION_OPERA_TYPE = "operalog.type.virtualizationinspection";
    }
}

