/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.sdn.task;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.TaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.disk.cmd.AttachDiskCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.disk.cmd.DiskCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.enviroment.cmd.EnvironmentCheckCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.batch.cmd.BatchDeployVmsCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.CreateVmByTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.UploadTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcTaskService;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.constant.SdnConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.context.SdnContext;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.entity.SdnParam;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.entity.SdnVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.task.DeploySdnTask;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.task.SdnTemplateCleanTask;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.task.SdnTemplateUnzipTask;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.task.SdnVmsStatusCheckTask;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.utils.SdnResourceBundleUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ConfigFilesUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeploySdnTaskFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeploySdnTaskFactory.class);

    public static BaseTask createDeploySdnTask() {
        return ((DeploySdnTask.DeploySdnTaskBuilder)((DeploySdnTask.DeploySdnTaskBuilder)((DeploySdnTask.DeploySdnTaskBuilder)((DeploySdnTask.DeploySdnTaskBuilder)DeploySdnTask.builder().taskId(SdnContext.getInstance().getSdnParam().getTaskId())).taskName(SdnResourceBundleUtils.getTaskNameFromResource("deploy.sdn.vm.task"))).subTasks(DeploySdnTaskFactory.createSubTasks())).eventType("sdnDeployEvent")).build();
    }

    private static List<BaseTask> createSubTasks() {
        ArrayList<BaseTask> subTasks = new ArrayList<BaseTask>();
        subTasks.add(DeploySdnTaskFactory.createEnvironmentTask());
        subTasks.add(DeploySdnTaskFactory.createSdnTemplateUnzipTask());
        subTasks.add(DeploySdnTaskFactory.createUploadTemplateTask());
        subTasks.add(DeploySdnTaskFactory.createDeployVmsTasks());
        subTasks.add(DeploySdnTaskFactory.createSdnVmCheckTask());
        subTasks.add(DeploySdnTaskFactory.createSdnTemplateCleanTask());
        subTasks.forEach(task -> task.setEventType("sdnDeployEvent"));
        return subTasks;
    }

    private static BaseTask createEnvironmentTask() {
        return FcTaskService.createEnvironmentCheckTask(DeploySdnTaskFactory::buildEnvironmentCmd, (FcLoginInfo)SdnContext.getInstance().getSdnParam().getFcLoginInfo());
    }

    private static EnvironmentCheckCmd buildEnvironmentCmd() {
        EnvironmentCheckCmd sdnEnvironmentCheckCmd = EnvironmentCheckCmd.builder().oldVmIds(() -> SdnContext.getInstance().getVmIds()).build();
        SdnContext.getInstance().getSdnParam().getSdnVmParams().forEach(sdnVmParam -> DeploySdnTaskFactory.computeResource(sdnEnvironmentCheckCmd, sdnVmParam));
        return sdnEnvironmentCheckCmd;
    }

    private static void computeResource(EnvironmentCheckCmd environmentCheckCmd, SdnVmParam sdnVmParam) {
        sdnVmParam.getDiskCmds().forEach(cmd -> environmentCheckCmd.addDatastore(cmd.getDateStoreName(), cmd.getQuantityGB()));
        environmentCheckCmd.addCpu(sdnVmParam.getCnaName(), sdnVmParam.getCpu());
        environmentCheckCmd.addMemory(sdnVmParam.getCnaName(), sdnVmParam.getMemory());
    }

    private static SdnTemplateUnzipTask createSdnTemplateUnzipTask() {
        return ((SdnTemplateUnzipTask.SdnTemplateUnzipTaskBuilder)((SdnTemplateUnzipTask.SdnTemplateUnzipTaskBuilder)SdnTemplateUnzipTask.builder().taskName(SdnResourceBundleUtils.getTaskNameFromResource("sdn.template.unzip.task.name"))).duration(SdnResourceBundleUtils.getTaskDuration("sdn.template.unzip.task.name"))).build();
    }

    private static BaseTask createUploadTemplateTask() {
        return FcTaskService.uploadTemplateTask(() -> DeploySdnTaskFactory.buildUploadTemplateCmd(SdnContext.getInstance().getSdnParam()), (FcLoginInfo)SdnContext.getInstance().getSdnParam().getFcLoginInfo());
    }

    private static UploadTemplateCmd buildUploadTemplateCmd(SdnParam sdnParam) {
        return UploadTemplateCmd.builder().cnaName(sdnParam.getSdnGeneralParam().getTemplateCnaName()).datastoreName(sdnParam.getSdnGeneralParam().getTemplateDataStoreName()).filePath(() -> SdnContext.getInstance().getTemplateVhdFile()).ovfFilePath(() -> SdnContext.getInstance().getTemplateOvfFile()).templateName("sdnTemplate").templateIdHandler(DeploySdnTaskFactory.templateIdHandler()).build();
    }

    private static Consumer<String> templateIdHandler() {
        SdnContext sdnContext = SdnContext.getInstance();
        return templateId -> {
            sdnContext.setTemplateId((String)templateId);
            sdnContext.addVmId((String)templateId);
        };
    }

    private static BaseTask createDeployVmsTasks() {
        return FcTaskService.createBatchDeployVmsTask(DeploySdnTaskFactory.buildBatchDeployVmsCmds(), (FcLoginInfo)SdnContext.getInstance().getSdnParam().getFcLoginInfo());
    }

    private static List<BatchDeployVmsCmd> buildBatchDeployVmsCmds() {
        return SdnContext.getInstance().getSdnParam().getSdnVmParams().stream().map(DeploySdnTaskFactory::buildVmsCmd).collect(Collectors.toList());
    }

    private static BatchDeployVmsCmd buildVmsCmd(SdnVmParam sdnVmParam) {
        return BatchDeployVmsCmd.builder().createVmByTemplateCmdSupplier(() -> DeploySdnTaskFactory.buildVmParam(sdnVmParam)).vmId(() -> SdnContext.getInstance().getTemplateId()).attachDiskCmdSupplier(() -> DeploySdnTaskFactory.buildAttachDisk(sdnVmParam)).cnaName(sdnVmParam.getCnaName()).isBindHost(true).build();
    }

    private static AttachDiskCmd buildAttachDisk(SdnVmParam sdnVmParam) {
        return AttachDiskCmd.builder().vmId(() -> TaskContext.get().getVmId()).diskCmds(DeploySdnTaskFactory.getDataDiskList(sdnVmParam.getDiskCmds())).build();
    }

    private static List<DiskCmd> getDataDiskList(List<DiskCmd> diskCmds) {
        return diskCmds.stream().filter(diskCmd -> diskCmd.getQuantityGB() != DeploySdnTaskFactory.getSystemDiskSize()).collect(Collectors.toList());
    }

    private static int getSystemDiskSize() {
        String diskSize = ConfigFilesUtils.getConfigValueFromCustomFile((String)SdnConstant.CONFIG_PATH, (String)"sdn.system.disk.size").orElse("92");
        return Integer.parseInt(diskSize);
    }

    private static CreateVmByTemplateCmd buildVmParam(SdnVmParam sdnVmParam) {
        return ((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)CreateVmByTemplateCmd.builder().taskName(sdnVmParam.getHostName())).vmName(sdnVmParam.getHostName())).cnaName(sdnVmParam.getCnaName())).datastoreName(sdnVmParam.getDataStoreName())).cpuCores(sdnVmParam.getCpu())).memorySizeGb(sdnVmParam.getMemory())).hostName(sdnVmParam.getHostName()).nicConfigs(sdnVmParam.getNicConfigs()).templateId(() -> SdnContext.getInstance().getTemplateId()).vmIdHandler(DeploySdnTaskFactory::setVmIdContext)).isAutoStartVm(false)).build();
    }

    private static void setVmIdContext(String vmId) {
        TaskContext.get().setVmId(vmId);
        SdnContext.getInstance().addVmId(vmId);
    }

    private static BaseTask createSdnVmCheckTask() {
        return ((SdnVmsStatusCheckTask.SdnVmsStatusCheckTaskBuilder)((SdnVmsStatusCheckTask.SdnVmsStatusCheckTaskBuilder)((SdnVmsStatusCheckTask.SdnVmsStatusCheckTaskBuilder)SdnVmsStatusCheckTask.builder().taskName(SdnResourceBundleUtils.getTaskNameFromResource("sdn.vm.status.task.name"))).duration(SdnResourceBundleUtils.getTaskDuration("sdn.vm.status.task.name"))).taskDescription(SdnResourceBundleUtils.getDescriptionFromResource("sdn.vm.status.task.name"))).build();
    }

    private static SdnTemplateCleanTask createSdnTemplateCleanTask() {
        return ((SdnTemplateCleanTask.SdnTemplateCleanTaskBuilder)((SdnTemplateCleanTask.SdnTemplateCleanTaskBuilder)SdnTemplateCleanTask.builder().taskName(SdnResourceBundleUtils.getTaskNameFromResource("sdn.template.clean.task.name"))).duration(SdnResourceBundleUtils.getTaskDuration("sdn.template.clean.task.name"))).build();
    }

    @Generated
    private DeploySdnTaskFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

