/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.sdn.task;

import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.constant.SdnConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.context.SdnContext;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.entity.SdnGeneralParam;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.exception.DeploySdnError;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.exception.DeploySdnException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ZipUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

public class SdnTemplateUnzipTask
extends BaseTask {
    public static final String TASK_NAME = "sdn.template.unzip.task.name";
    private String sdnTemplateFilePath;

    public void beforeExecute() {
        this.sdnTemplateFilePath = Optional.ofNullable(SdnContext.getInstance().getSdnParam().getSdnGeneralParam()).map(SdnGeneralParam::getPackagePath).orElse("");
        if (StringUtils.isEmpty((CharSequence)this.sdnTemplateFilePath) || !FilePathValidatorUtils.isValidExistPaths((String[])new String[]{this.sdnTemplateFilePath})) {
            throw new TaskException((ErrorKey)DeploySdnError.PARAM_ERROR);
        }
        this.createTemplateCache(new File(SdnConstant.SDN_TEMPORARY_CACHE));
    }

    public void execute() throws TaskException {
        SdnContext context = SdnContext.getInstance();
        this.appendTaskDetail("start to unzip template file.");
        ZipUtils.decompressFileBy7Zip((String)SdnConstant.ZIP_TOOL_PATH, (String)this.getSdnTemplateFilePath(), (String)SdnConstant.SDN_TEMPORARY_CACHE);
        context.setTemplateVhdFile(this.getTemplateUnzipFile(SdnConstant.SDN_TEMPORARY_CACHE, "vhd"));
        context.setTemplateOvfFile(this.getTemplateUnzipFile(SdnConstant.SDN_TEMPORARY_CACHE, "ovf"));
        this.appendTaskDetail("finish to unzip template file.");
    }

    @NotNull
    private String getSdnTemplateFilePath() {
        List zipFiles = FileOperateUtils.getSpecialFileNames((File)new File(this.sdnTemplateFilePath), ConsistencyPattern::isSdnVhdFilePackage);
        if (CollectionUtils.isEmpty((Collection)zipFiles)) {
            throw new DeploySdnException(DeploySdnError.TEMPLATE_FILE_NOT_EXIST);
        }
        if (zipFiles.size() > 1) {
            throw new DeploySdnException(DeploySdnError.MULTI_TEMPLATE_ZIP_EXIST);
        }
        return FilePathValidatorUtils.joinChildPath((String[])new String[]{this.sdnTemplateFilePath, (String)zipFiles.get(0)});
    }

    private void createTemplateCache(File file) {
        if (!file.exists() && !file.mkdirs()) {
            throw new DeploySdnException(DeploySdnError.CREATE_TEMPLATE_CACHE_FAILED);
        }
    }

    private String getTemplateUnzipFile(String sdnTemporaryCache, String fileSuffix) {
        return (String)FileUtils.listFiles((File)new File(sdnTemporaryCache), (String[])new String[]{fileSuffix}, (boolean)false).stream().findFirst().flatMap(FilePathValidatorUtils::getSafePath).orElseThrow(() -> new DeploySdnException(DeploySdnError.VHD_OVF_FILE_NOT_EXIST));
    }

    @Generated
    protected SdnTemplateUnzipTask(SdnTemplateUnzipTaskBuilder<?, ?> b) {
        super(b);
        this.sdnTemplateFilePath = ((SdnTemplateUnzipTaskBuilder)b).sdnTemplateFilePath;
    }

    @Generated
    public static SdnTemplateUnzipTaskBuilder<?, ?> builder() {
        return new SdnTemplateUnzipTaskBuilderImpl();
    }

    @Generated
    private static final class SdnTemplateUnzipTaskBuilderImpl
    extends SdnTemplateUnzipTaskBuilder<SdnTemplateUnzipTask, SdnTemplateUnzipTaskBuilderImpl> {
        @Generated
        private SdnTemplateUnzipTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected SdnTemplateUnzipTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SdnTemplateUnzipTask build() {
            return new SdnTemplateUnzipTask(this);
        }
    }

    @Generated
    public static abstract class SdnTemplateUnzipTaskBuilder<C extends SdnTemplateUnzipTask, B extends SdnTemplateUnzipTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private String sdnTemplateFilePath;

        @Generated
        public B sdnTemplateFilePath(String sdnTemplateFilePath) {
            this.sdnTemplateFilePath = sdnTemplateFilePath;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SdnTemplateUnzipTask.SdnTemplateUnzipTaskBuilder(super=" + super.toString() + ", sdnTemplateFilePath=" + this.sdnTemplateFilePath + ")";
        }
    }
}

