/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.sdn.task;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.RetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.context.SdnContext;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.entity.SdnVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.exception.DeploySdnError;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.exception.DeploySdnException;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshManager;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.sshd.client.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdnVmsStatusCheckTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SdnVmsStatusCheckTask.class);
    public static final String TASK_NAME = "sdn.vm.status.task.name";

    public void execute() throws TaskException {
        try {
            RetryUtils.retry(this::checkAllIpReachable, (int)10, (TimeUnit)TimeUnit.MINUTES);
        }
        catch (TaskException e) {
            throw new DeploySdnException(DeploySdnError.SDN_VMS_IP_CHECK_FAILED);
        }
    }

    boolean checkAllIpReachable() {
        return SdnContext.getInstance().getSdnParam().getSdnVmParams().stream().allMatch(this::checkSdnConnect);
    }

    private boolean checkSdnConnect(SdnVmParam sdnVmParam) {
        try {
            ClientSession session = SshManager.getSession((SshConnInfo)this.getSessionInfo(sdnVmParam));
            if (Objects.nonNull(session)) {
                return true;
            }
        }
        catch (SshException e) {
            return false;
        }
        return false;
    }

    private SshConnInfo getSessionInfo(SdnVmParam sdnVmParam) {
        return SshConnInfo.builder().hostName(sdnVmParam.getNicConfigs().get(0).getIp()).userName(SdnContext.getInstance().getSdnParam().getSdnAccountParam().getSdnUser()).userPwd(SdnContext.getInstance().getSdnParam().getSdnAccountParam().getSdnPwd()).newPwd(SdnContext.getInstance().getSdnParam().getSdnAccountParam().getSdnPwd()).build();
    }

    @Generated
    protected SdnVmsStatusCheckTask(SdnVmsStatusCheckTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static SdnVmsStatusCheckTaskBuilder<?, ?> builder() {
        return new SdnVmsStatusCheckTaskBuilderImpl();
    }

    @Generated
    private static final class SdnVmsStatusCheckTaskBuilderImpl
    extends SdnVmsStatusCheckTaskBuilder<SdnVmsStatusCheckTask, SdnVmsStatusCheckTaskBuilderImpl> {
        @Generated
        private SdnVmsStatusCheckTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected SdnVmsStatusCheckTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SdnVmsStatusCheckTask build() {
            return new SdnVmsStatusCheckTask(this);
        }
    }

    @Generated
    public static abstract class SdnVmsStatusCheckTaskBuilder<C extends SdnVmsStatusCheckTask, B extends SdnVmsStatusCheckTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SdnVmsStatusCheckTask.SdnVmsStatusCheckTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

