/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.sdn.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.sdn.context.SdnContext;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.exception.DeploySdnError;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.exception.DeploySdnException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.CommonTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskStatus;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public final class SdnTasksOpUtils {
    public static void skipTask(String taskId) {
        BaseTask task = (BaseTask)CommonTaskManager.getInstance().queryTaskById(SdnContext.getInstance().getDeploySdnVmsTaskId()).orElseThrow(() -> new DeploySdnException(DeploySdnError.TASK_ID_NOT_FOUND_ERROR));
        SdnTasksOpUtils.setSkipStatus(SdnTasksOpUtils.findSubTasks(task, taskId).orElseThrow(() -> new DeploySdnException(DeploySdnError.TASK_ID_NOT_FOUND_ERROR)));
    }

    private static void setSkipStatus(BaseTask baseTask) {
        if (CollectionUtils.isEmpty((Collection)baseTask.getSubTasks())) {
            return;
        }
        for (BaseTask task : baseTask.getSubTasks()) {
            if (task.getTaskResult().getTaskStatus() != TaskStatus.ERROR && task.getTaskResult().getTaskStatus() != TaskStatus.NOT_START) continue;
            task.getTaskResult().setTaskStatus(TaskStatus.SKIP);
            SdnTasksOpUtils.setSkipStatus(task);
        }
    }

    private static Optional<BaseTask> findSubTasks(BaseTask task, String taskId) {
        if (task.getTaskId().equals(taskId)) {
            return Optional.of(task);
        }
        if (CollectionUtils.isNotEmpty((Collection)task.getSubTasks())) {
            for (BaseTask baseTask : task.getSubTasks()) {
                Optional<BaseTask> optionalBaseTask = SdnTasksOpUtils.findSubTasks(baseTask, taskId);
                if (!optionalBaseTask.isPresent()) continue;
                return optionalBaseTask;
            }
        }
        return Optional.empty();
    }

    @Generated
    private SdnTasksOpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

