/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.api;

import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.constant.DmeOcPlatformConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.DmeOcPlatformContext;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.DmeIntegrationTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.RetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmeRequestInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DmeRequestInterceptor.class);
    private final Supplier<String> tokenSupplier;
    private final String dmeTrustString = "/v3/auth/tokens";
    private final int timeOutMinute = 3;

    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder requestBuilder = request.newBuilder();
        this.appendRequestHeader(request, requestBuilder);
        return this.dealLoginFail(chain, requestBuilder.build());
    }

    private Response dealLoginFail(Interceptor.Chain chain, Request request) throws IOException {
        Response response = chain.proceed(request);
        if (response.isSuccessful() || response.code() != 401 || request.url().toString().contains("/v3/auth/tokens")) {
            return response;
        }
        log.info("close original request");
        response.close();
        log.info("retry to get token.");
        String token = (String)RetryUtils.retry(this::getToken, StringUtils::isNotEmpty, (int)3, (TimeUnit)TimeUnit.MINUTES);
        log.info("retry to get token success.");
        return chain.proceed(this.updateToken(request, token));
    }

    private String getToken() {
        try {
            return this.tokenSupplier.get();
        }
        catch (DmeIntegrationTaskException taskException) {
            log.error("Failed to get token", (Throwable)((Object)taskException));
            return "";
        }
    }

    private Request updateToken(Request request, String token) {
        Request.Builder builder = request.newBuilder();
        builder.removeHeader("X-Auth-Token");
        builder.addHeader("X-Auth-Token", token);
        return builder.build();
    }

    private void appendRequestHeader(Request request, Request.Builder requestBuilder) {
        Set existedHeaders = request.headers().names();
        this.getDefaultHeaders().entrySet().stream().filter(stringStringEntry -> !existedHeaders.contains(stringStringEntry.getKey())).forEach(header -> requestBuilder.addHeader((String)header.getKey(), (String)header.getValue()));
    }

    private Map<String, String> getDefaultHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(DmeOcPlatformConstant.DEFAULT_HEADERS);
        String authToken = DmeOcPlatformContext.get().getToken();
        if (authToken != null) {
            headers.put("X-Auth-Token", authToken);
        }
        return headers;
    }

    @Generated
    public DmeRequestInterceptor(Supplier<String> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
    }
}

