/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.client;

import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.DmeApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.DmeIntegrationTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.utils.DmeRequestUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.support.Query;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseClient.class);

    protected <T> T query(Query<T> query) {
        try {
            return (T)Optional.of(query.query().execute()).map(DmeRequestUtils::dealResponse).orElseThrow(DmeIntegrationTaskException.thr(DmeApiError.REQUEST_FAILED));
        }
        catch (IOException ioException) {
            log.error(ioException.getMessage(), (Throwable)ioException);
            throw new DmeIntegrationTaskException(DmeApiError.IO_ERROR);
        }
    }

    protected <T, R> R query(Query<T> query, Function<T, R> mapper) {
        try {
            return Optional.of(query.query().execute()).map(DmeRequestUtils::dealResponse).map(mapper).orElseThrow(DmeIntegrationTaskException.thr(DmeApiError.REQUEST_FAILED));
        }
        catch (IOException ioException) {
            log.error(ioException.getMessage(), (Throwable)ioException);
            throw new DmeIntegrationTaskException(DmeApiError.IO_ERROR);
        }
    }

    protected void execute(Query<Void> execute) {
        try {
            DmeRequestUtils.dealResponse(execute.query().execute());
        }
        catch (IOException ioException) {
            log.error(ioException.getMessage(), (Throwable)ioException);
            throw new DmeIntegrationTaskException(DmeApiError.REQUEST_FAILED);
        }
    }
}

