/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.client;

import com.huawei.smartkit.drop.util.file.FilePathUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.api.DmeOcRequestApi;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.client.BaseClient;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.client.DmeOcPlatformClient;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.DmeOcPlatformLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.account.AdaptServiceAccount;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.account.BatchAddAccountInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.account.ServiceAccount;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.adapt.AdaptAccountHeader;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.adapt.AdaptServiceInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.adapt.FillAdaptParamsInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.adapt.QueryAdaptParamsInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.adapt.Variable;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.auth.AuthHeader;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.auth.AuthInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.auth.DmePassword;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.auth.IdentityInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.deploy.CloudServiceInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.DmeApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.DmeIntegrationTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.utils.DmeRequestUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.support.Query;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class DmeOcPlatformClientImpl
extends BaseClient
implements DmeOcPlatformClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DmeOcPlatformClientImpl.class);
    private final DmeOcRequestApi dmeOcRequestApi;

    @Override
    public String buildAuthToken(DmeOcPlatformLoginInfo loginInfo) {
        try {
            AuthHeader authHeader = new AuthHeader();
            Optional.of(authHeader).map(AuthHeader::getAuth).map(AuthInfo::getIdentityInfo).map(IdentityInfo::getDmePassword).map(DmePassword::getUser).ifPresent(userInfo -> userInfo.setName(loginInfo.getUser()).setPassword(loginInfo.getPassword()));
            Response response = this.dmeOcRequestApi.getAuthToken(authHeader).execute();
            DmeRequestUtils.dealResponse(response);
            return response.headers().get("X-Subject-Token");
        }
        catch (IOException ioException) {
            log.error("failed to get auth token", (Throwable)ioException);
            throw new DmeIntegrationTaskException(DmeApiError.GET_AUTH_TOKEN_FAIL);
        }
    }

    @Override
    public AdaptServiceInfo uploadPackage(List<File> files, String dmeAccount) {
        if (CollectionUtils.isEmpty(files)) {
            throw new DmeIntegrationTaskException(DmeApiError.FIND_ADAPT_FILE_ERROR);
        }
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder.setType(MultipartBody.FORM);
        for (File file : files) {
            FilePathUtils.getCanonicalPath((File)file).ifPresent(filePath -> builder.addFormDataPart("fileName", filePath, MultipartBody.create((File)file, (MediaType)MediaType.parse((String)"application/octet-stream"))));
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("scene", "access");
        return (AdaptServiceInfo)this.query(() -> this.dmeOcRequestApi.uploadTemplateFile(header, (RequestBody)builder.build()));
    }

    @Override
    public List<Variable> getIntegrateVariables(String cloudServiceName, String pkgVersion, boolean usePreVersion) {
        return ((QueryAdaptParamsInfo)this.query(() -> this.dmeOcRequestApi.getIntegrateVariables(cloudServiceName, pkgVersion, usePreVersion))).getVariables();
    }

    @Override
    public void updateIntegrateVariables(List<Variable> variables, String cloudServiceName, String pkgVersion) {
        FillAdaptParamsInfo fillAdaptParamsInfo = new FillAdaptParamsInfo(pkgVersion, cloudServiceName, variables);
        this.execute((Query<Void>)((Query)() -> this.dmeOcRequestApi.updateIntegrateVariables(fillAdaptParamsInfo)));
    }

    @Override
    public List<AdaptServiceAccount> getServiceAccounts(String cloudServiceName, String pkgVersion) {
        return ((AdaptAccountHeader)this.query(() -> this.dmeOcRequestApi.getServiceAccounts(cloudServiceName, pkgVersion))).getServiceAccounts();
    }

    @Override
    public void createServiceAccounts(List<ServiceAccount> accounts, String cloudServiceName, String pkgVersion) {
        BatchAddAccountInfo batchAddAccountInfo = new BatchAddAccountInfo(cloudServiceName, pkgVersion, accounts, true);
        this.execute((Query<Void>)((Query)() -> this.dmeOcRequestApi.createServiceAccounts(batchAddAccountInfo)));
    }

    @Override
    public void deployCloudService(CloudServiceInfo cloudServiceInfo) {
        this.execute((Query<Void>)((Query)() -> this.dmeOcRequestApi.deployCloudService(cloudServiceInfo)));
    }

    @Generated
    public DmeOcPlatformClientImpl(DmeOcRequestApi dmeOcRequestApi) {
        this.dmeOcRequestApi = dmeOcRequestApi;
    }
}

