/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.client;

import com.huawei.smartkit.drop.util.sensitive.SensitiveUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.api.UltraVrRequestApi;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.client.UltraVrPortalClient;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.UltraVrIntegrateParams;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.ultra.UltraVrDomain;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.ultra.UltraVrModifyPassword;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.ultra.UltraVrSouthGateway;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.UltraVrApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.UltraVrIntegrationTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.utils.UltraVrRequestUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class UltraVrPortalClientImpl
implements UltraVrPortalClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UltraVrPortalClientImpl.class);
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String ACCEPT = "Accept";
    private static final String X_AUTH_USER = "x-auth-user";
    private static final String X_AUTH_KEY = "x-auth-key";
    private final UltraVrRequestApi ultraVrRequestApi;

    @Override
    public void modifyUltraVrPortalPassword(UltraVrIntegrateParams params) {
        Map<String, String> header = this.getHeader();
        header.put(X_AUTH_USER, params.getManageUser());
        header.put(X_AUTH_KEY, params.getInitialPwd());
        UltraVrModifyPassword password = new UltraVrModifyPassword(params.getCustomPwd(), params.getCustomPwd(), params.getInitialPwd());
        try {
            Response response = this.ultraVrRequestApi.userModifyPassword(header, password).execute();
            UltraVrRequestUtils.dealResponse(response);
        }
        catch (IOException e) {
            log.error("failed to modify password", (Throwable)e);
            throw new UltraVrIntegrationTaskException(UltraVrApiError.MODIFY_PASSWORD_FAIL);
        }
        finally {
            this.clearHeadKey(header);
            password.clear();
        }
    }

    @Override
    public void setDmeNorthGateway(UltraVrIntegrateParams params) {
        Map<String, String> header = this.getHeader();
        header.put(X_AUTH_USER, params.getManageUser());
        header.put(X_AUTH_KEY, params.getCustomPwd());
        UltraVrDomain domain = new UltraVrDomain(params.getPortalIp());
        try {
            Response response = this.ultraVrRequestApi.setDmeNorthGateway(header, domain).execute();
            UltraVrRequestUtils.dealResponse(response);
        }
        catch (IOException e) {
            log.error("failed to set eDME portal info", (Throwable)e);
            throw new UltraVrIntegrationTaskException(UltraVrApiError.SET_DME_FAIL);
        }
        finally {
            this.clearHeadKey(header);
        }
    }

    @Override
    public void setDmeSouthGateway(UltraVrIntegrateParams params) {
        Map<String, String> header = this.getHeader();
        header.put(X_AUTH_USER, params.getManageUser());
        header.put(X_AUTH_KEY, params.getCustomPwd());
        UltraVrSouthGateway ultraVrSouthGateway = new UltraVrSouthGateway("csha_account_20", params.getMachinePwd(), params.getPortalIp());
        try {
            Response response = this.ultraVrRequestApi.setDmeSouthGateway(header, ultraVrSouthGateway).execute();
            UltraVrRequestUtils.dealResponse(response);
        }
        catch (IOException e) {
            log.error("failed to set eDME portal info", (Throwable)e);
            throw new UltraVrIntegrationTaskException(UltraVrApiError.SET_DME_FAIL);
        }
        finally {
            this.clearHeadKey(header);
            ultraVrSouthGateway.clear();
        }
    }

    private Map<String, String> getHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put(CONTENT_TYPE, "application/json;charset=UTF-8");
        header.put(ACCEPT, "application/json;version=1.0;charset=UTF-8");
        return header;
    }

    private void clearHeadKey(Map<String, String> map) {
        SensitiveUtils.cleanStr((String)map.get(X_AUTH_KEY));
    }

    @Generated
    public UltraVrPortalClientImpl(UltraVrRequestApi ultraVrRequestApi) {
        this.ultraVrRequestApi = ultraVrRequestApi;
    }
}

