/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.campuscore;

import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.client.DmeOcPlatformClient;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.constant.IntegrateConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.CampusIntegrateParams;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.IntegrateTaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.account.AdaptServiceAccount;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.account.ServiceAccount;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.adapt.AdaptServiceInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.adapt.Variable;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.deploy.CloudServiceInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.service.DmeOcPlatformClientService;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.DmeApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.DmeIntegrationTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcampusCoreIntegrateOperationTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EcampusCoreIntegrateOperationTask.class);
    public static final String TASK_NAME = "eCampusCore.integrate.operation";
    private Supplier<CampusIntegrateParams> campusIntegrateParamsSupplier;
    private DmeOcPlatformClient apiService;
    private String templateCache;
    private String integratePackage;
    private String tgzPackage;
    private String tarPackage;
    private List<String> fileRegex;

    public void beforeExecute() {
        this.apiService = DmeOcPlatformClientService.createApiService(this.campusIntegrateParamsSupplier.get().getDmeOcPlatformLoginInfo());
        this.getTargetUnzipFilePath();
    }

    public void execute() throws TaskException {
        try {
            this.unzipCampusCorePackage(this.campusIntegrateParamsSupplier.get().getSoftwarePath());
        }
        catch (IOException e) {
            throw new DmeIntegrationTaskException(DmeApiError.FIND_ADAPT_FILE_ERROR);
        }
        AdaptServiceInfo adaptServiceInfo = this.uploadAdaptPackage();
        this.updateVariables(adaptServiceInfo);
        this.batchCreateServiceAccounts(adaptServiceInfo);
        this.apiService.deployCloudService(CloudServiceInfo.builder().cloudServiceName(adaptServiceInfo.getCloudServiceName()).version(adaptServiceInfo.getVersion()).build());
        ThreadUtils.threadSafeSleep((int)1, (TimeUnit)TimeUnit.SECONDS);
    }

    private void batchCreateServiceAccounts(AdaptServiceInfo adaptServiceInfo) {
        List<AdaptServiceAccount> adaptServiceAccountList = this.apiService.getServiceAccounts(adaptServiceInfo.getCloudServiceName(), adaptServiceInfo.getVersion());
        List accounts = adaptServiceAccountList.stream().map(AdaptServiceAccount::getServiceAccount).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        log.info("The service account of the current adaptation package {} is {}.", (Object)this.integratePackage, accounts);
        IntegrateTaskContext.getInstance().getCampusCoreAccount().addAll(accounts);
        List<ServiceAccount> serviceAccountList = adaptServiceAccountList.stream().map(adaptServiceAccount -> this.createServiceAccount((AdaptServiceAccount)adaptServiceAccount, this.campusIntegrateParamsSupplier.get())).collect(Collectors.toList());
        this.apiService.createServiceAccounts(serviceAccountList, adaptServiceInfo.getCloudServiceName(), adaptServiceInfo.getVersion());
    }

    private ServiceAccount createServiceAccount(AdaptServiceAccount adaptServiceAccount, CampusIntegrateParams campusIntegrateParams) {
        return ServiceAccount.builder().serviceId(adaptServiceAccount.getServiceId()).serviceAccount(adaptServiceAccount.getServiceAccount()).password(campusIntegrateParams.getMachinePwd()).build();
    }

    private void updateVariables(AdaptServiceInfo adaptServiceInfo) {
        List<Variable> variableList = this.apiService.getIntegrateVariables(adaptServiceInfo.getCloudServiceName(), adaptServiceInfo.getVersion(), false);
        variableList.forEach(variable -> this.fillCampusVariableParams((Variable)variable, this.campusIntegrateParamsSupplier.get()));
        this.apiService.updateIntegrateVariables(variableList, adaptServiceInfo.getCloudServiceName(), adaptServiceInfo.getVersion());
    }

    private void fillCampusVariableParams(Variable variable, CampusIntegrateParams campusIntegrateParams) {
        if ("address".equals(variable.getVariableName())) {
            variable.setDefaultValue(campusIntegrateParams.getPortalIp());
            return;
        }
        if ("backend_ip".equals(variable.getVariableName())) {
            variable.setDefaultValue(campusIntegrateParams.getManageFloatIp());
            return;
        }
        if ("gateway_ip".equals(variable.getVariableName())) {
            variable.setDefaultValue(campusIntegrateParams.getPortalIp());
        }
    }

    private void unzipCampusCorePackage(String softwarePath) throws IOException {
        File eCampusCoreFirstPackage = Arrays.stream((Object[])Objects.requireNonNull(new File(softwarePath).listFiles())).filter(file -> file.getName().matches(this.integratePackage)).findFirst().orElseThrow(() -> new DmeIntegrationTaskException(DmeApiError.FIND_ADAPT_FILE_ERROR));
        ZipUtils.decompressFileBy7Zip((String)IntegrateConstant.ZIP_TOOL_PATH, (String)eCampusCoreFirstPackage.getCanonicalPath(), (String)this.templateCache);
        File eCampusCoreSecondPackage = Arrays.stream((Object[])Objects.requireNonNull(new File(this.templateCache).listFiles())).filter(file -> file.getName().matches(this.tgzPackage)).findFirst().orElseThrow(() -> new DmeIntegrationTaskException(DmeApiError.FIND_ADAPT_FILE_ERROR));
        ZipUtils.decompressFileBy7Zip((String)IntegrateConstant.ZIP_TOOL_PATH, (String)eCampusCoreSecondPackage.getCanonicalPath(), (String)this.templateCache);
        File eCampusCoreThirdPackage = Arrays.stream((Object[])Objects.requireNonNull(new File(this.templateCache).listFiles())).filter(file -> file.getName().matches(this.tarPackage)).findFirst().orElseThrow(() -> new DmeIntegrationTaskException(DmeApiError.FIND_ADAPT_FILE_ERROR));
        ZipUtils.decompressFileBy7Zip((String)IntegrateConstant.ZIP_TOOL_PATH, (String)eCampusCoreThirdPackage.getCanonicalPath(), (String)this.templateCache);
    }

    private void getTargetUnzipFilePath() {
        this.templateCache = FilePathValidatorUtils.joinChildPath((String[])new String[]{IntegrateConstant.INTEGRATE_CAMPUS_CACHE, StringUtils.commonFormatTimeText()});
        File file = new File(this.templateCache);
        if (!file.exists() && !file.mkdirs()) {
            log.error("TempCachePath create error");
            throw new DmeIntegrationTaskException(DmeApiError.CREATE_CACHE_ERROR);
        }
    }

    private AdaptServiceInfo uploadAdaptPackage() {
        File[] adaptFiles = new File(this.templateCache).listFiles();
        List<File> files = this.fileRegex.stream().map(regex -> this.getAdaptFilePathByRegex(adaptFiles, (String)regex)).map(File::new).collect(Collectors.toList());
        return this.apiService.uploadPackage(files, this.campusIntegrateParamsSupplier.get().getDmeOcPlatformLoginInfo().getUser());
    }

    private String getAdaptFilePathByRegex(File[] adaptFiles, String regex) {
        return Arrays.stream((Object[])Objects.requireNonNull(adaptFiles)).filter(file -> file.getName().matches(regex)).findFirst().map(String::valueOf).orElseThrow(() -> new DmeIntegrationTaskException(DmeApiError.FIND_ADAPT_FILE_ERROR));
    }

    @Generated
    protected EcampusCoreIntegrateOperationTask(EcampusCoreIntegrateOperationTaskBuilder<?, ?> b) {
        super(b);
        this.campusIntegrateParamsSupplier = ((EcampusCoreIntegrateOperationTaskBuilder)b).campusIntegrateParamsSupplier;
        this.apiService = ((EcampusCoreIntegrateOperationTaskBuilder)b).apiService;
        this.templateCache = ((EcampusCoreIntegrateOperationTaskBuilder)b).templateCache;
        this.integratePackage = ((EcampusCoreIntegrateOperationTaskBuilder)b).integratePackage;
        this.tgzPackage = ((EcampusCoreIntegrateOperationTaskBuilder)b).tgzPackage;
        this.tarPackage = ((EcampusCoreIntegrateOperationTaskBuilder)b).tarPackage;
        this.fileRegex = ((EcampusCoreIntegrateOperationTaskBuilder)b).fileRegex;
    }

    @Generated
    public static EcampusCoreIntegrateOperationTaskBuilder<?, ?> builder() {
        return new EcampusCoreIntegrateOperationTaskBuilderImpl();
    }

    @Generated
    private static final class EcampusCoreIntegrateOperationTaskBuilderImpl
    extends EcampusCoreIntegrateOperationTaskBuilder<EcampusCoreIntegrateOperationTask, EcampusCoreIntegrateOperationTaskBuilderImpl> {
        @Generated
        private EcampusCoreIntegrateOperationTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected EcampusCoreIntegrateOperationTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public EcampusCoreIntegrateOperationTask build() {
            return new EcampusCoreIntegrateOperationTask(this);
        }
    }

    @Generated
    public static abstract class EcampusCoreIntegrateOperationTaskBuilder<C extends EcampusCoreIntegrateOperationTask, B extends EcampusCoreIntegrateOperationTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private Supplier<CampusIntegrateParams> campusIntegrateParamsSupplier;
        @Generated
        private DmeOcPlatformClient apiService;
        @Generated
        private String templateCache;
        @Generated
        private String integratePackage;
        @Generated
        private String tgzPackage;
        @Generated
        private String tarPackage;
        @Generated
        private List<String> fileRegex;

        @Generated
        public B campusIntegrateParamsSupplier(Supplier<CampusIntegrateParams> campusIntegrateParamsSupplier) {
            this.campusIntegrateParamsSupplier = campusIntegrateParamsSupplier;
            return (B)this.self();
        }

        @Generated
        public B apiService(DmeOcPlatformClient apiService) {
            this.apiService = apiService;
            return (B)this.self();
        }

        @Generated
        public B templateCache(String templateCache) {
            this.templateCache = templateCache;
            return (B)this.self();
        }

        @Generated
        public B integratePackage(String integratePackage) {
            this.integratePackage = integratePackage;
            return (B)this.self();
        }

        @Generated
        public B tgzPackage(String tgzPackage) {
            this.tgzPackage = tgzPackage;
            return (B)this.self();
        }

        @Generated
        public B tarPackage(String tarPackage) {
            this.tarPackage = tarPackage;
            return (B)this.self();
        }

        @Generated
        public B fileRegex(List<String> fileRegex) {
            this.fileRegex = fileRegex;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "EcampusCoreIntegrateOperationTask.EcampusCoreIntegrateOperationTaskBuilder(super=" + super.toString() + ", campusIntegrateParamsSupplier=" + this.campusIntegrateParamsSupplier + ", apiService=" + this.apiService + ", templateCache=" + this.templateCache + ", integratePackage=" + this.integratePackage + ", tgzPackage=" + this.tgzPackage + ", tarPackage=" + this.tarPackage + ", fileRegex=" + this.fileRegex + ")";
        }
    }
}

