/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.hicloud;

import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.client.DmeOcPlatformClient;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.constant.IntegrateConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.HiCloudIntegrateParams;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.account.AdaptServiceAccount;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.account.ServiceAccount;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.adapt.AdaptServiceInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.adapt.Variable;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.deploy.CloudServiceInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.service.DmeOcPlatformClientService;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.DmeApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.DmeIntegrationTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ZipUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiCloudIntegrateOperationTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HiCloudIntegrateOperationTask.class);
    public static final String TASK_NAME = "hicloud.integrate.dme.operation";
    private Supplier<HiCloudIntegrateParams> hiCloudIntegrateParamsSupplier;
    private String adaptPackageRegex;
    private List<String> adaptFilesRegex;
    private DmeOcPlatformClient apiService;

    public void beforeExecute() {
        this.apiService = DmeOcPlatformClientService.createApiService(this.hiCloudIntegrateParamsSupplier.get().getDmeOcPlatformLoginInfo());
    }

    public void execute() throws TaskException {
        AdaptServiceInfo serviceInfo = this.uploadHiCloudAdaptPackage();
        this.updateVariables(serviceInfo);
        this.batchCreateServiceAccounts(serviceInfo);
        this.apiService.deployCloudService(CloudServiceInfo.builder().cloudServiceName(serviceInfo.getCloudServiceName()).version(serviceInfo.getVersion()).build());
        ThreadUtils.threadSafeSleep((int)1, (TimeUnit)TimeUnit.SECONDS);
    }

    private void batchCreateServiceAccounts(AdaptServiceInfo serviceInfo) {
        List<AdaptServiceAccount> adaptServiceAccountList = this.apiService.getServiceAccounts(serviceInfo.getCloudServiceName(), serviceInfo.getVersion());
        List<ServiceAccount> serviceAccountList = adaptServiceAccountList.stream().map(adaptServiceAccount -> this.createHiCloudServiceAccount((AdaptServiceAccount)adaptServiceAccount, this.hiCloudIntegrateParamsSupplier.get())).collect(Collectors.toList());
        this.apiService.createServiceAccounts(serviceAccountList, serviceInfo.getCloudServiceName(), serviceInfo.getVersion());
    }

    private void updateVariables(AdaptServiceInfo serviceInfo) {
        List<Variable> variableList = this.apiService.getIntegrateVariables(serviceInfo.getCloudServiceName(), serviceInfo.getVersion(), false);
        variableList.forEach(variable -> this.fillHiCloudVariableParams((Variable)variable, this.hiCloudIntegrateParamsSupplier.get()));
        this.apiService.updateIntegrateVariables(variableList, serviceInfo.getCloudServiceName(), serviceInfo.getVersion());
    }

    private ServiceAccount createHiCloudServiceAccount(AdaptServiceAccount adaptServiceAccount, HiCloudIntegrateParams params) {
        return ServiceAccount.builder().serviceId(adaptServiceAccount.getServiceId()).serviceAccount(adaptServiceAccount.getServiceAccount()).password(params.getMachinePwd()).build();
    }

    private void fillHiCloudVariableParams(Variable variable, HiCloudIntegrateParams params) {
        if ("address".equals(variable.getVariableName())) {
            variable.setDefaultValue(params.getPortalIp());
            return;
        }
        if ("gateway_ip".equals(variable.getVariableName())) {
            variable.setDefaultValue(params.getKeepLivedIp());
        }
    }

    private AdaptServiceInfo uploadHiCloudAdaptPackage() {
        File[] adaptFiles = new File(this.hiCloudIntegrateParamsSupplier.get().getSoftwarePath()).listFiles();
        String adaptPackagePath = Arrays.stream((Object[])Objects.requireNonNull(adaptFiles)).filter(file -> file.getName().matches(this.adaptPackageRegex)).findFirst().map(String::valueOf).orElseThrow(() -> new DmeIntegrationTaskException(DmeApiError.FIND_ADAPT_FILE_ERROR));
        if (!ZipUtils.decompressFileBy7Zip((String)IntegrateConstant.ZIP_TOOL_PATH, (String)adaptPackagePath, (String)IntegrateConstant.INTEGRATE_HICLOUD_CACHE)) {
            log.error("unzip HiCloud adapt zip file failed, fileName : {}.", (Object)new File(adaptPackagePath).getName());
            throw new DmeIntegrationTaskException(DmeApiError.UNZIP_ADAPT_ZIP_ERROR);
        }
        Object[] serviceAdaptFiles = new File(IntegrateConstant.INTEGRATE_HICLOUD_CACHE).listFiles();
        if (ArrayUtils.isEmpty((Object[])serviceAdaptFiles)) {
            throw new DmeIntegrationTaskException(DmeApiError.FIND_ADAPT_FILE_ERROR);
        }
        List<File> uploadFiles = this.adaptFilesRegex.stream().map(arg_0 -> this.lambda$uploadHiCloudAdaptPackage$4((File[])serviceAdaptFiles, arg_0)).map(File::new).collect(Collectors.toList());
        return this.apiService.uploadPackage(uploadFiles, this.hiCloudIntegrateParamsSupplier.get().getDmeOcPlatformLoginInfo().getUser());
    }

    private String getAdaptFilePathByRegex(File[] adaptFiles, String regex) {
        return Arrays.stream((Object[])Objects.requireNonNull(adaptFiles)).filter(file -> file.getName().matches(regex)).findFirst().map(String::valueOf).orElseThrow(() -> new DmeIntegrationTaskException(DmeApiError.FIND_ADAPT_FILE_ERROR));
    }

    @Generated
    protected HiCloudIntegrateOperationTask(HiCloudIntegrateOperationTaskBuilder<?, ?> b) {
        super(b);
        this.hiCloudIntegrateParamsSupplier = ((HiCloudIntegrateOperationTaskBuilder)b).hiCloudIntegrateParamsSupplier;
        this.adaptPackageRegex = ((HiCloudIntegrateOperationTaskBuilder)b).adaptPackageRegex;
        this.adaptFilesRegex = ((HiCloudIntegrateOperationTaskBuilder)b).adaptFilesRegex;
        this.apiService = ((HiCloudIntegrateOperationTaskBuilder)b).apiService;
    }

    @Generated
    public static HiCloudIntegrateOperationTaskBuilder<?, ?> builder() {
        return new HiCloudIntegrateOperationTaskBuilderImpl();
    }

    private /* synthetic */ String lambda$uploadHiCloudAdaptPackage$4(File[] serviceAdaptFiles, String regex) {
        return this.getAdaptFilePathByRegex(serviceAdaptFiles, regex);
    }

    @Generated
    private static final class HiCloudIntegrateOperationTaskBuilderImpl
    extends HiCloudIntegrateOperationTaskBuilder<HiCloudIntegrateOperationTask, HiCloudIntegrateOperationTaskBuilderImpl> {
        @Generated
        private HiCloudIntegrateOperationTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected HiCloudIntegrateOperationTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public HiCloudIntegrateOperationTask build() {
            return new HiCloudIntegrateOperationTask(this);
        }
    }

    @Generated
    public static abstract class HiCloudIntegrateOperationTaskBuilder<C extends HiCloudIntegrateOperationTask, B extends HiCloudIntegrateOperationTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private Supplier<HiCloudIntegrateParams> hiCloudIntegrateParamsSupplier;
        @Generated
        private String adaptPackageRegex;
        @Generated
        private List<String> adaptFilesRegex;
        @Generated
        private DmeOcPlatformClient apiService;

        @Generated
        public B hiCloudIntegrateParamsSupplier(Supplier<HiCloudIntegrateParams> hiCloudIntegrateParamsSupplier) {
            this.hiCloudIntegrateParamsSupplier = hiCloudIntegrateParamsSupplier;
            return (B)this.self();
        }

        @Generated
        public B adaptPackageRegex(String adaptPackageRegex) {
            this.adaptPackageRegex = adaptPackageRegex;
            return (B)this.self();
        }

        @Generated
        public B adaptFilesRegex(List<String> adaptFilesRegex) {
            this.adaptFilesRegex = adaptFilesRegex;
            return (B)this.self();
        }

        @Generated
        public B apiService(DmeOcPlatformClient apiService) {
            this.apiService = apiService;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "HiCloudIntegrateOperationTask.HiCloudIntegrateOperationTaskBuilder(super=" + super.toString() + ", hiCloudIntegrateParamsSupplier=" + this.hiCloudIntegrateParamsSupplier + ", adaptPackageRegex=" + this.adaptPackageRegex + ", adaptFilesRegex=" + this.adaptFilesRegex + ", apiService=" + this.apiService + ")";
        }
    }
}

