/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.hicloud;

import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.constant.IntegrateConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.HiCloudIntegrateParams;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.IntegrateTaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.hicloud.HiCloudIntegrateOperationTask;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.hicloud.HiCloudIntegrateTask;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.utils.IntegrateResourceBundleUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.constant.TaskOperateEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiCloudIntegrateTaskFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HiCloudIntegrateTaskFactory.class);

    public static BaseTask createHiCloudIntegrateTask() {
        return ((HiCloudIntegrateTask.HiCloudIntegrateTaskBuilder)((HiCloudIntegrateTask.HiCloudIntegrateTaskBuilder)((HiCloudIntegrateTask.HiCloudIntegrateTaskBuilder)((HiCloudIntegrateTask.HiCloudIntegrateTaskBuilder)((HiCloudIntegrateTask.HiCloudIntegrateTaskBuilder)((HiCloudIntegrateTask.HiCloudIntegrateTaskBuilder)HiCloudIntegrateTask.builder().taskName(IntegrateResourceBundleUtils.getTaskNameFromResource("hicloud.integrate.task"))).taskDescription(IntegrateResourceBundleUtils.getDescriptionFromResource("hicloud.integrate.task"))).taskId(IntegrateTaskContext.getInstance().getHiCloudIntegrateParams().getTaskId())).eventType("hicloudIntegrateEvent")).supportOperates(Collections.singletonList(TaskOperateEnum.RETRY))).subTasks(HiCloudIntegrateTaskFactory.createSubTasks())).build();
    }

    private static List<BaseTask> createSubTasks() {
        HiCloudIntegrateParams hiCloudIntegrateParams = IntegrateTaskContext.getInstance().getHiCloudIntegrateParams();
        HashMap<String, Boolean> taskMap = new HashMap<String, Boolean>();
        taskMap.put("VMwareSCUI", hiCloudIntegrateParams.isDeployVmware());
        taskMap.put("SecuritySCUI", hiCloudIntegrateParams.isDeploySecurity());
        taskMap.put("DBaasSCUI", hiCloudIntegrateParams.isDeployDataBase());
        taskMap.put("BMSSCUI", hiCloudIntegrateParams.isDeployBareMetal());
        return IntegrateConstant.HICLOUD_SERVICE_NAME.stream().filter(taskMap::get).map(HiCloudIntegrateTaskFactory::createHiCloudServiceTask).collect(Collectors.toList());
    }

    private static BaseTask createHiCloudServiceTask(String serviceName) {
        return ((HiCloudIntegrateOperationTask.HiCloudIntegrateOperationTaskBuilder)((HiCloudIntegrateOperationTask.HiCloudIntegrateOperationTaskBuilder)((Object)((HiCloudIntegrateOperationTask.HiCloudIntegrateOperationTaskBuilder)((Object)((HiCloudIntegrateOperationTask.HiCloudIntegrateOperationTaskBuilder)((HiCloudIntegrateOperationTask.HiCloudIntegrateOperationTaskBuilder)((HiCloudIntegrateOperationTask.HiCloudIntegrateOperationTaskBuilder)HiCloudIntegrateOperationTask.builder().taskName(IntegrateResourceBundleUtils.getTaskNameFromResource(IntegrateConstant.HICLOUD_ADAPT_TASK_NAME.get(serviceName)))).taskDescription(IntegrateResourceBundleUtils.getDescriptionFromResource(IntegrateConstant.HICLOUD_ADAPT_TASK_NAME.get(serviceName)))).duration(IntegrateResourceBundleUtils.getTaskDuration("hicloud.integrate.dme.operation"))).hiCloudIntegrateParamsSupplier(() -> IntegrateTaskContext.getInstance().getHiCloudIntegrateParams()))).adaptPackageRegex(IntegrateConstant.HICLOUD_PACKAGE_REGEX.get(serviceName)))).adaptFilesRegex(IntegrateConstant.HICLOUD_FILE_REGEX.get(serviceName)).eventType("hicloudIntegrateEvent")).build();
    }

    @Generated
    private HiCloudIntegrateTaskFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

