/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.sfs;

import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.constant.IntegrateConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.IntegrateTaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.SfsIntegrateParams;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.DmeApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.DmeIntegrationTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.utils.SshConnectIntegrateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.File;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadCertTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownloadCertTask.class);
    public static final String TASK_NAME = "sfs.integrate.download.cert";
    private Supplier<SfsIntegrateParams> sfsIntegrateParamsSupplier;

    public void beforeExecute() {
        FileOperateUtils.deleteDirectory((String)IntegrateConstant.INTEGRATE_SFS_CACHE);
        this.createTemplateCache(new File(IntegrateConstant.INTEGRATE_SFS_CACHE));
    }

    public void execute() throws TaskException {
        this.copyCertFile();
        this.downloadCert();
    }

    public void afterExecute() {
        SfsIntegrateParams sfsIntegrateParams = this.sfsIntegrateParamsSupplier.get();
        SshConnectIntegrateUtils.releaseSession(sfsIntegrateParams.getVmIp(), sfsIntegrateParams.getVmUser(), sfsIntegrateParams.getVmPwd());
    }

    private void downloadCert() {
        SfsIntegrateParams sfsIntegrateParams = this.sfsIntegrateParamsSupplier.get();
        try (SshSftpService sshSftpService = SshConnectIntegrateUtils.getSftpClient(sfsIntegrateParams.getVmIp(), sfsIntegrateParams.getVmUser(), sfsIntegrateParams.getVmPwd());){
            String certFile = this.getCertFile(sshSftpService);
            String downloadPath = FilePathValidatorUtils.joinChildPath((String[])new String[]{IntegrateConstant.INTEGRATE_SFS_CACHE, certFile});
            sshSftpService.download(FilePathValidatorUtils.createLinuxPaths((String)"/home/djmanager", (String[])new String[]{certFile}), downloadPath, (SftpProgCallback)new DefaultSftpProgCallback(certFile));
            IntegrateTaskContext.getInstance().setSfsCertFilePath(downloadPath);
        }
        catch (SshException e) {
            log.error("ssh execute error: ", (Throwable)e);
            throw new DmeIntegrationTaskException(DmeApiError.INTEGRATE_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("ssh connect error: ", (Throwable)e);
            throw new DmeIntegrationTaskException(DmeApiError.INTEGRATE_SSH_CONNECT_ERROR);
        }
    }

    private String getCertFile(SshSftpService sftpService) throws SshException {
        return sftpService.ls("/home/djmanager").stream().filter(fileName -> fileName.endsWith("ca-cert.pem")).findFirst().orElseThrow(() -> new DmeIntegrationTaskException(DmeApiError.DOWNLOAD_CERT_ERROR));
    }

    private void copyCertFile() {
        SfsIntegrateParams sfsIntegrateParams = this.sfsIntegrateParamsSupplier.get();
        try (SshShellService shellService = SshConnectIntegrateUtils.getShellClient(sfsIntegrateParams.getVmIp(), sfsIntegrateParams.getVmUser(), sfsIntegrateParams.getVmPwd());){
            String cmd = "su root";
            String result = shellService.execCommand(cmd);
            this.appendTaskDetail(result);
            log.info("execute change user cmd result: {}", (Object)result);
            if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Password:"})) {
                result = shellService.execCommand(sfsIntegrateParams.getVmPwd());
            }
            result = StringUtils.replaceSensitiveTexts((String)result, (String)sfsIntegrateParams.getVmPwd());
            this.appendTaskDetail(result);
            log.info("execute change user password cmd result: {}", (Object)result);
            cmd = "cp /opt/huawei/dj/DJSecurity/server-ca/ca-cert.pem /home/djmanager/";
            result = shellService.execCommand(cmd);
            this.appendTaskDetail(result);
            log.info("copy ca-cert file cmd result: {}", (Object)result);
            cmd = "chown djmanager:wheel /home/djmanager/ca-cert.pem";
            result = shellService.execCommand(cmd);
            this.appendTaskDetail(result);
            log.info("get cert file download permission cmd result: {}", (Object)result);
        }
        catch (SshException e) {
            log.error("ssh execute error: ", (Throwable)e);
            throw new DmeIntegrationTaskException(DmeApiError.INTEGRATE_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("copy cert file error ", (Throwable)e);
            throw new DmeIntegrationTaskException(DmeApiError.INTEGRATE_SSH_CONNECT_ERROR);
        }
    }

    private void createTemplateCache(File file) {
        if (!file.exists() && !file.mkdirs()) {
            throw new DmeIntegrationTaskException(DmeApiError.CREATE_CACHE_ERROR);
        }
    }

    @Generated
    protected DownloadCertTask(DownloadCertTaskBuilder<?, ?> b) {
        super(b);
        this.sfsIntegrateParamsSupplier = ((DownloadCertTaskBuilder)b).sfsIntegrateParamsSupplier;
    }

    @Generated
    public static DownloadCertTaskBuilder<?, ?> builder() {
        return new DownloadCertTaskBuilderImpl();
    }

    @Generated
    private static final class DownloadCertTaskBuilderImpl
    extends DownloadCertTaskBuilder<DownloadCertTask, DownloadCertTaskBuilderImpl> {
        @Generated
        private DownloadCertTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected DownloadCertTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DownloadCertTask build() {
            return new DownloadCertTask(this);
        }
    }

    @Generated
    public static abstract class DownloadCertTaskBuilder<C extends DownloadCertTask, B extends DownloadCertTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private Supplier<SfsIntegrateParams> sfsIntegrateParamsSupplier;

        @Generated
        public B sfsIntegrateParamsSupplier(Supplier<SfsIntegrateParams> sfsIntegrateParamsSupplier) {
            this.sfsIntegrateParamsSupplier = sfsIntegrateParamsSupplier;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DownloadCertTask.DownloadCertTaskBuilder(super=" + super.toString() + ", sfsIntegrateParamsSupplier=" + this.sfsIntegrateParamsSupplier + ")";
        }
    }
}

