/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.sfs;

import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.client.DmeOcPlatformClient;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.constant.IntegrateConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.SfsIntegrateParams;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.account.AdaptServiceAccount;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.account.ServiceAccount;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.adapt.AdaptServiceInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.adapt.Variable;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.deploy.CloudServiceInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.service.DmeOcPlatformClientService;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.DmeApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.DmeIntegrationTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfsIntegrateOperationTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SfsIntegrateOperationTask.class);
    public static final String TASK_NAME = "sfs.integrate.dme.operation";
    private Supplier<SfsIntegrateParams> sfsIntegrateParamsSupplier;
    private DmeOcPlatformClient apiService;

    public void beforeExecute() {
        this.apiService = DmeOcPlatformClientService.createApiService(this.sfsIntegrateParamsSupplier.get().getDmeOcPlatformLoginInfo());
    }

    public void execute() throws TaskException {
        AdaptServiceInfo adaptServiceInfo = this.uploadAdaptPackage();
        this.updateVariables(adaptServiceInfo);
        this.batchCreateServiceAccounts(adaptServiceInfo);
        this.apiService.deployCloudService(CloudServiceInfo.builder().cloudServiceName(adaptServiceInfo.getCloudServiceName()).version(adaptServiceInfo.getVersion()).build());
        ThreadUtils.threadSafeSleep((int)1, (TimeUnit)TimeUnit.SECONDS);
    }

    private AdaptServiceInfo uploadAdaptPackage() {
        File[] adaptFiles = new File(this.sfsIntegrateParamsSupplier.get().getSoftwarePath()).listFiles();
        List<File> files = IntegrateConstant.SFS_FILE_REGEX.stream().map(regex -> this.getAdaptFilePathByRegex(adaptFiles, (String)regex)).map(File::new).collect(Collectors.toList());
        return this.apiService.uploadPackage(files, this.sfsIntegrateParamsSupplier.get().getDmeOcPlatformLoginInfo().getUser());
    }

    private void batchCreateServiceAccounts(AdaptServiceInfo adaptServiceInfo) {
        List<AdaptServiceAccount> adaptServiceAccountList = this.apiService.getServiceAccounts(adaptServiceInfo.getCloudServiceName(), adaptServiceInfo.getVersion());
        List<ServiceAccount> serviceAccountList = adaptServiceAccountList.stream().map(adaptServiceAccount -> this.createServiceAccount((AdaptServiceAccount)adaptServiceAccount, this.sfsIntegrateParamsSupplier.get())).collect(Collectors.toList());
        this.apiService.createServiceAccounts(serviceAccountList, adaptServiceInfo.getCloudServiceName(), adaptServiceInfo.getVersion());
    }

    private void updateVariables(AdaptServiceInfo adaptServiceInfo) {
        List<Variable> variableList = this.apiService.getIntegrateVariables(adaptServiceInfo.getCloudServiceName(), adaptServiceInfo.getVersion(), false);
        variableList.forEach(variable -> this.fillSfsVariableParams((Variable)variable, this.sfsIntegrateParamsSupplier.get()));
        this.apiService.updateIntegrateVariables(variableList, adaptServiceInfo.getCloudServiceName(), adaptServiceInfo.getVersion());
    }

    private void fillSfsVariableParams(Variable variable, SfsIntegrateParams sfsIntegrateParams) {
        if ("console_address".equals(variable.getVariableName())) {
            variable.setDefaultValue(sfsIntegrateParams.getPortalIp());
            return;
        }
        if ("sfs_float_address".equals(variable.getVariableName())) {
            variable.setDefaultValue(sfsIntegrateParams.getSfsFloatIp());
        }
    }

    private ServiceAccount createServiceAccount(AdaptServiceAccount adaptServiceAccount, SfsIntegrateParams sfsIntegrateParams) {
        return ServiceAccount.builder().serviceId(adaptServiceAccount.getServiceId()).serviceAccount(adaptServiceAccount.getServiceAccount()).password(sfsIntegrateParams.getSfsDjPwd()).build();
    }

    @NotNull
    private String getAdaptFilePathByRegex(File[] adaptFiles, String regex) {
        return Arrays.stream((Object[])Objects.requireNonNull(adaptFiles)).filter(file -> file.getName().matches(regex)).findFirst().map(String::valueOf).orElseThrow(() -> new DmeIntegrationTaskException(DmeApiError.FIND_ADAPT_FILE_ERROR));
    }

    @Generated
    protected SfsIntegrateOperationTask(SfsIntegrateOperationTaskBuilder<?, ?> b) {
        super(b);
        this.sfsIntegrateParamsSupplier = ((SfsIntegrateOperationTaskBuilder)b).sfsIntegrateParamsSupplier;
        this.apiService = ((SfsIntegrateOperationTaskBuilder)b).apiService;
    }

    @Generated
    public static SfsIntegrateOperationTaskBuilder<?, ?> builder() {
        return new SfsIntegrateOperationTaskBuilderImpl();
    }

    @Generated
    private static final class SfsIntegrateOperationTaskBuilderImpl
    extends SfsIntegrateOperationTaskBuilder<SfsIntegrateOperationTask, SfsIntegrateOperationTaskBuilderImpl> {
        @Generated
        private SfsIntegrateOperationTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected SfsIntegrateOperationTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SfsIntegrateOperationTask build() {
            return new SfsIntegrateOperationTask(this);
        }
    }

    @Generated
    public static abstract class SfsIntegrateOperationTaskBuilder<C extends SfsIntegrateOperationTask, B extends SfsIntegrateOperationTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private Supplier<SfsIntegrateParams> sfsIntegrateParamsSupplier;
        @Generated
        private DmeOcPlatformClient apiService;

        @Generated
        public B sfsIntegrateParamsSupplier(Supplier<SfsIntegrateParams> sfsIntegrateParamsSupplier) {
            this.sfsIntegrateParamsSupplier = sfsIntegrateParamsSupplier;
            return (B)this.self();
        }

        @Generated
        public B apiService(DmeOcPlatformClient apiService) {
            this.apiService = apiService;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SfsIntegrateOperationTask.SfsIntegrateOperationTaskBuilder(super=" + super.toString() + ", sfsIntegrateParamsSupplier=" + this.sfsIntegrateParamsSupplier + ", apiService=" + this.apiService + ")";
        }
    }
}

