/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.ultra;

import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.client.DmeOcPlatformClient;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.constant.IntegrateConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.UltraVrIntegrateParams;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.account.AdaptServiceAccount;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.account.ServiceAccount;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.adapt.AdaptServiceInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.adapt.Variable;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.deploy.CloudServiceInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.service.DmeOcPlatformClientService;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.DmeApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.DmeIntegrationTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ZipUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UltraVrIntegrateOperationTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UltraVrIntegrateOperationTask.class);
    public static final String TASK_NAME = "ultra.integrate.dme.operation";
    private Supplier<UltraVrIntegrateParams> ultraVrIntegrateParamsSupplier;
    private DmeOcPlatformClient apiService;

    public void beforeExecute() {
        this.apiService = DmeOcPlatformClientService.createApiService(this.ultraVrIntegrateParamsSupplier.get().getDmeOcPlatformLoginInfo());
    }

    public void execute() throws TaskException {
        AdaptServiceInfo serviceInfo = this.uploadUltraVrAdaptPackage();
        this.updateVariables(serviceInfo);
        this.batchCreateServiceAccounts(serviceInfo);
        this.apiService.deployCloudService(CloudServiceInfo.builder().cloudServiceName(serviceInfo.getCloudServiceName()).version(serviceInfo.getVersion()).build());
        ThreadUtils.threadSafeSleep((int)1, (TimeUnit)TimeUnit.SECONDS);
    }

    private void batchCreateServiceAccounts(AdaptServiceInfo serviceInfo) {
        List<AdaptServiceAccount> adaptServiceAccountList = this.apiService.getServiceAccounts(serviceInfo.getCloudServiceName(), serviceInfo.getVersion());
        List<ServiceAccount> serviceAccountList = adaptServiceAccountList.stream().map(adaptServiceAccount -> this.createUltraVrServiceAccount((AdaptServiceAccount)adaptServiceAccount, this.ultraVrIntegrateParamsSupplier.get())).collect(Collectors.toList());
        this.apiService.createServiceAccounts(serviceAccountList, serviceInfo.getCloudServiceName(), serviceInfo.getVersion());
    }

    private void updateVariables(AdaptServiceInfo serviceInfo) {
        List<Variable> variableList = this.apiService.getIntegrateVariables(serviceInfo.getCloudServiceName(), serviceInfo.getVersion(), false);
        variableList.forEach(variable -> this.fillUltraVrVariableParams((Variable)variable, this.ultraVrIntegrateParamsSupplier.get()));
        this.apiService.updateIntegrateVariables(variableList, serviceInfo.getCloudServiceName(), serviceInfo.getVersion());
    }

    private ServiceAccount createUltraVrServiceAccount(AdaptServiceAccount adaptServiceAccount, UltraVrIntegrateParams params) {
        return ServiceAccount.builder().serviceId(adaptServiceAccount.getServiceId()).serviceAccount(adaptServiceAccount.getServiceAccount()).password(params.getMachinePwd()).build();
    }

    private void fillUltraVrVariableParams(Variable variable, UltraVrIntegrateParams params) {
        if ("address".equals(variable.getVariableName())) {
            variable.setDefaultValue(params.getPortalIp());
            return;
        }
        if ("ip".equals(variable.getVariableName())) {
            variable.setDefaultValue(params.getServicePortalIp());
            return;
        }
        if ("port".equals(variable.getVariableName())) {
            variable.setDefaultValue("9443");
        }
    }

    private AdaptServiceInfo uploadUltraVrAdaptPackage() {
        File[] adaptFiles = new File(this.ultraVrIntegrateParamsSupplier.get().getSoftwarePath()).listFiles();
        String adaptPackagePath = Arrays.stream((Object[])Objects.requireNonNull(adaptFiles)).filter(file -> file.getName().matches("^resource_uniteAccess_csha_.*?\\.zip$")).findFirst().map(String::valueOf).orElseThrow(() -> new DmeIntegrationTaskException(DmeApiError.FIND_ADAPT_FILE_ERROR));
        if (!ZipUtils.decompressFileBy7Zip((String)IntegrateConstant.ZIP_TOOL_PATH, (String)adaptPackagePath, (String)IntegrateConstant.INTEGRATE_ULTRAVR_CACHE)) {
            log.error("unzip ultraVR adapt zip file failed, fileName : {}.", (Object)new File(adaptPackagePath).getName());
            throw new DmeIntegrationTaskException(DmeApiError.UNZIP_ADAPT_ZIP_ERROR);
        }
        Object[] serviceAdaptFiles = new File(IntegrateConstant.INTEGRATE_ULTRAVR_CACHE).listFiles();
        if (ArrayUtils.isEmpty((Object[])serviceAdaptFiles)) {
            throw new DmeIntegrationTaskException(DmeApiError.FIND_ADAPT_FILE_ERROR);
        }
        List<File> uploadFiles = IntegrateConstant.ULTRAVR_FILE_REGEX.stream().map(arg_0 -> this.lambda$uploadUltraVrAdaptPackage$4((File[])serviceAdaptFiles, arg_0)).map(File::new).collect(Collectors.toList());
        return this.apiService.uploadPackage(uploadFiles, this.ultraVrIntegrateParamsSupplier.get().getDmeOcPlatformLoginInfo().getUser());
    }

    private String getAdaptFilePathByRegex(File[] adaptFiles, String regex) {
        return Arrays.stream((Object[])Objects.requireNonNull(adaptFiles)).filter(file -> file.getName().matches(regex)).findFirst().map(String::valueOf).orElseThrow(() -> new DmeIntegrationTaskException(DmeApiError.FIND_ADAPT_FILE_ERROR));
    }

    @Generated
    protected UltraVrIntegrateOperationTask(UltraVrIntegrateOperationTaskBuilder<?, ?> b) {
        super(b);
        this.ultraVrIntegrateParamsSupplier = ((UltraVrIntegrateOperationTaskBuilder)b).ultraVrIntegrateParamsSupplier;
        this.apiService = ((UltraVrIntegrateOperationTaskBuilder)b).apiService;
    }

    @Generated
    public static UltraVrIntegrateOperationTaskBuilder<?, ?> builder() {
        return new UltraVrIntegrateOperationTaskBuilderImpl();
    }

    private /* synthetic */ String lambda$uploadUltraVrAdaptPackage$4(File[] serviceAdaptFiles, String regex) {
        return this.getAdaptFilePathByRegex(serviceAdaptFiles, regex);
    }

    @Generated
    private static final class UltraVrIntegrateOperationTaskBuilderImpl
    extends UltraVrIntegrateOperationTaskBuilder<UltraVrIntegrateOperationTask, UltraVrIntegrateOperationTaskBuilderImpl> {
        @Generated
        private UltraVrIntegrateOperationTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected UltraVrIntegrateOperationTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public UltraVrIntegrateOperationTask build() {
            return new UltraVrIntegrateOperationTask(this);
        }
    }

    @Generated
    public static abstract class UltraVrIntegrateOperationTaskBuilder<C extends UltraVrIntegrateOperationTask, B extends UltraVrIntegrateOperationTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private Supplier<UltraVrIntegrateParams> ultraVrIntegrateParamsSupplier;
        @Generated
        private DmeOcPlatformClient apiService;

        @Generated
        public B ultraVrIntegrateParamsSupplier(Supplier<UltraVrIntegrateParams> ultraVrIntegrateParamsSupplier) {
            this.ultraVrIntegrateParamsSupplier = ultraVrIntegrateParamsSupplier;
            return (B)this.self();
        }

        @Generated
        public B apiService(DmeOcPlatformClient apiService) {
            this.apiService = apiService;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "UltraVrIntegrateOperationTask.UltraVrIntegrateOperationTaskBuilder(super=" + super.toString() + ", ultraVrIntegrateParamsSupplier=" + this.ultraVrIntegrateParamsSupplier + ", apiService=" + this.apiService + ")";
        }
    }
}

