/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.utils;

import com.huawei.smartkit.drop.util.JsonUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.campus.CampusErrorResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.CampusApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.CampusIntegrationTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import lombok.Generated;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class CampusRequestUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CampusRequestUtils.class);

    public static String toCampusUrl(String ip) {
        return StringUtils.formatTxt((String)"https://%s:443", (Object[])new Object[]{ip});
    }

    public static <T> T dealResponse(Response<T> response) {
        if (response.isSuccessful()) {
            return (T)response.body();
        }
        String errorDesc = CampusRequestUtils.getErrorDesc(response);
        if (StringUtils.isEmpty((CharSequence)errorDesc)) {
            throw new CampusIntegrationTaskException(CampusApiError.REQUEST_FAIL);
        }
        throw new CampusIntegrationTaskException(CampusApiError.TASK_FAIL, Collections.singletonList(errorDesc));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getErrorDesc(Response<?> response) {
        try (ResponseBody errorBody = response.errorBody();){
            if (Objects.isNull(errorBody)) {
                log.error("{} errorBody is null", response);
                String string = "";
                return string;
            }
            String errorStr = errorBody.string();
            if (StringUtils.isEmpty((CharSequence)errorStr)) {
                String string = errorStr;
                return string;
            }
            CampusErrorResponse errorResponse = (CampusErrorResponse)JsonUtils.toObject((String)errorStr, CampusErrorResponse.class);
            String string = Objects.isNull(errorResponse) ? "" : errorResponse.getResMsg();
            return string;
        }
        catch (IOException e) {
            log.error("deal errorBody error", (Throwable)e);
            return "";
        }
    }

    @Generated
    private CampusRequestUtils() {
    }
}

