/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.utils;

import com.huawei.smartkit.drop.util.JsonUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.DmeApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.DmeErrorResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.DmeIntegrationTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.IOException;
import java.util.Collections;
import lombok.Generated;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public final class DmeRequestUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DmeRequestUtils.class);

    public static String toDmeUrl(String ip) {
        return StringUtils.formatTxt((String)"https://%s:27335", (Object[])new Object[]{ip});
    }

    public static <T> T dealResponse(Response<T> response) {
        if (response.isSuccessful()) {
            return (T)response.body();
        }
        String errorDesc = DmeRequestUtils.getErrorDesc(response);
        if (StringUtils.isEmpty((CharSequence)errorDesc)) {
            throw new DmeIntegrationTaskException(DmeApiError.REQUEST_FAILED);
        }
        throw new DmeIntegrationTaskException(DmeApiError.TASK_FAIL, Collections.singletonList(errorDesc));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getErrorDesc(Response<?> response) {
        try (ResponseBody errorBody = response.errorBody();){
            if (errorBody == null) {
                log.warn("{} errorBody is null", response);
                String string = "";
                return string;
            }
            String errorStr = errorBody.string();
            if (StringUtils.isEmpty((CharSequence)errorStr)) {
                String string = errorStr;
                return string;
            }
            DmeErrorResponse errorResponse = (DmeErrorResponse)JsonUtils.toObject((String)errorStr, DmeErrorResponse.class);
            String string = errorResponse == null ? "" : errorResponse.getErrorMsg();
            return string;
        }
        catch (IOException e) {
            log.error("deal errorBody error", (Throwable)e);
            return "";
        }
    }

    @Generated
    private DmeRequestUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

