/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.utils;

import com.huawei.smartkit.drop.util.JsonUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.ultra.UltraVrErrorResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.UltraVrApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.task.exception.UltraVrIntegrationTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.IOException;
import java.util.Collections;
import lombok.Generated;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public final class UltraVrRequestUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UltraVrRequestUtils.class);

    public static String toUltraVrUrl(String ip) {
        return StringUtils.formatTxt((String)"https://%s:9443", (Object[])new Object[]{ip});
    }

    public static <T> T dealResponse(Response<T> response) {
        if (response.isSuccessful()) {
            return (T)response.body();
        }
        String errorDesc = UltraVrRequestUtils.getErrorDesc(response);
        if (StringUtils.isEmpty((CharSequence)errorDesc)) {
            throw new UltraVrIntegrationTaskException(UltraVrApiError.REQUEST_FAIL);
        }
        throw new UltraVrIntegrationTaskException(UltraVrApiError.TASK_FAIL, Collections.singletonList(errorDesc));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getErrorDesc(Response<?> response) {
        try (ResponseBody errorBody = response.errorBody();){
            if (errorBody == null) {
                log.warn("{} errorBody is null", response);
                String string = "";
                return string;
            }
            String errorStr = errorBody.string();
            if (StringUtils.isEmpty((CharSequence)errorStr)) {
                String string = errorStr;
                return string;
            }
            UltraVrErrorResponse errorResponse = (UltraVrErrorResponse)JsonUtils.toObject((String)errorStr, UltraVrErrorResponse.class);
            String string = errorResponse == null ? "" : errorResponse.getErrorMessage();
            return string;
        }
        catch (IOException e) {
            log.error("deal errorBody error", (Throwable)e);
            return "";
        }
    }

    @Generated
    private UltraVrRequestUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

