/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.campuscore.context;

import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.constant.CampusCoreConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.entity.CampusCoreParam;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.entity.CampusCoreTemplate;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.entity.CampusCoreVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.entity.CampusServiceScenario;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.task.service.entity.CampusCoreTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.TaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.disk.cmd.AttachDiskCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.CreateVmByTemplateCmd;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class DeployCampusCoreContext {
    private final Map<String, CreateVmByTemplateCmd> campusCoreVmCmdMap = new HashMap<String, CreateVmByTemplateCmd>();
    private final Map<String, AttachDiskCmd> campusCoreAttachDiskCmdMap = new HashMap<String, AttachDiskCmd>();
    private CampusServiceScenario campusServiceScenario = CampusServiceScenario.NORMAL;
    private CampusCoreTask serviceTaskResult;
    private Map<String, String> templateIds = new ConcurrentHashMap<String, String>();
    private List<CampusCoreTemplate> templates = new ArrayList<CampusCoreTemplate>();
    private CampusCoreParam campusCoreParam;
    private List<String> vmIds = new ArrayList<String>();
    private String deployCampusVmsTaskId;

    public static DeployCampusCoreContext getInstance() {
        return DeployCampusCoreContextHolder.instance;
    }

    public static void reset() {
        DeployCampusCoreContextHolder.instance = new DeployCampusCoreContext();
    }

    public void setCreateVmByTemplateCmd(String hostName, CreateVmByTemplateCmd cmd) {
        this.campusCoreVmCmdMap.put(hostName, cmd);
    }

    public CreateVmByTemplateCmd getCreateVmByTemplateCmd(String hostName) {
        return this.campusCoreVmCmdMap.get(hostName);
    }

    public AttachDiskCmd getAttachDiskCmd(String hostName) {
        return this.campusCoreAttachDiskCmdMap.get(hostName);
    }

    private void setAttachDiskCmd(String hostName, AttachDiskCmd cmd) {
        this.campusCoreAttachDiskCmdMap.put(hostName, cmd);
    }

    public void setCampusCoreDeployParam(CampusCoreParam campusCoreParam) {
        this.campusCoreAttachDiskCmdMap.clear();
        this.campusCoreVmCmdMap.clear();
        this.campusCoreParam = campusCoreParam;
        this.setCampusCoreVms(campusCoreParam);
    }

    private void setCampusCoreVms(CampusCoreParam campusCoreParam) {
        campusCoreParam.getCampusCoreVmParams().forEach(this::buildCampusVmsParams);
    }

    private void buildCampusVmsParams(CampusCoreVmParam campusCoreVmParam) {
        this.buildCampusAttackDiskCmd(campusCoreVmParam);
        this.buildCampusVmByTemplateCmd(campusCoreVmParam);
    }

    private void buildCampusAttackDiskCmd(CampusCoreVmParam campusCoreVmParam) {
        AttachDiskCmd attachDiskCmd = AttachDiskCmd.builder().vmId(() -> TaskContext.get().getVmId()).hostName(campusCoreVmParam.getHostName()).diskCmds(campusCoreVmParam.getDiskCmd()).build();
        this.setAttachDiskCmd(campusCoreVmParam.getHostName(), attachDiskCmd);
    }

    private void buildCampusVmByTemplateCmd(CampusCoreVmParam campusCoreVmParam) {
        CreateVmByTemplateCmd createVmByTemplateCmd = ((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)CreateVmByTemplateCmd.builder().taskName(campusCoreVmParam.getHostName())).password(Objects.equals(campusCoreVmParam.getHostName(), "installer") ? null : DeployCampusCoreContext.getInstance().getCampusCoreParam().getCampusCorePasswordParam().getRootPwd()).hostName(campusCoreVmParam.getHostName()).nicConfigs(campusCoreVmParam.getNicConfigs()).cnaName(campusCoreVmParam.getCnaName())).vmName(campusCoreVmParam.getHostName())).cpuCores(campusCoreVmParam.getCpuCores())).datastoreName(campusCoreVmParam.getDataStore())).memorySizeGb(campusCoreVmParam.getMemory())).templateId(() -> this.templateIds.get(CampusCoreConstant.vmsTemplateMap.get(campusCoreVmParam.getHostName()))).vmIdHandler(this::addVmId)).isAutoStartVm(false)).build();
        this.setCreateVmByTemplateCmd(campusCoreVmParam.getHostName(), createVmByTemplateCmd);
    }

    public synchronized void addVmId(String vmId) {
        this.vmIds.add(vmId);
    }

    public void addTemplateId(String templateName, String templateId) {
        this.templateIds.put(templateName, templateId);
    }

    @Generated
    public Map<String, CreateVmByTemplateCmd> getCampusCoreVmCmdMap() {
        return this.campusCoreVmCmdMap;
    }

    @Generated
    public Map<String, AttachDiskCmd> getCampusCoreAttachDiskCmdMap() {
        return this.campusCoreAttachDiskCmdMap;
    }

    @Generated
    public CampusServiceScenario getCampusServiceScenario() {
        return this.campusServiceScenario;
    }

    @Generated
    public CampusCoreTask getServiceTaskResult() {
        return this.serviceTaskResult;
    }

    @Generated
    public Map<String, String> getTemplateIds() {
        return this.templateIds;
    }

    @Generated
    public List<CampusCoreTemplate> getTemplates() {
        return this.templates;
    }

    @Generated
    public CampusCoreParam getCampusCoreParam() {
        return this.campusCoreParam;
    }

    @Generated
    public List<String> getVmIds() {
        return this.vmIds;
    }

    @Generated
    public String getDeployCampusVmsTaskId() {
        return this.deployCampusVmsTaskId;
    }

    @Generated
    public void setCampusServiceScenario(CampusServiceScenario campusServiceScenario) {
        this.campusServiceScenario = campusServiceScenario;
    }

    @Generated
    public void setServiceTaskResult(CampusCoreTask serviceTaskResult) {
        this.serviceTaskResult = serviceTaskResult;
    }

    @Generated
    public void setTemplateIds(Map<String, String> templateIds) {
        this.templateIds = templateIds;
    }

    @Generated
    public void setTemplates(List<CampusCoreTemplate> templates) {
        this.templates = templates;
    }

    @Generated
    public void setCampusCoreParam(CampusCoreParam campusCoreParam) {
        this.campusCoreParam = campusCoreParam;
    }

    @Generated
    public void setVmIds(List<String> vmIds) {
        this.vmIds = vmIds;
    }

    @Generated
    public void setDeployCampusVmsTaskId(String deployCampusVmsTaskId) {
        this.deployCampusVmsTaskId = deployCampusVmsTaskId;
    }

    @Generated
    private DeployCampusCoreContext() {
    }

    private static class DeployCampusCoreContextHolder {
        static DeployCampusCoreContext instance = new DeployCampusCoreContext();

        private DeployCampusCoreContextHolder() {
        }
    }
}

