/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.campuscore.task.service;

import com.alibaba.fastjson2.JSON;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.constant.CampusCoreConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.context.DeployCampusCoreContext;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.entity.CampusServiceScenario;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.exception.DeployCampusCoreError;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.exception.DeployCampusCoreException;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.task.service.CampusServiceStepTask;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.task.service.entity.CampusCoreSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.task.service.entity.CampusCoreTask;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.utils.SshConnectCampusServiceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.RetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshErrParser;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryCampusDetailsTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryCampusDetailsTask.class);
    public static final String TASK_NAME = "deploy.campus.execute.install.script";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private List<BaseTask> campusErrorSubtasks;

    @NotNull
    private static Optional<LocalDateTime> parseCampusTime(String time) {
        if (StringUtils.isEmpty((CharSequence)time)) {
            return Optional.empty();
        }
        return Optional.of(LocalDateTime.parse(time, DATE_TIME_FORMATTER));
    }

    private BaseTask buildTask(CampusCoreSubTask campusCoreSubTask) {
        return ((CampusServiceStepTask.CampusServiceStepTaskBuilder)((CampusServiceStepTask.CampusServiceStepTaskBuilder)((CampusServiceStepTask.CampusServiceStepTaskBuilder)((CampusServiceStepTask.CampusServiceStepTaskBuilder)CampusServiceStepTask.builder().taskId(campusCoreSubTask.getId())).taskName(campusCoreSubTask.getName())).duration(campusCoreSubTask.getDurationTime())).taskDescription(campusCoreSubTask.getDetailMsg())).build();
    }

    public void beforeExecute() {
        CampusServiceScenario campusServiceScenario = DeployCampusCoreContext.getInstance().getCampusServiceScenario();
        if (campusServiceScenario == CampusServiceScenario.RETRY || campusServiceScenario == CampusServiceScenario.SKIP) {
            try (SshShellService shellService = SshConnectCampusServiceUtils.getShellClient();){
                String cdResult = shellService.execCommand(StringUtils.formatTxt((String)"cd %s", (Object[])new Object[]{CampusCoreConstant.TARGET_QUERY_SCRIPT_EXECUTE_PATH}));
                if (SshErrParser.isInvalidResult((String)cdResult)) {
                    log.error("The eCampusCore query details directory does not exist");
                    throw new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_QUERY_SCRIPT_FAILED);
                }
                for (BaseTask baseTask : this.campusErrorSubtasks) {
                    ThreadUtils.threadSafeSleep((int)1, (TimeUnit)TimeUnit.SECONDS);
                    String result = shellService.execCommand(StringUtils.formatTxt((String)"sh action.sh %s %s", (Object[])new Object[]{campusServiceScenario.toString().toLowerCase(Locale.ROOT), baseTask.getTaskName()}));
                    log.info("execute eCampusCore retry or skip command, result = {}", (Object)result);
                }
                DeployCampusCoreContext.getInstance().setCampusServiceScenario(CampusServiceScenario.NORMAL);
            }
            catch (SshException e) {
                log.error("ssh execute error", (Throwable)e);
                throw new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_SSH_OPTION_ERROR);
            }
            catch (Exception e) {
                log.error("eCampusCore Service Deploy failed:", (Throwable)e);
                throw new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_SERVICE_DEPLOY_FAILED);
            }
        }
        ThreadUtils.threadSafeSleep((int)10, (TimeUnit)TimeUnit.SECONDS);
    }

    public void execute() throws TaskException {
        try (SshShellService shellService = SshConnectCampusServiceUtils.getShellClient();){
            String cdResult = shellService.execCommand(StringUtils.formatTxt((String)"cd %s", (Object[])new Object[]{CampusCoreConstant.TARGET_QUERY_SCRIPT_EXECUTE_PATH}));
            if (SshErrParser.isInvalidResult((String)cdResult)) {
                log.error("The eCampusCore query details directory does not exist");
                throw new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_QUERY_SCRIPT_FAILED);
            }
            RetryUtils.retry(() -> this.getResult(shellService), this::isAllSubTaskSuccess, (int)this.getTimeout(), (TimeUnit)TimeUnit.MINUTES);
        }
        catch (SshException e) {
            log.error("ssh execute error", (Throwable)e);
            throw new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("eCampusCore Service Deploy failed:", (Throwable)e);
            throw new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_SERVICE_DEPLOY_FAILED);
        }
    }

    private boolean isAllSubTaskSuccess(Map<String, BaseTaskResult> resultMap) {
        if (MapUtils.isEmpty(resultMap)) {
            return false;
        }
        this.getSubTasks().stream().filter(task -> resultMap.containsKey(task.getTaskId())).forEach(task -> task.setTaskResult((BaseTaskResult)resultMap.get(task.getTaskId())));
        this.campusErrorSubtasks = this.getSubTasks().stream().filter(BaseTask::isErrorOrPaused).collect(Collectors.toList());
        if (this.getSubTasks().stream().anyMatch(BaseTask::isRunning)) {
            return false;
        }
        this.getSubTasks().stream().filter(BaseTask::isErrorOrPaused).findFirst().ifPresent(task -> {
            throw new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_SERVICE_DEPLOY_FAILED, Collections.singletonList(task.getTaskResult().getErrorMessage()));
        });
        return this.getSubTasks().stream().allMatch(BaseTask::isSuccess);
    }

    private Map<String, BaseTaskResult> getResult(SshShellService shellService) {
        try {
            String campusCoreTaskJson = this.getCampusCoreTaskJson(shellService.execCommand("sh query_install_task.sh"));
            if (StringUtils.isEmpty((CharSequence)campusCoreTaskJson)) {
                return Collections.emptyMap();
            }
            CampusCoreTask campusCoreTask = (CampusCoreTask)JSON.parseObject((String)campusCoreTaskJson, CampusCoreTask.class);
            this.setSubTasks(campusCoreTask.getTaskDetails().stream().map(this::buildTask).collect(Collectors.toList()));
            return campusCoreTask.getTaskDetails().stream().collect(Collectors.toMap(CampusCoreSubTask::getId, this::buildTaskResult));
        }
        catch (SshException e) {
            log.error("get eCampusCore service task step failed", (Throwable)e);
            throw new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_SERVICE_INVOKE_FAILED);
        }
    }

    private BaseTaskResult buildTaskResult(CampusCoreSubTask campusCoreSubTask) {
        BaseTaskResult baseTaskResult = new BaseTaskResult();
        baseTaskResult.setStartTime((LocalDateTime)QueryCampusDetailsTask.parseCampusTime(campusCoreSubTask.getStartTime()).orElse(null));
        baseTaskResult.setEndTime((LocalDateTime)QueryCampusDetailsTask.parseCampusTime(campusCoreSubTask.getFinishTime()).orElse(null));
        TaskStatus status = CampusCoreConstant.TASK_STATUS_MAP.entrySet().stream().filter(entry -> campusCoreSubTask.getStatus().equals(entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(TaskStatus.ERROR);
        baseTaskResult.setTaskStatus(status);
        baseTaskResult.setErrorMessage(campusCoreSubTask.getErrMsg());
        return baseTaskResult;
    }

    private String getCampusCoreTaskJson(String taskResult) {
        log.info("current service deploy info:{}", (Object)taskResult);
        return Arrays.stream(taskResult.split("\r\n")).filter(line -> line.startsWith("{") && line.endsWith("}")).findFirst().orElse("");
    }

    private int getTimeout() {
        int timeout = 180;
        log.info("query deploy detail timeout is {}.", (Object)timeout);
        return timeout;
    }

    @Generated
    private static List<BaseTask> $default$campusErrorSubtasks() {
        return Collections.emptyList();
    }

    @Generated
    protected QueryCampusDetailsTask(QueryCampusDetailsTaskBuilder<?, ?> b) {
        super(b);
        this.campusErrorSubtasks = ((QueryCampusDetailsTaskBuilder)b).campusErrorSubtasks$set ? ((QueryCampusDetailsTaskBuilder)b).campusErrorSubtasks$value : QueryCampusDetailsTask.$default$campusErrorSubtasks();
    }

    @Generated
    public static QueryCampusDetailsTaskBuilder<?, ?> builder() {
        return new QueryCampusDetailsTaskBuilderImpl();
    }

    @Generated
    private static final class QueryCampusDetailsTaskBuilderImpl
    extends QueryCampusDetailsTaskBuilder<QueryCampusDetailsTask, QueryCampusDetailsTaskBuilderImpl> {
        @Generated
        private QueryCampusDetailsTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected QueryCampusDetailsTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public QueryCampusDetailsTask build() {
            return new QueryCampusDetailsTask(this);
        }
    }

    @Generated
    public static abstract class QueryCampusDetailsTaskBuilder<C extends QueryCampusDetailsTask, B extends QueryCampusDetailsTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private boolean campusErrorSubtasks$set;
        @Generated
        private List<BaseTask> campusErrorSubtasks$value;

        @Generated
        public B campusErrorSubtasks(List<BaseTask> campusErrorSubtasks) {
            this.campusErrorSubtasks$value = campusErrorSubtasks;
            this.campusErrorSubtasks$set = true;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "QueryCampusDetailsTask.QueryCampusDetailsTaskBuilder(super=" + super.toString() + ", campusErrorSubtasks$value=" + this.campusErrorSubtasks$value + ")";
        }
    }
}

