/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.campuscore.task.service;

import com.huawei.smartkit.drop.util.sensitive.SensitiveUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.constant.CampusCoreConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.context.DeployCampusCoreContext;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.entity.CampusCoreBaseParam;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.entity.CampusCoreParam;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.entity.CampusCorePasswordParam;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.entity.CampusCoreVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.exception.DeployCampusCoreError;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.exception.DeployCampusCoreException;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.utils.SshConnectCampusServiceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.constant.LineSeparator;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileContentOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ZipUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadSoftwareTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UploadSoftwareTask.class);
    public static final String TASK_NAME = "upload.campus.service.deploy.files";
    private static final String PRE_INSTALL_FILE = "eCampusCore_.*?_PreInstallation_(x86_64|aarch64)\\.zip$";
    private static final String VHD_CAMPUS_IMAGE = "VMTemplate_(x86_64|aarch64)_CampusContainerImage\\.zip$";
    private static final String CAMPUS_CLEAR_ENVIRONMENT = "shopt -s extglob && cd /image/ && rm -rf !(registry|lost+found)";
    private String softwarePath;
    private CampusCoreParam campusCoreParam;

    private static String getSoftwarePath() {
        return Optional.of(DeployCampusCoreContext.getInstance().getCampusCoreParam()).map(CampusCoreParam::getCampusCoreBaseParam).map(CampusCoreBaseParam::getSoftwarePath).orElse("");
    }

    public void beforeExecute() {
        this.softwarePath = Optional.ofNullable(DeployCampusCoreContext.getInstance().getCampusCoreParam()).map(CampusCoreParam::getCampusCoreBaseParam).map(CampusCoreBaseParam::getSoftwarePath).orElse("");
        if (StringUtils.isEmpty((CharSequence)this.softwarePath) || !FilePathValidatorUtils.isValidExistPaths((String[])new String[]{this.softwarePath})) {
            throw new TaskException((ErrorKey)DeployCampusCoreError.SOFTWARE_PATH_CHECK_FAILED);
        }
        this.campusCoreParam = DeployCampusCoreContext.getInstance().getCampusCoreParam();
    }

    public void execute() throws TaskException {
        this.clearEnvironment();
        this.uploadSoftwarePackages();
        this.replaceJsonFile();
        this.unzipInstallPackage();
        this.uploadJsonFiles();
        this.executePwdScript();
        this.executeInstallScript();
    }

    private void clearEnvironment() {
        try (SshShellService shellService = SshConnectCampusServiceUtils.getShellClient();){
            String result = shellService.execCommand(CAMPUS_CLEAR_ENVIRONMENT);
            log.info("execute [{}], result = {}.", (Object)CAMPUS_CLEAR_ENVIRONMENT, (Object)result);
            this.appendTaskDetail(result);
        }
        catch (SshException e) {
            log.error("ssh execute error", (Throwable)e);
            throw new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("ssh connect error:", (Throwable)e);
            throw new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_SSH_CONNECT_ERROR);
        }
    }

    public void afterExecute() {
        FileOperateUtils.deleteDirectory((String)CampusCoreConstant.CAMPUS_CACHE);
    }

    private void executeInstallScript() {
        try (SshShellService shellService = SshConnectCampusServiceUtils.getShellClient();){
            String cmd = StringUtils.formatTxt((String)"cd %s", (Object[])new Object[]{CampusCoreConstant.TARGET_SCRIPT_EXECUTE_PATH});
            String result = shellService.execCommand(cmd);
            log.info("execute [{}], result = {}.", (Object)cmd, (Object)result);
            this.appendTaskDetail(result);
            cmd = "sh oneclick_install.sh -install True;echo last cmd result: $?";
            result = shellService.execCommandWithTimeout(cmd, 900);
            log.info("execute [{}], result = {}.", (Object)cmd, (Object)result);
            this.appendTaskDetail(result);
            if (!result.contains("last cmd result: 0")) {
                this.appendTaskDetail("Failed to execute sh oneclick_install.sh -install True, not last cmd result: 0");
                throw new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_SERVICE_INVOKE_FAILED);
            }
        }
        catch (SshException e) {
            log.error("ssh execute error", (Throwable)e);
            throw new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("ssh connect error:", (Throwable)e);
            throw new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_SSH_CONNECT_ERROR);
        }
    }

    private void executePwdScript() {
        try (SshShellService shellService = SshConnectCampusServiceUtils.getShellClient();){
            String cmd = StringUtils.formatTxt((String)"cd %s", (Object[])new Object[]{CampusCoreConstant.TARGET_SCRIPT_EXECUTE_PATH});
            String result = shellService.execCommand(cmd);
            log.info(result);
            this.appendTaskDetail(result);
            result = shellService.execCommand("sh encrypt_pwd.sh");
            CampusCorePasswordParam campusCorePasswordParam = this.campusCoreParam.getCampusCorePasswordParam();
            LinkedHashMap<String, String> pwdMap = new LinkedHashMap<String, String>();
            pwdMap.put("please input COMMON_DEFAULT_PASSWORD:", campusCorePasswordParam.getDefaultPwd());
            pwdMap.put("please input COMMON_DEFAULT_PASSWORD_2:", campusCorePasswordParam.getDefaultPwdSecond());
            pwdMap.put("please input FUSION_CUBE_PASSWORD:", campusCorePasswordParam.getInterfaceUserPwd());
            pwdMap.put("please input HOST_ROOT_PASSWORD:", campusCorePasswordParam.getRootPwd());
            pwdMap.put("please input HOST_SYSOMC_PASSWORD:", campusCorePasswordParam.getSysPwd());
            for (Map.Entry pwdEntry : pwdMap.entrySet()) {
                if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{(String)pwdEntry.getKey()})) {
                    result = shellService.execCommand(StringUtils.defaultString((String)((String)pwdEntry.getValue())));
                    this.printLogInfo(result, (String)pwdEntry.getValue());
                }
                SensitiveUtils.cleanStr((String)((String)pwdEntry.getValue()));
            }
        }
        catch (SshException e) {
            log.error("ssh execute error", (Throwable)e);
            throw new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("ssh connect error:", (Throwable)e);
            throw new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_SSH_CONNECT_ERROR);
        }
    }

    private void printLogInfo(String result, String pwd) {
        String logInfo = StringUtils.replaceSensitiveTexts((String)result, (String)pwd);
        log.info(logInfo);
        this.appendTaskDetail(logInfo);
    }

    private void unzipInstallPackage() {
        String preInstallFileName = new File((String)Arrays.stream(new File(this.softwarePath).listFiles()).filter(file -> file.getName().matches(PRE_INSTALL_FILE) && file.getName().contains(this.getArch())).findFirst().flatMap(FilePathValidatorUtils::getSafePath).orElseThrow(() -> new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_SERVICE_DEPLOY_FAILED))).getName();
        try (SshShellService shellService = SshConnectCampusServiceUtils.getShellClient();){
            String cmd = StringUtils.formatTxt((String)"cd %s", (Object[])new Object[]{CampusCoreConstant.TARGET_UPLOAD_PATH});
            String result = shellService.execCommand(cmd);
            log.info("execute cd /image cmd, result = {}", (Object)result);
            this.appendTaskDetail(result);
            cmd = StringUtils.formatTxt((String)"unzip -o %s -d /opt/hicampus_install", (Object[])new Object[]{preInstallFileName});
            result = shellService.execCommand(cmd);
            log.info("unzip {}, result = {}.", (Object)preInstallFileName, (Object)result);
            this.appendTaskDetail(cmd);
        }
        catch (SshException e) {
            log.error("ssh execute error", (Throwable)e);
            throw new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("ssh connect error:", (Throwable)e);
            throw new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_SSH_CONNECT_ERROR);
        }
    }

    private String getArch() {
        return new File((String)Arrays.stream((Object[])Objects.requireNonNull(new File(this.softwarePath).listFiles())).filter(file -> file.getName().matches(VHD_CAMPUS_IMAGE)).findFirst().flatMap(FilePathValidatorUtils::getSafePath).orElseThrow(() -> new DeployCampusCoreException(DeployCampusCoreError.TEMPLATE_FILE_INTEGRITY_FAILED))).getName().contains("aarch64") ? "aarch64" : "x86_64";
    }

    private void uploadJsonFiles() {
        try (SshSftpService sftpService = SshConnectCampusServiceUtils.getSftpClient();){
            Arrays.stream(new File(CampusCoreConstant.CAMPUS_PARAM_CACHE).listFiles()).filter(File::isFile).collect(Collectors.toList()).forEach(file -> this.uploadFile(sftpService, (File)file, CampusCoreConstant.TARGET_JSON_FILE_PATH));
        }
        catch (SshException e) {
            log.error("ssh execute error", (Throwable)e);
            throw new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("UploadSoftwareTask error", (Throwable)e);
            throw new DeployCampusCoreException(DeployCampusCoreError.UPLOAD_SOFTWARE_PACKAGE_FAILED);
        }
    }

    private void replaceJsonFile() {
        log.info("start to unzip eCampusCore preInstallation to get json file");
        this.appendTaskDetail("start to unzip eCampusCore preInstallation to get json file");
        String preInstallZipFile = (String)Arrays.stream(Objects.requireNonNull(new File(UploadSoftwareTask.getSoftwarePath())).listFiles()).filter(file -> file.getName().matches(PRE_INSTALL_FILE) && file.getName().contains(this.getArch())).findFirst().flatMap(FilePathValidatorUtils::getSafePath).orElseThrow(() -> new DeployCampusCoreException(DeployCampusCoreError.PREINSTALLATION_FILE_INTEGRITY_FAILED));
        this.createTemplateCache(new File(CampusCoreConstant.CAMPUS_PREINSTALL_CACHE));
        ZipUtils.decompressFileBy7Zip((String)CampusCoreConstant.ZIP_TOOL_PATH, (String)preInstallZipFile, (String)CampusCoreConstant.CAMPUS_PREINSTALL_CACHE);
        String jsonfilePath = FilePathValidatorUtils.joinChildPath((String[])new String[]{CampusCoreConstant.CAMPUS_PREINSTALL_CACHE, "installUtil", "requestBody"});
        log.info("end to unzip eCampusCore preInstallation to get json file");
        this.appendTaskDetail("end to unzip eCampusCore preInstallation to get json file");
        CampusCoreParam param = DeployCampusCoreContext.getInstance().getCampusCoreParam();
        this.createTemplateCache(new File(CampusCoreConstant.CAMPUS_PARAM_CACHE));
        this.buildLevel(param, FilePathValidatorUtils.joinChildPath((String[])new String[]{jsonfilePath, "IaaS.json"}));
        this.buildGlobalParam(param, FilePathValidatorUtils.joinChildPath((String[])new String[]{jsonfilePath, "global.json"}));
        this.buildDeployParam(param, FilePathValidatorUtils.joinChildPath((String[])new String[]{jsonfilePath, "install.json"}));
    }

    private void buildDeployParam(CampusCoreParam param, String path) {
        HashMap<String, String> deployMap = new HashMap<String, String>();
        deployMap.put("{CAMPUSLBSERVICE_VIP}", param.getCampusCoreBaseParam().getManageFloatIp());
        deployMap.put("{NFS_VIP}", param.getCampusCoreBaseParam().getNfsFloatIp());
        String dnsAddress = param.getCampusCoreBaseParam().getDnsAddress();
        deployMap.put("{INTERNET_DNS_ADDR}", StringUtils.isEmpty((CharSequence)dnsAddress) ? "0.0.0.0" : dnsAddress);
        deployMap.put("{GAUSSV5_VIP}", param.getCampusCoreBaseParam().getGaussFloatIp());
        deployMap.put("{MANAGE_IP_RANGE_START}", param.getCampusCoreBaseParam().getManageStartIp());
        deployMap.put("{MANAGE_IP_RANGE_END}", param.getCampusCoreBaseParam().getManageEndIp());
        deployMap.put("{manage_port_name}", param.getCampusCoreLevelParam().getManagePortGroup());
        Arrays.asList("foundation-1", "foundation-2", "foundation-3", "nfs-dns-1", "nfs-dns-2", "gaussv5-1", "gaussv5-2", "ops-1", "ops-2").forEach(vmName -> this.generateVmInfo(param, (Map<String, String>)deployMap, (String)vmName));
        this.buildParamJson(path, deployMap, CampusCoreConstant.CAMPUS_PARAM_CACHE_DEPLOY);
    }

    private void generateVmInfo(CampusCoreParam param, Map<String, String> deployMap, String vmName) {
        CampusCoreVmParam campusCoreVmParam = this.findVmByName(param, vmName);
        deployMap.put(StringUtils.formatTxt((String)"{%s_manage_ip}", (Object[])new Object[]{vmName}), campusCoreVmParam.getOmIp());
    }

    private CampusCoreVmParam findVmByName(CampusCoreParam param, String vmName) {
        return param.getCampusCoreVmParams().stream().filter(campusCoreVmParam -> vmName.equals(campusCoreVmParam.getHostName())).findFirst().orElseThrow(() -> new DeployCampusCoreException(DeployCampusCoreError.CHECK_VM_FAILED, Collections.singletonList(vmName)));
    }

    private void buildGlobalParam(CampusCoreParam param, String path) {
        HashMap<String, String> globalMap = new HashMap<String, String>();
        globalMap.put("{INSTALLER_HOST}", param.getCampusCoreVmParams().get(0).getOmIp());
        globalMap.put("{HOST_TIME_ZONE}", param.getCampusCoreGlobalParam().getTimeZone());
        globalMap.put("{NTP_SERVER_IP}", param.getCampusCoreGlobalParam().getNtpIp());
        globalMap.put("{DCS_SERVITIZATION_EDME_URL}", param.getCampusCoreGlobalParam().getDmeIp());
        globalMap.put("{DEFAULT_LANG}", param.getCampusCoreGlobalParam().getLanguage());
        this.buildParamJson(path, globalMap, CampusCoreConstant.CAMPUS_PARAM_CACHE_GLOBAL);
    }

    private void buildLevel(CampusCoreParam param, String path) {
        HashMap<String, String> levelMap = new HashMap<String, String>();
        levelMap.put("{fusioncompute_url}", StringUtils.formatTxt((String)"https://%s", (Object[])new Object[]{param.getCampusCoreBaseParam().getFcIp()}));
        levelMap.put("{fusioncompute_username}", param.getCampusCoreLevelParam().getInterfaceUser());
        levelMap.put("{datastore_name}", param.getCampusCoreVmParams().get(0).getDataStore());
        levelMap.put("{netmask}", param.getCampusCoreLevelParam().getNetmask());
        levelMap.put("{manage_port_name}", param.getCampusCoreLevelParam().getManagePortGroup());
        levelMap.put("{manage_gateway}", param.getCampusCoreLevelParam().getManageGateway());
        this.buildParamJson(path, levelMap, CampusCoreConstant.CAMPUS_PARAM_CACHE_LEVEL);
    }

    private void buildParamJson(String originPath, Map<String, String> replaceMap, String targetPath) {
        try {
            if (!FileContentOperateUtils.replaceTextFileContentByUtf((String)originPath, (String)targetPath, replaceMap, (LineSeparator)LineSeparator.WINDOWS)) {
                log.error("replace {} file failed.", (Object)new File(originPath).getName());
                throw new DeployCampusCoreException(DeployCampusCoreError.REPLACE_JSON_FILE_FAILED);
            }
        }
        catch (IOException e) {
            throw new DeployCampusCoreException(DeployCampusCoreError.REPLACE_JSON_FILE_FAILED);
        }
    }

    private void createTemplateCache(File file) {
        if (!file.exists() && !file.mkdirs()) {
            throw new DeployCampusCoreException(DeployCampusCoreError.CREATE_PARAM_CACHE_FAILED);
        }
    }

    private void uploadSoftwarePackages() throws DeployCampusCoreException {
        try (SshSftpService sftpService = SshConnectCampusServiceUtils.getSftpClient();){
            File[] packageFiles = this.getPackageFiles(this.softwarePath);
            ConsistencyPattern.getEcampusCorePattern().keySet().stream().filter(softwarePattern -> !softwarePattern.contains("VMTemplate")).map(softwarePattern -> this.getCampusCoreFile((String)softwarePattern, packageFiles)).map(File::new).forEach(file -> this.uploadFile(sftpService, (File)file, CampusCoreConstant.TARGET_UPLOAD_PATH));
        }
        catch (SshException e) {
            log.error("ssh execute error", (Throwable)e);
            throw new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("UploadSoftwareTask error", (Throwable)e);
            throw new DeployCampusCoreException(DeployCampusCoreError.UPLOAD_SOFTWARE_PACKAGE_FAILED);
        }
    }

    private String getCampusCoreFile(String regex, File[] files) {
        return (String)Arrays.stream((Object[])Objects.requireNonNull(files)).filter(file -> file.getName().matches(regex)).findFirst().flatMap(FilePathValidatorUtils::getSafePath).orElseThrow(() -> new DeployCampusCoreException(DeployCampusCoreError.CAMPUS_FILE_NOT_EXIST, Collections.singletonList(regex)));
    }

    private File[] getPackageFiles(String softwarePath) {
        File file = new File(softwarePath);
        if (!file.exists() || !file.isDirectory()) {
            throw new DeployCampusCoreException(DeployCampusCoreError.SOFTWARE_PACKAGE_PATH_INVALID);
        }
        Object[] files = file.listFiles(File::isFile);
        if (ArrayUtils.isEmpty((Object[])files)) {
            throw new DeployCampusCoreException(DeployCampusCoreError.SOFTWARE_PACKAGE_PATH_INVALID);
        }
        return files;
    }

    private void uploadFile(SshSftpService sftpService, File file, String targetPath) {
        String fileName = file.getName();
        log.info("upload file: {}", (Object)fileName);
        String path = (String)FilePathValidatorUtils.getSafePath((File)file).orElseThrow(() -> new DeployCampusCoreException(DeployCampusCoreError.SOFTWARE_PACKAGE_PATH_INVALID));
        try {
            if (sftpService.upload(path, targetPath, (SftpProgCallback)new DefaultSftpProgCallback(fileName))) {
                return;
            }
        }
        catch (SshException e) {
            log.error("Failed to upload {}", (Object)fileName, (Object)e);
        }
        throw new DeployCampusCoreException(DeployCampusCoreError.UPLOAD_SOFTWARE_PACKAGE_FAILED);
    }

    @Generated
    protected UploadSoftwareTask(UploadSoftwareTaskBuilder<?, ?> b) {
        super(b);
        this.softwarePath = ((UploadSoftwareTaskBuilder)b).softwarePath;
        this.campusCoreParam = ((UploadSoftwareTaskBuilder)b).campusCoreParam;
    }

    @Generated
    public static UploadSoftwareTaskBuilder<?, ?> builder() {
        return new UploadSoftwareTaskBuilderImpl();
    }

    @Generated
    private static final class UploadSoftwareTaskBuilderImpl
    extends UploadSoftwareTaskBuilder<UploadSoftwareTask, UploadSoftwareTaskBuilderImpl> {
        @Generated
        private UploadSoftwareTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected UploadSoftwareTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public UploadSoftwareTask build() {
            return new UploadSoftwareTask(this);
        }
    }

    @Generated
    public static abstract class UploadSoftwareTaskBuilder<C extends UploadSoftwareTask, B extends UploadSoftwareTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private String softwarePath;
        @Generated
        private CampusCoreParam campusCoreParam;

        @Generated
        public B softwarePath(String softwarePath) {
            this.softwarePath = softwarePath;
            return (B)this.self();
        }

        @Generated
        public B campusCoreParam(CampusCoreParam campusCoreParam) {
            this.campusCoreParam = campusCoreParam;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "UploadSoftwareTask.UploadSoftwareTaskBuilder(super=" + super.toString() + ", softwarePath=" + this.softwarePath + ", campusCoreParam=" + this.campusCoreParam + ")";
        }
    }
}

