/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.campuscore.task.vm;

import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.constant.CampusCoreConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.context.DeployCampusCoreContext;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.exception.DeployCampusCoreError;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.exception.DeployCampusCoreException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcClientService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CampusCoreTemplateCleanTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CampusCoreTemplateCleanTask.class);
    public static final String TASK_NAME = "deploy.campus.template.clean";

    public void execute() throws TaskException {
        DeployCampusCoreContext context = DeployCampusCoreContext.getInstance();
        Map<String, String> templateIds = context.getTemplateIds();
        if (Objects.isNull(templateIds)) {
            log.info("template id is empty, no need to delete.");
            return;
        }
        try {
            ApiClient apiClient = FcClientService.createApiService((FcLoginInfo)DeployCampusCoreContext.getInstance().getCampusCoreParam().getFcLoginInfo());
            for (String templateName : templateIds.keySet()) {
                log.info("start to delete eCampusCore template. Template mame: {}, template id : {}", (Object)templateName, (Object)templateIds.get(templateName));
                if (apiClient.deleteVm(templateIds.get(templateName))) continue;
                log.warn("delete eCampusCore template {} failed", (Object)templateName);
            }
        }
        catch (FcTaskException e) {
            this.appendTaskDetail("delete eCampusCore template failed");
            log.error("delete eCampusCore template failed.", (Throwable)e);
            throw new DeployCampusCoreException(DeployCampusCoreError.DELETE_TEMPLATE_FAILED);
        }
        finally {
            FileOperateUtils.deleteDirectory((String)CampusCoreConstant.CAMPUS_TEMPORARY_CACHE);
        }
    }

    @Generated
    protected CampusCoreTemplateCleanTask(CampusCoreTemplateCleanTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static CampusCoreTemplateCleanTaskBuilder<?, ?> builder() {
        return new CampusCoreTemplateCleanTaskBuilderImpl();
    }

    @Generated
    private static final class CampusCoreTemplateCleanTaskBuilderImpl
    extends CampusCoreTemplateCleanTaskBuilder<CampusCoreTemplateCleanTask, CampusCoreTemplateCleanTaskBuilderImpl> {
        @Generated
        private CampusCoreTemplateCleanTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected CampusCoreTemplateCleanTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CampusCoreTemplateCleanTask build() {
            return new CampusCoreTemplateCleanTask(this);
        }
    }

    @Generated
    public static abstract class CampusCoreTemplateCleanTaskBuilder<C extends CampusCoreTemplateCleanTask, B extends CampusCoreTemplateCleanTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "CampusCoreTemplateCleanTask.CampusCoreTemplateCleanTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

