/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.campuscore.task.vm.init;

import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.constant.CampusCoreConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.context.DeployCampusCoreContext;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.entity.CampusCoreBaseParam;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.entity.CampusCoreParam;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.entity.CampusCoreTemplate;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.exception.DeployCampusCoreError;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.exception.DeployCampusCoreException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ZipUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateUnzipTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateUnzipTask.class);
    public static final String TASK_NAME = "deploy.campus.template.unzip.task";
    private static final Pattern VHD_CAMPUS_IMAGE = Pattern.compile("^VMTemplate_(x86_64|aarch64)_CampusContainerImage\\.zip$");
    private static final Pattern VHD_EULER = Pattern.compile("^(?!.*Installer).*VMTemplate_(x86_64|aarch64)_Euler.*?\\.zip$");
    private static final Pattern VHD_EULER_INSTALL = Pattern.compile("^VMTemplate_(x86_64|aarch64)_Euler.*?_Installer\\.zip$");
    private String softwarePath;

    @NotNull
    private static String getSoftwarePath() {
        return Optional.of(DeployCampusCoreContext.getInstance().getCampusCoreParam()).map(CampusCoreParam::getCampusCoreBaseParam).map(CampusCoreBaseParam::getSoftwarePath).orElse("");
    }

    private static String getTemplateVhdFile(String sfsTemporaryCache, String fileSuffix) {
        return FileUtils.listFiles((File)new File(sfsTemporaryCache), (String[])new String[]{fileSuffix}, (boolean)false).stream().map(FilePathValidatorUtils::getSafePath).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining(","));
    }

    public void beforeExecute() {
        this.softwarePath = TemplateUnzipTask.getSoftwarePath();
        if (StringUtils.isEmpty((CharSequence)this.softwarePath) || !FilePathValidatorUtils.isValidExistPaths((String[])new String[]{this.softwarePath})) {
            throw new TaskException((ErrorKey)DeployCampusCoreError.SOFTWARE_PATH_CHECK_FAILED);
        }
        FileOperateUtils.deleteDirectory((String)CampusCoreConstant.CAMPUS_TEMPORARY_CACHE);
        this.createTemplateCache(new File(CampusCoreConstant.CAMPUS_TEMPORARY_CACHE));
    }

    public void execute() throws TaskException {
        log.info("start to unzip eCampusCore template file.");
        this.appendTaskDetail("start to unzip eCampusCore template file.");
        Stream.of(VHD_CAMPUS_IMAGE, VHD_EULER, VHD_EULER_INSTALL).map(this::getCampusCoreTemplateFilePath).forEach(zipFile -> ZipUtils.decompressFileBy7Zip((String)CampusCoreConstant.ZIP_TOOL_PATH, (String)zipFile, (String)CampusCoreConstant.CAMPUS_TEMPORARY_CACHE));
        DeployCampusCoreContext.getInstance().setTemplates(CampusCoreConstant.templateNameMap.keySet().stream().map(this::addTemplateInfo).collect(Collectors.toList()));
        log.info("end to unzip eCampusCore template file.");
        this.appendTaskDetail("end to unzip eCampusCore template file.");
    }

    private CampusCoreTemplate addTemplateInfo(String regex) {
        log.info("Start looking for the folder that matches the current regular expression, regex: {}.", (Object)regex);
        this.appendTaskDetail("Start looking for the folder that matches the current regular expression, regex: " + regex);
        String fileName = Arrays.stream(new File(CampusCoreConstant.CAMPUS_TEMPORARY_CACHE).listFiles()).filter(File::isDirectory).filter(file -> file.getName().matches(regex)).findFirst().map(File::getName).orElseThrow(() -> new DeployCampusCoreException(DeployCampusCoreError.TEMPLATE_FILE_INTEGRITY_FAILED));
        String campusFilepath = FilePathValidatorUtils.joinChildPath((String[])new String[]{CampusCoreConstant.CAMPUS_TEMPORARY_CACHE, fileName});
        return CampusCoreTemplate.builder().templateName(CampusCoreConstant.templateNameMap.get(regex)).templateOvf(this.getTemplateUnzipFile(campusFilepath, "ovf")).templateVhd(TemplateUnzipTask.getTemplateVhdFile(campusFilepath, "vhd")).build();
    }

    private String getTemplateUnzipFile(String temporaryCache, String fileSuffix) {
        return (String)FileUtils.listFiles((File)new File(temporaryCache), (String[])new String[]{fileSuffix}, (boolean)false).stream().findFirst().flatMap(FilePathValidatorUtils::getSafePath).orElseThrow(() -> new DeployCampusCoreException(DeployCampusCoreError.TEMPLATE_FILE_INTEGRITY_FAILED));
    }

    private String getCampusCoreTemplateFilePath(Pattern pattern) {
        return (String)Arrays.stream((Object[])Objects.requireNonNull(new File(TemplateUnzipTask.getSoftwarePath()).listFiles())).filter(file -> pattern.matcher(file.getName()).find()).findFirst().flatMap(FilePathValidatorUtils::getSafePath).orElseThrow(() -> new DeployCampusCoreException(DeployCampusCoreError.TEMPLATE_FILE_INTEGRITY_FAILED));
    }

    private void createTemplateCache(File file) {
        if (!file.exists() && !file.mkdirs()) {
            throw new DeployCampusCoreException(DeployCampusCoreError.CREATE_TEMPLATE_CACHE_FAILED);
        }
    }

    @Generated
    protected TemplateUnzipTask(TemplateUnzipTaskBuilder<?, ?> b) {
        super(b);
        this.softwarePath = ((TemplateUnzipTaskBuilder)b).softwarePath;
    }

    @Generated
    public static TemplateUnzipTaskBuilder<?, ?> builder() {
        return new TemplateUnzipTaskBuilderImpl();
    }

    @Generated
    private static final class TemplateUnzipTaskBuilderImpl
    extends TemplateUnzipTaskBuilder<TemplateUnzipTask, TemplateUnzipTaskBuilderImpl> {
        @Generated
        private TemplateUnzipTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected TemplateUnzipTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TemplateUnzipTask build() {
            return new TemplateUnzipTask(this);
        }
    }

    @Generated
    public static abstract class TemplateUnzipTaskBuilder<C extends TemplateUnzipTask, B extends TemplateUnzipTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private String softwarePath;

        @Generated
        public B softwarePath(String softwarePath) {
            this.softwarePath = softwarePath;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "TemplateUnzipTask.TemplateUnzipTaskBuilder(super=" + super.toString() + ", softwarePath=" + this.softwarePath + ")";
        }
    }
}

