/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.campuscore.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.context.DeployCampusCoreContext;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.exception.DeployCampusCoreError;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.exception.DeployCampusCoreException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.CommonTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskStatus;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CampusCoreTaskUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CampusCoreTaskUtils.class);

    public static void skipTask(String taskId) {
        BaseTask task = (BaseTask)CommonTaskManager.getInstance().queryTaskById(DeployCampusCoreContext.getInstance().getDeployCampusVmsTaskId()).orElseThrow(() -> new DeployCampusCoreException(DeployCampusCoreError.TASK_ID_NOT_FOUND_ERROR));
        CampusCoreTaskUtils.setSkipStatus(CampusCoreTaskUtils.findSubTasks(task, taskId).orElseThrow(() -> new DeployCampusCoreException(DeployCampusCoreError.TASK_ID_NOT_FOUND_ERROR)));
    }

    private static void setSkipStatus(BaseTask baseTask) {
        if (CollectionUtils.isEmpty((Collection)baseTask.getSubTasks())) {
            return;
        }
        for (BaseTask task : baseTask.getSubTasks()) {
            if (task.getTaskResult().getTaskStatus() != TaskStatus.ERROR && task.getTaskResult().getTaskStatus() != TaskStatus.NOT_START) continue;
            task.getTaskResult().setTaskStatus(TaskStatus.SKIP);
            CampusCoreTaskUtils.setSkipStatus(task);
        }
    }

    private static Optional<BaseTask> findSubTasks(BaseTask task, String taskId) {
        if (task.getTaskId().equals(taskId)) {
            return Optional.of(task);
        }
        if (CollectionUtils.isNotEmpty((Collection)task.getSubTasks())) {
            for (BaseTask baseTask : task.getSubTasks()) {
                Optional<BaseTask> optionalBaseTask = CampusCoreTaskUtils.findSubTasks(baseTask, taskId);
                if (!optionalBaseTask.isPresent()) continue;
                return optionalBaseTask;
            }
        }
        return Optional.empty();
    }

    @Generated
    private CampusCoreTaskUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

