/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.campuscore.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.context.DeployCampusCoreContext;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.entity.CampusCoreVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.exception.DeployCampusCoreError;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.exception.DeployCampusCoreException;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshManager;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import java.util.Collections;
import lombok.Generated;
import org.apache.sshd.client.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshConnectCampusServiceUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SshConnectCampusServiceUtils.class);

    public static SshShellService getShellClient() throws SshException {
        ClientSession session = null;
        try {
            session = SshManager.getSession((SshConnInfo)SshConnectCampusServiceUtils.getSshConnInfo(DeployCampusCoreContext.getInstance().getCampusCoreParam().getCampusCorePasswordParam().getTemplatePwd()));
            SshShellService sshShellService = SshManager.createSshShellService((ClientSession)session);
            if (!sshShellService.isConnected()) {
                sshShellService.connect();
            }
            return sshShellService;
        }
        catch (SshException e) {
            log.info("try to use template default pwd ssh connect install failed, trying to use root pwd");
            try {
                session = SshManager.getSession((SshConnInfo)SshConnectCampusServiceUtils.getSshConnInfo(DeployCampusCoreContext.getInstance().getCampusCoreParam().getCampusCorePasswordParam().getRootPwd()));
                SshShellService sshShellService = SshManager.createSshShellService((ClientSession)session);
                if (!sshShellService.isConnected()) {
                    sshShellService.connect();
                }
                return sshShellService;
            }
            catch (SshException e2) {
                log.info("try to user root pwd ssh connect install failed");
                throw e2;
            }
        }
    }

    public static SshSftpService getSftpClient() throws SshException {
        ClientSession session = null;
        try {
            session = SshManager.getSession((SshConnInfo)SshConnectCampusServiceUtils.getSshConnInfo(DeployCampusCoreContext.getInstance().getCampusCoreParam().getCampusCorePasswordParam().getTemplatePwd()));
            SshSftpService sshSftpService = SshManager.createSshSftpService((ClientSession)session);
            if (!sshSftpService.isConnected()) {
                sshSftpService.connect();
            }
            return sshSftpService;
        }
        catch (SshException e) {
            log.info("try to use template default pwd sftp connect install failed, trying to use root pwd.", (Throwable)e);
            try {
                session = SshManager.getSession((SshConnInfo)SshConnectCampusServiceUtils.getSshConnInfo(DeployCampusCoreContext.getInstance().getCampusCoreParam().getCampusCorePasswordParam().getRootPwd()));
                SshSftpService sshSftpService = SshManager.createSshSftpService((ClientSession)session);
                if (!sshSftpService.isConnected()) {
                    sshSftpService.connect();
                }
                return sshSftpService;
            }
            catch (SshException e2) {
                log.info("try to user root pwd sftp connect install failed.", (Throwable)e2);
                throw e2;
            }
        }
    }

    public static SshConnInfo getSshConnInfo(String loginPwd) {
        DeployCampusCoreContext context = DeployCampusCoreContext.getInstance();
        CampusCoreVmParam installerParam = context.getCampusCoreParam().getCampusCoreVmParams().stream().filter(campusCoreVmParam -> "installer".equals(campusCoreVmParam.getHostName())).findFirst().orElseThrow(() -> new DeployCampusCoreException(DeployCampusCoreError.CHECK_VM_FAILED, Collections.singletonList("installer")));
        return SshConnInfo.builder().hostName(installerParam.getOmIp()).userName("root").userPwd(loginPwd).build();
    }

    @Generated
    private SshConnectCampusServiceUtils() {
    }
}

