/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.type.support;

import com.huawei.fitframework.core.common.type.TypeMatcher;
import com.huawei.fitframework.core.common.type.annotation.MatchTypes;
import com.huawei.fitframework.core.common.type.support.AbstractTypeMatcher;
import com.huawei.fitframework.core.common.util.IntegerUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.function.Supplier;

@MatchTypes(current=ParameterizedType.class, expected=ParameterizedType.class, factory=Factory.class)
public class ParameterizedTypeMatcher
extends AbstractTypeMatcher<ParameterizedType, ParameterizedType> {
    public ParameterizedTypeMatcher(ParameterizedType objectType, TypeMatcher.Context context) {
        super(objectType, context);
    }

    @Override
    protected boolean match0(ParameterizedType expectedType) {
        if (((ParameterizedType)this.getCurrentType()).getRawType() == expectedType.getRawType()) {
            return this.matchTypeArguments(((ParameterizedType)this.getCurrentType()).getActualTypeArguments(), expectedType.getActualTypeArguments());
        }
        return this.matchSuperTypes((Class)((ParameterizedType)this.getCurrentType()).getRawType(), expectedType);
    }

    @Override
    protected TypeMatcher.Context getSuperContext() {
        Class rawClass = (Class)ObjectUtils.cast(((ParameterizedType)this.getCurrentType()).getRawType());
        TypeVariable<Class<T>>[] typeVariables = rawClass.getTypeParameters();
        Type[] actualTypeArguments = ((ParameterizedType)this.getCurrentType()).getActualTypeArguments();
        TypeMatcher.Context.Builder builder = TypeMatcher.Context.builder();
        for (int i = 0; i < typeVariables.length; ++i) {
            TypeVariable variable = typeVariables[i];
            Type argument = actualTypeArguments[i];
            builder.setVariableValue(variable.getName(), this.supplyVariable(argument));
        }
        return builder.build();
    }

    private boolean matchTypeArguments(Type[] current, Type[] required) {
        Validation.isTrue(IntegerUtils.equals(current.length, required.length), "The current and required type number should be the same", new Object[0]);
        for (int i = 0; i < current.length; ++i) {
            if (TypeMatcher.match(current[i], required[i], this.getContext())) continue;
            return false;
        }
        return true;
    }

    private Supplier<Type> supplyVariable(Type argument) {
        if (argument instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)ObjectUtils.cast(argument);
            return () -> this.getContext().getVariableValue(variable.getName()).orElse(null);
        }
        return () -> argument;
    }

    public static class Factory
    implements TypeMatcher.Factory {
        @Override
        public TypeMatcher create(Type currentType, TypeMatcher.Context context) {
            return new ParameterizedTypeMatcher((ParameterizedType)ObjectUtils.cast(currentType), context);
        }
    }
}

