/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.EnumUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import java.util.Objects;

public interface CodeableEnum<T extends Enum<T>> {
    public Integer getId();

    public String getCode();

    public static <T extends Enum<T>> Integer getId(CodeableEnum<T> value) {
        return ObjectUtils.mapIfNotNull(value, item -> item.getId());
    }

    public static <T extends Enum<T>> String getCode(CodeableEnum<T> value) {
        return ObjectUtils.mapIfNotNull(value, item -> item.getCode());
    }

    public static <T extends Enum<T>> T fromId(Class<T> clz, Integer id) {
        return (T)EnumUtils.firstOrDefault(clz, item -> Objects.equals(((CodeableEnum)((Object)item)).getId(), id));
    }

    public static <T extends Enum<T>> T fromCode(Class<T> clz, String code) {
        return (T)EnumUtils.firstOrDefault(clz, item -> StringUtils.equalsIgnoreCase(((CodeableEnum)((Object)item)).getCode(), code));
    }
}

