/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.support.DefaultInterval;

public interface Interval<T extends Comparable<T>> {
    public T getMinimum();

    public T getMaximum();

    public boolean isMinimumAllowed();

    public boolean isMaximumAllowed();

    default public boolean contains(T value) {
        return ObjectUtils.between(value, this.getMinimum(), this.getMaximum(), this.isMinimumAllowed(), this.isMaximumAllowed());
    }

    public static <T extends Comparable<T>> Interval<T> create(T minimum, T maximum) {
        return Interval.create(minimum, maximum, true, true);
    }

    public static <T extends Comparable<T>> Interval<T> create(T minimum, T maximum, boolean minimumAllowed, boolean maximumAllowed) {
        return new DefaultInterval<T>(minimum, maximum, minimumAllowed, maximumAllowed);
    }
}

