/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.jar.JarFile;

public final class UrlUtils {
    public static final char PATH_SEPARATOR = '/';
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String JAR_IN_JAR_FILE_EXTENSION = ".jar!/";

    private UrlUtils() {
    }

    public static String combine(String base, String path) {
        if (base == null) {
            return path;
        }
        if (path == null) {
            return base;
        }
        return StringUtils.trimEnd(base, '/') + '/' + StringUtils.trimStart(path, '/');
    }

    public static String decode(String toDecode) {
        Validation.notNull(toDecode, "To decode string cannot be null.", new Object[0]);
        try {
            return URLDecoder.decode(toDecode, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unsupported decoding type: UTF-8.", e);
        }
    }

    public static String encode(String toEncode) {
        Validation.notNull(toEncode, "To encode string cannot be null.", new Object[0]);
        try {
            return URLEncoder.encode(toEncode, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unsupported encoding type: UTF-8.", e);
        }
    }

    public static boolean exists(URL url) {
        Validation.notNull(url, "Url cannot be null.", new Object[0]);
        try {
            File file = new File(url.toURI());
            return file.exists();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(StringUtils.format("Fail to convert url to file. [url={0}]", url.getPath()), e);
        }
    }

    public static boolean isJar(URL url) {
        Validation.notNull(url, "Url cannot be null.", new Object[0]);
        return url.getPath().endsWith(JAR_FILE_EXTENSION);
    }

    public static boolean isJarInJar(URL url) {
        Validation.notNull(url, "Url cannot be null.", new Object[0]);
        return url.getPath().endsWith(JAR_IN_JAR_FILE_EXTENSION);
    }

    public static JarFile toJarFile(URL url) {
        Validation.notNull(url, "Url cannot be null.", new Object[0]);
        try {
            return new JarFile(url.toURI().getPath());
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalStateException(StringUtils.format("Fail to create jar file. [url={0}]", url.getPath()), e);
        }
    }
}

