/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util.support;

import com.huawei.fitframework.core.common.util.ConflictResolutionPolicy;
import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.FunctionUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.core.common.util.support.AbstractZip;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.Generated;

public class Unzip
extends AbstractZip<Unzip> {
    private File target;
    private Predicate<ZipEntry> predicate;
    private Security security = Security.DEFAULT;
    private final List<Function<ZipEntry, Redirect>> redirectors = new ArrayList<Function<ZipEntry, Redirect>>();
    private final List<Function<Conflict, ConflictResolutionPolicy>> conflictResolvers = new ArrayList<Function<Conflict, ConflictResolutionPolicy>>();
    private ConflictResolutionPolicy conflictResolutionPolicy = ConflictResolutionPolicy.ABORT;

    public Unzip(File zipFile, Charset charset) {
        super(zipFile, charset);
    }

    public Unzip filter(Predicate<ZipEntry> predicate) {
        this.predicate = FunctionUtils.and(this.predicate, predicate);
        return this;
    }

    public Unzip redirect(Function<ZipEntry, Redirect> redirector) {
        Validation.notNull(redirector, "The mapper to redirect output file cannot be null.", new Object[0]);
        this.redirectors.add(redirector);
        return this;
    }

    public Unzip resolveConflict(ConflictResolutionPolicy policy) {
        this.conflictResolutionPolicy = ObjectUtils.nullIf(policy, ConflictResolutionPolicy.ABORT);
        return this;
    }

    public Unzip resolveEntryConflict(Function<Conflict, ConflictResolutionPolicy> resolver) {
        Validation.notNull(resolver, "The conflict resolver for entry cannot be null.", new Object[0]);
        this.conflictResolvers.add(resolver);
        return this;
    }

    public Unzip secure(Security security) {
        this.security = ObjectUtils.nullIf(security, Security.DEFAULT);
        return this;
    }

    @Override
    public void start() throws IOException {
        try (ZipFile zip = new ZipFile(this.file(), 1, this.charset());){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            long maxSize = this.security.getCompressedTotalSize();
            long entryCount = 0L;
            while (entries.hasMoreElements()) {
                if (++entryCount > this.security.getEntryMaxCount()) {
                    throw new SecurityException(StringUtils.format("The file to unzip contains too many entries. [file={0}, max={1}]", this.file().getName(), this.security.getEntryMaxCount()));
                }
                ZipEntry entry = entries.nextElement();
                maxSize -= this.unzip(zip, entry, maxSize);
            }
        }
    }

    public Unzip target(File target) {
        this.target = target;
        return this;
    }

    private void createDirectory(File target) throws IOException {
        if (!target.exists()) {
            this.createDirectory(target.getParentFile());
            return;
        }
        if (!target.isDirectory()) {
            if (this.override()) {
                Files.delete(target.toPath());
                Files.createDirectory(target.toPath(), new FileAttribute[0]);
            } else {
                throw new IOException(StringUtils.format("File already exists. Cannot create directory. [name={0}]", target.getName()));
            }
        }
    }

    private long decompress(ZipFile zip, ZipEntry entry, File target, long maxSize) throws IOException {
        byte[] buffer = new byte[1024];
        long compressed = 0L;
        try (InputStream in = zip.getInputStream(entry);
             FileOutputStream out = new FileOutputStream(target, false);){
            int part;
            while ((part = in.read(buffer, 0, buffer.length)) >= 0) {
                if ((compressed += (long)part) > maxSize) {
                    throw new SecurityException(StringUtils.format("The file to unzip is too large. [file={0}, max={1}]", this.file().getName(), this.security.getCompressedTotalSize()));
                }
                ((OutputStream)out).write(buffer, 0, part);
            }
        }
        return compressed;
    }

    private void deleteFile(File target) throws IOException {
        if (target.exists()) {
            if (this.override()) {
                Files.delete(target.toPath());
            } else {
                throw new IOException(StringUtils.format("File already exists. Cannot unzip entry. [name={0}]", target.getName()));
            }
        }
    }

    private boolean filter(ZipEntry entry) {
        return FunctionUtils.test(this.predicate, entry, true);
    }

    private File getTarget(ZipEntry entry) {
        for (Function<ZipEntry, Redirect> redirector : this.redirectors) {
            Redirect redirect = redirector.apply(entry);
            if (!redirect.redirected) continue;
            return this.getActualTarget(redirect.redirectedFile);
        }
        String name = entry.getName();
        File actualTarget = new File(name);
        return this.getActualTarget(actualTarget);
    }

    private File getActualTarget(File target) {
        File actual = target;
        if (!target.isAbsolute()) {
            actual = new File(this.getTargetDirectory(), target.getPath());
        }
        return FileUtils.canonicalize(actual);
    }

    private File getTargetDirectory() {
        return ObjectUtils.nullIf(this.target, this.file().getParentFile());
    }

    private ConflictResolutionPolicy resolveConflict(ZipEntry entry, File target) {
        if (!this.conflictResolvers.isEmpty()) {
            Conflict conflict = new Conflict(entry, target);
            for (Function<Conflict, ConflictResolutionPolicy> resolver : this.conflictResolvers) {
                ConflictResolutionPolicy policy = resolver.apply(conflict);
                if (policy == null) continue;
                return policy;
            }
        }
        return this.conflictResolutionPolicy;
    }

    private long unzip(ZipFile zip, ZipEntry entry, long maxSize) throws IOException {
        if (!this.filter(entry)) {
            return 0L;
        }
        File actualTarget = this.getTarget(entry);
        if (actualTarget.exists()) {
            ConflictResolutionPolicy policy = this.resolveConflict(entry, actualTarget);
            switch (policy) {
                case SKIP: {
                    return 0L;
                }
                case ABORT: {
                    throw new IOException(StringUtils.format("File already exists. Cannot unzip entry. [entry={0}]", entry.getName()));
                }
            }
        }
        return this.unzipByOverride(zip, entry, maxSize, actualTarget);
    }

    private long unzipByOverride(ZipFile zip, ZipEntry entry, long maxSize, File actualTarget) throws IOException {
        FileUtils.ensureDirectory(actualTarget.getParentFile());
        if (entry.isDirectory()) {
            this.createDirectory(actualTarget);
            return 0L;
        }
        this.deleteFile(actualTarget);
        return this.decompress(zip, entry, actualTarget, maxSize);
    }

    public static class Conflict {
        private final ZipEntry entry;
        private final File target;

        public Conflict(ZipEntry entry, File target) {
            this.entry = entry;
            this.target = target;
        }

        @Generated
        public ZipEntry getEntry() {
            return this.entry;
        }

        @Generated
        public File getTarget() {
            return this.target;
        }
    }

    public static class Redirect {
        private static final Redirect EMPTY = new Redirect(false, null);
        private final boolean redirected;
        private final File redirectedFile;

        private Redirect(boolean redirected, File redirectedFile) {
            this.redirected = redirected;
            this.redirectedFile = redirectedFile;
            if (this.redirected) {
                Validation.notNull(this.redirectedFile, "The redirected file cannot be null when redirected is true.", new Object[0]);
            }
        }

        public static Redirect unredirected() {
            return EMPTY;
        }

        public static Redirect redirected(File redirectedFile) {
            return new Redirect(true, redirectedFile);
        }
    }

    public static class Security {
        public static final Security DEFAULT = new Security(0x6400000L, 1024L);
        private final long compressedTotalSize;
        private final long entryMaxCount;

        public Security(long compressedTotalSize, long entryMaxCount) {
            this.compressedTotalSize = compressedTotalSize;
            this.entryMaxCount = entryMaxCount;
        }

        public String toString() {
            return StringUtils.format("[compressedTotalSize={0}, entryMaxCount={1}]", this.getCompressedTotalSize(), this.getEntryMaxCount());
        }

        @Generated
        public long getCompressedTotalSize() {
            return this.compressedTotalSize;
        }

        @Generated
        public long getEntryMaxCount() {
            return this.entryMaxCount;
        }
    }
}

