/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util.support;

import com.huawei.fitframework.core.common.util.ClassScanner;
import com.huawei.fitframework.core.common.util.FunctionUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.UrlUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlClassLoaderScanner
implements ClassScanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UrlClassLoaderScanner.class);
    private static final String CLASS_NAME_EXTENSION = ".class";
    private final URLClassLoader classLoader;
    private final Stack<URL> urlStack;
    private final Set<URL> urlVisited;
    private final Predicate<URL> urlFilter;
    private Consumer<String> classDetectedObserver;
    private Predicate<String> classNameFilter;

    public UrlClassLoaderScanner(URLClassLoader classLoader, Predicate<URL> urlFilter) {
        this.classLoader = Validation.notNull(classLoader, "The URL class loader to scan cannot be null.", new Object[0]);
        this.urlStack = new Stack();
        this.urlFilter = ObjectUtils.nullIf(urlFilter, url -> true);
        this.urlVisited = new HashSet<URL>();
    }

    @Override
    public final URLClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public final void addClassDetectedObserver(Consumer<String> observer) {
        this.classDetectedObserver = FunctionUtils.connect(this.classDetectedObserver, observer);
    }

    @Override
    public final void addClassNameFilter(Predicate<String> classNameFilter) {
        this.classNameFilter = FunctionUtils.and(this.classNameFilter, classNameFilter);
    }

    @Override
    public void scan() {
        URL[] urls = this.classLoader.getURLs();
        this.push(urls);
        while (!this.urlStack.isEmpty()) {
            URL url = this.urlStack.pop();
            if (this.urlVisited.contains(url) || !this.urlFilter.test(url)) continue;
            this.createURLScanner(url).scan(url);
            this.urlVisited.add(url);
        }
    }

    private UrlScanner createURLScanner(URL url) {
        if (UrlUtils.isJar(url)) {
            return new JarUrlScanner(this);
        }
        if (UrlUtils.isJarInJar(url)) {
            return new JarInJarUrlScanner(this);
        }
        return new FileUrlScanner(this);
    }

    private void onClassDetected(String name) {
        String className = StringUtils.substring(name, 0, -CLASS_NAME_EXTENSION.length());
        if (UrlClassLoaderScanner.isValidClassName(className = className.replace('/', '.').replace('\\', '.')) && FunctionUtils.test(this.classNameFilter, className, true)) {
            this.notify(this.classDetectedObserver, className);
        }
    }

    private static boolean isValidClassName(String className) {
        return !className.contains("-");
    }

    private void notify(Consumer<String> observer, String value) {
        if (observer != null) {
            observer.accept(value);
        }
    }

    private void push(URL[] urls) {
        if (urls.length == 0) {
            return;
        }
        Stream.of(urls).forEach(this.urlStack::push);
    }

    private static abstract class AbstractJarUrlScanner
    extends UrlScanner {
        private static final URL[] EMPTY = new URL[0];

        public AbstractJarUrlScanner(UrlClassLoaderScanner scanner) {
            super(scanner);
        }

        @Override
        public void scan(URL url) {
            if (!this.isUrlExist(url)) {
                return;
            }
            try (JarInputStream jarInputStream = new JarInputStream(url.openStream());){
                URL[] urls = this.getClassPathUrls(url, jarInputStream.getManifest());
                this.scanner.push(urls);
                JarEntry entry = jarInputStream.getNextJarEntry();
                while (entry != null) {
                    if (!entry.isDirectory()) {
                        this.onResourceEntryDetected(entry);
                    }
                    entry = jarInputStream.getNextJarEntry();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(StringUtils.format("Fail to load JAR file. [url={0}]", url.toExternalForm()), e);
            }
        }

        protected abstract boolean isUrlExist(URL var1);

        private URL[] getClassPathUrls(URL base, Manifest manifest) throws IOException {
            return Optional.ofNullable(manifest).map(Manifest::getMainAttributes).map(attr -> attr.getValue(Attributes.Name.CLASS_PATH)).map(classPathValue -> this.parseClassPath(base, (String)classPathValue)).orElse(EMPTY);
        }

        private URL[] parseClassPath(URL base, String classPathValue) {
            try {
                List<String> classPaths = StringUtils.splitToList(classPathValue, ' ');
                URL[] urls = new URL[classPaths.size()];
                for (int i = 0; i < classPaths.size(); ++i) {
                    urls[i] = new URL(base, classPaths.get(i));
                }
                return urls;
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(StringUtils.format("Fail to parse class path. [classPath={0}]", classPathValue), e);
            }
        }

        private void onResourceEntryDetected(JarEntry entry) {
            String name = entry.getName();
            if (name.endsWith(UrlClassLoaderScanner.CLASS_NAME_EXTENSION)) {
                this.scanner.onClassDetected(name);
            }
        }
    }

    private static class JarInJarUrlScanner
    extends AbstractJarUrlScanner {
        public JarInJarUrlScanner(UrlClassLoaderScanner scanner) {
            super(scanner);
        }

        @Override
        protected boolean isUrlExist(URL url) {
            return true;
        }
    }

    private static class JarUrlScanner
    extends AbstractJarUrlScanner {
        public JarUrlScanner(UrlClassLoaderScanner scanner) {
            super(scanner);
        }

        @Override
        protected boolean isUrlExist(URL url) {
            return UrlUtils.exists(url);
        }
    }

    private static class FileUrlScanner
    extends UrlScanner {
        public FileUrlScanner(UrlClassLoaderScanner scanner) {
            super(scanner);
        }

        @Override
        public void scan(URL url) {
            File file = new File(url.getPath());
            if (file.isDirectory()) {
                this.scanDirectory(file);
                return;
            }
            if (file.getName().endsWith(UrlClassLoaderScanner.CLASS_NAME_EXTENSION)) {
                this.scanner.onClassDetected(file.getName());
            }
        }

        private void scanDirectory(File directory) {
            try {
                Path root = directory.toPath();
                Files.walk(root, Integer.MAX_VALUE, new FileVisitOption[0]).filter(path -> path.toFile().getName().endsWith(UrlClassLoaderScanner.CLASS_NAME_EXTENSION)).forEach(path -> this.scanner.onClassDetected(root.relativize((Path)path).toFile().getPath()));
            }
            catch (IOException e) {
                throw new IllegalStateException(StringUtils.format("Fail to scan class directory. [directory={0}]", directory.getPath()), e);
            }
        }
    }

    private static abstract class UrlScanner {
        protected final UrlClassLoaderScanner scanner;

        public UrlScanner(UrlClassLoaderScanner scanner) {
            this.scanner = scanner;
        }

        public abstract void scan(URL var1);
    }
}

