/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.util;

import com.huawei.smartkit.drop.util.StringUtils;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IpUtils {
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);
    private static final String REGEXP_IP_V4 = "^((25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))\\.){3}(25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))$";
    private static final Pattern PATTERN_IP_V4 = Pattern.compile("^((25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))\\.){3}(25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))$");
    private static final String REGEX_IP_V6 = "^\\s*((([\\dA-Fa-f]{1,4}:){7}(([\\dA-Fa-f]{1,4})|:))|(([\\dA-Fa-f]{1,4}:){6}(:|((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})|(:[\\dA-Fa-f]{1,4})))|(([\\dA-Fa-f]{1,4}:){5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[\\dA-Fa-f]{1,4}){1,2})))|(([\\dA-Fa-f]{1,4}:){4}(:[\\dA-Fa-f]{1,4})?((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[\\dA-Fa-f]{1,4}){1,2})))|(([\\dA-Fa-f]{1,4}:){3}(:[\\dA-Fa-f]{1,4}){0,2}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[\\dA-Fa-f]{1,4}){1,2})))|(([\\dA-Fa-f]{1,4}:){2}(:[\\dA-Fa-f]{1,4}){0,3}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[\\dA-Fa-f]{1,4}){1,2})))|(([\\dA-Fa-f]{1,4}:)(:[\\dA-Fa-f]{1,4}){0,4}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[\\dA-Fa-f]{1,4}){1,2})))|(:(:[\\dA-Fa-f]{1,4}){0,5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[\\dA-Fa-f]{1,4}){1,2})))|((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3}))(%.+)?\\s*$";
    private static final Pattern PATTERN_IP_V6 = Pattern.compile("^\\s*((([\\dA-Fa-f]{1,4}:){7}(([\\dA-Fa-f]{1,4})|:))|(([\\dA-Fa-f]{1,4}:){6}(:|((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})|(:[\\dA-Fa-f]{1,4})))|(([\\dA-Fa-f]{1,4}:){5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[\\dA-Fa-f]{1,4}){1,2})))|(([\\dA-Fa-f]{1,4}:){4}(:[\\dA-Fa-f]{1,4})?((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[\\dA-Fa-f]{1,4}){1,2})))|(([\\dA-Fa-f]{1,4}:){3}(:[\\dA-Fa-f]{1,4}){0,2}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[\\dA-Fa-f]{1,4}){1,2})))|(([\\dA-Fa-f]{1,4}:){2}(:[\\dA-Fa-f]{1,4}){0,3}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[\\dA-Fa-f]{1,4}){1,2})))|(([\\dA-Fa-f]{1,4}:)(:[\\dA-Fa-f]{1,4}){0,4}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[\\dA-Fa-f]{1,4}){1,2})))|(:(:[\\dA-Fa-f]{1,4}){0,5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[\\dA-Fa-f]{1,4}){1,2})))|((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3}))(%.+)?\\s*$");

    public static boolean isValidIpV6(String ipV6) {
        if (StringUtils.isEmpty(ipV6)) {
            return false;
        }
        if (!PATTERN_IP_V6.matcher(ipV6).matches()) {
            return false;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(ipV6);
            if (inetAddress instanceof Inet6Address) {
                Inet6Address address = (Inet6Address)inetAddress;
                return !address.isMulticastAddress() && !address.isLoopbackAddress() && !address.isAnyLocalAddress();
            }
        }
        catch (UnknownHostException e) {
            log.warn("check ip v6 {} is failed.", (Object)ipV6, (Object)e);
        }
        return false;
    }

    public static boolean isValidIpV4(String ipV4) {
        if ("localhost".equals(ipV4) || "127.0.0.1".equals(ipV4)) {
            return true;
        }
        if (StringUtils.isEmpty(ipV4)) {
            return false;
        }
        if (!PATTERN_IP_V4.matcher(ipV4).matches()) {
            return false;
        }
        try {
            InetAddress address = InetAddress.getByName(ipV4);
            return address != null && !address.isMulticastAddress() && !address.isLoopbackAddress() && !address.isAnyLocalAddress();
        }
        catch (UnknownHostException e) {
            log.warn("check ip v4 {} is failed.", (Object)ipV4, (Object)e);
            return false;
        }
    }

    private IpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

